/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block.grower;

import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractMegaTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;

public class LaurelTreeGrower
extends AbstractMegaTreeGrower {
    public boolean m_213817_(ServerLevel level, ChunkGenerator generator, BlockPos pos, BlockState state, RandomSource random) {
        for (int x = 0; x >= -1; --x) {
            for (int z = 0; z >= -1; --z) {
                if (!LaurelTreeGrower.m_59998_((BlockState)state, (BlockGetter)level, (BlockPos)pos, (int)x, (int)z)) continue;
                return this.m_222896_(level, generator, pos, state, random, x, z);
            }
        }
        return this.growLaurelTree(level, generator, pos, state, random);
    }

    public boolean growLaurelTree(ServerLevel level, ChunkGenerator generator, BlockPos pos, BlockState state, RandomSource random) {
        Holder<? extends ConfiguredFeature<?, ?>> holder = this.getConfiguredFeature(random, this.hasOranges((LevelAccessor)level, pos), level.m_220362_().equals((Object)BuiltinDimensionTypes.f_223539_));
        SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, holder);
        if (event.getResult().equals((Object)Event.Result.DENY) || holder == null) {
            return false;
        }
        ConfiguredFeature configuredfeature = (ConfiguredFeature)holder.m_203334_();
        BlockState blockstate = level.m_6425_(pos).m_76188_();
        level.m_7731_(pos, blockstate, 4);
        if (configuredfeature.m_224953_((WorldGenLevel)level, generator, random, pos)) {
            if (level.m_8055_(pos) == blockstate) {
                level.m_7260_(pos, state, blockstate, 2);
            }
            return true;
        }
        level.m_7731_(pos, state, 4);
        return false;
    }

    public boolean m_222896_(ServerLevel level, ChunkGenerator generator, BlockPos pos, BlockState state, RandomSource random, int x, int z) {
        Holder<? extends ConfiguredFeature<?, ?>> holder = this.getConfiguredMegaFeature(random, this.hasOranges((LevelAccessor)level, pos), level.m_220362_().equals((Object)BuiltinDimensionTypes.f_223539_));
        SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, holder);
        if (event.getResult().equals((Object)Event.Result.DENY) || event.getFeature() == null) {
            return false;
        }
        ConfiguredFeature configuredfeature = (ConfiguredFeature)event.getFeature().m_203334_();
        BlockState blockstate = Blocks.f_50016_.m_49966_();
        level.m_7731_(pos.m_7918_(x, 0, z), blockstate, 4);
        level.m_7731_(pos.m_7918_(x + 1, 0, z), blockstate, 4);
        level.m_7731_(pos.m_7918_(x, 0, z + 1), blockstate, 4);
        level.m_7731_(pos.m_7918_(x + 1, 0, z + 1), blockstate, 4);
        if (configuredfeature.m_224953_((WorldGenLevel)level, generator, random, pos.m_7918_(x, 0, z))) {
            return true;
        }
        level.m_7731_(pos.m_7918_(x, 0, z), state, 4);
        level.m_7731_(pos.m_7918_(x + 1, 0, z), state, 4);
        level.m_7731_(pos.m_7918_(x, 0, z + 1), state, 4);
        level.m_7731_(pos.m_7918_(x + 1, 0, z + 1), state, 4);
        return false;
    }

    private boolean hasOranges(LevelAccessor level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.MutableBlockPos.m_121940_((BlockPos)pos.m_7495_().m_122013_(3).m_122025_(3), (BlockPos)pos.m_6630_(5).m_122020_(3).m_122030_(3))) {
            if (!level.m_8055_(blockpos).m_204336_(AtmosphericBlockTags.ORANGES)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected Holder<? extends ConfiguredFeature<?, ?>> getConfiguredFeature(RandomSource random, boolean oranges, boolean nether) {
        return oranges ? (nether ? this.getConfiguredNetherFeature(random) : this.getConfiguredOrangesFeature(random)) : this.m_213888_(random, false);
    }

    @Nullable
    protected Holder<? extends ConfiguredFeature<?, ?>> m_213888_(RandomSource random, boolean flowers) {
        return (Holder)AtmosphericFeatures.AtmosphericConfiguredFeatures.LAUREL.getHolder().get();
    }

    protected Holder<? extends ConfiguredFeature<?, ?>> getConfiguredNetherFeature(RandomSource random) {
        return (Holder)AtmosphericFeatures.AtmosphericConfiguredFeatures.LAUREL_BLOOD_ORANGES_08.getHolder().get();
    }

    protected Holder<? extends ConfiguredFeature<?, ?>> getConfiguredOrangesFeature(RandomSource random) {
        return (Holder)AtmosphericFeatures.AtmosphericConfiguredFeatures.LAUREL_ORANGES_08.getHolder().get();
    }

    protected Holder<? extends ConfiguredFeature<?, ?>> getConfiguredMegaFeature(RandomSource random, boolean oranges, boolean nether) {
        return oranges ? (nether ? this.getConfiguredNetherMegaFeature(random) : this.getConfiguredOrangesMegaFeature(random)) : this.m_213566_(random);
    }

    @Nullable
    protected Holder<? extends ConfiguredFeature<?, ?>> m_213566_(RandomSource random) {
        return this.shouldBeGiant(random) ? (Holder)AtmosphericFeatures.AtmosphericConfiguredFeatures.GIANT_LAUREL.getHolder().get() : (Holder)AtmosphericFeatures.AtmosphericConfiguredFeatures.LARGE_LAUREL.getHolder().get();
    }

    protected Holder<? extends ConfiguredFeature<?, ?>> getConfiguredOrangesMegaFeature(RandomSource random) {
        return this.shouldBeGiant(random) ? (Holder)AtmosphericFeatures.AtmosphericConfiguredFeatures.GIANT_LAUREL_ORANGES_08.getHolder().get() : (Holder)AtmosphericFeatures.AtmosphericConfiguredFeatures.LARGE_LAUREL_ORANGES_08.getHolder().get();
    }

    protected Holder<? extends ConfiguredFeature<?, ?>> getConfiguredNetherMegaFeature(RandomSource random) {
        return this.shouldBeGiant(random) ? (Holder)AtmosphericFeatures.AtmosphericConfiguredFeatures.GIANT_LAUREL_BLOOD_ORANGES_08.getHolder().get() : (Holder)AtmosphericFeatures.AtmosphericConfiguredFeatures.LARGE_LAUREL_BLOOD_ORANGES_08.getHolder().get();
    }

    public boolean shouldBeGiant(RandomSource random) {
        return random.m_188503_(3) == 0;
    }
}

