/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity;

import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.network.NetworkHooks;

public class OrangeVaporCloud
extends Entity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(OrangeVaporCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_BLOOD_ORANGE = SynchedEntityData.m_135353_(OrangeVaporCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int duration = 600;
    private float radiusPerTick;

    public OrangeVaporCloud(EntityType<? extends OrangeVaporCloud> p_19704_, Level p_19705_) {
        super(p_19704_, p_19705_);
        this.f_19794_ = true;
        this.setRadius(1.5f);
    }

    public OrangeVaporCloud(Level level, double x, double y, double z) {
        this((EntityType<? extends OrangeVaporCloud>)((EntityType)AtmosphericEntityTypes.ORANGE_VAPOR_CLOUD.get()), level);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(0.5f));
        this.m_20088_().m_135372_(IS_BLOOD_ORANGE, (Object)false);
    }

    public void setRadius(float radius) {
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(DATA_RADIUS)).floatValue();
    }

    public boolean isBloodOrange() {
        return (Boolean)this.m_20088_().m_135370_(IS_BLOOD_ORANGE);
    }

    public void setBloodOrange(boolean bloodOrange) {
        this.m_20088_().m_135381_(IS_BLOOD_ORANGE, (Object)bloodOrange);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int p_19735_) {
        this.duration = p_19735_;
    }

    public void m_8119_() {
        block8: {
            List list1;
            float f;
            block7: {
                boolean fresh;
                super.m_8119_();
                f = this.getRadius();
                if (!this.f_19853_.f_46443_) break block7;
                int i = Mth.m_14167_((float)((float)Math.PI * f * f * 0.05f));
                boolean bl = fresh = this.f_19797_ < 4;
                if (fresh) {
                    i *= 15;
                }
                for (int j = 0; j < i; ++j) {
                    if (!fresh && this.f_19796_.m_188503_(8) != 0) continue;
                    float f2 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float f3 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f;
                    double d0 = this.m_20185_() + (double)(Mth.m_14089_((float)f2) * f3);
                    double d2 = this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.getHeight());
                    double d4 = this.m_20189_() + (double)(Mth.m_14031_((float)f2) * f3);
                    double d5 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                    double d6 = 0.15;
                    double d7 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                    this.f_19853_.m_7107_(this.isBloodOrange() ? (ParticleOptions)AtmosphericParticleTypes.BLOOD_ORANGE_VAPOR.get() : (ParticleOptions)AtmosphericParticleTypes.ORANGE_VAPOR.get(), d0, d2, d4, d5, d6, d7);
                }
                break block8;
            }
            if (this.f_19797_ >= this.duration) {
                this.m_146870_();
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                f += this.radiusPerTick;
                if (this.f_19853_.m_6042_().f_63857_() && !this.isBloodOrange()) {
                    f += this.radiusPerTick * 4.0f;
                }
                if (f < 0.5f) {
                    this.m_146870_();
                    return;
                }
                this.setRadius(f);
            }
            if (this.f_19797_ % 5 != 0 || (list1 = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_())).isEmpty()) break block8;
            for (LivingEntity livingentity : list1) {
                if (!(livingentity instanceof Wolf)) continue;
                Wolf wolf = (Wolf)livingentity;
                wolf.f_30363_ = true;
            }
        }
    }

    public void setRadiusPerTick(float p_19739_) {
        this.radiusPerTick = p_19739_;
    }

    protected void m_7378_(CompoundTag tag) {
        this.f_19797_ = tag.m_128451_("Age");
        this.duration = tag.m_128451_("Duration");
        this.radiusPerTick = tag.m_128457_("RadiusPerTick");
        this.setRadius(tag.m_128457_("Radius"));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("Age", this.f_19797_);
        tag.m_128405_("Duration", this.duration);
        tag.m_128350_("RadiusPerTick", this.radiusPerTick);
        tag.m_128350_("Radius", this.getRadius());
    }

    public void m_7350_(EntityDataAccessor<?> p_19729_) {
        if (DATA_RADIUS.equals(p_19729_)) {
            this.m_6210_();
        }
        super.m_7350_(p_19729_);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getHeight() {
        return this.getRadius() * 2.0f;
    }

    public EntityDimensions m_6972_(Pose p_19721_) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)this.getHeight());
    }
}

