/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.ai.goal;

import com.teamabnormals.atmospheric.common.entity.Cochineal;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericItemTags;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class CochinealEatDragonFruitGoal
extends Goal {
    private final Cochineal cochineal;
    private final double moveSpeed;
    private ItemEntity itemEntity;
    private int eatTime;
    private int delayCounter;

    public CochinealEatDragonFruitGoal(Cochineal cochineal, double speed) {
        this.cochineal = cochineal;
        this.moveSpeed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.cochineal.m_146764_() != 0 || !this.cochineal.m_5957_() || this.cochineal.m_217043_().m_188503_(this.m_183277_(20)) != 0) {
            return false;
        }
        List list = this.cochineal.m_9236_().m_6443_(ItemEntity.class, this.cochineal.m_20191_().m_82377_(12.0, 4.0, 12.0), itemEntity -> this.cochineal.m_6898_(itemEntity.m_32055_()));
        ItemEntity itementity = null;
        double d0 = Double.MAX_VALUE;
        for (ItemEntity itementity1 : list) {
            double d1 = this.cochineal.m_20280_((Entity)itementity1);
            if (!(d1 < d0)) continue;
            d0 = d1;
            itementity = itementity1;
        }
        if (itementity != null) {
            this.itemEntity = itementity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.cochineal.m_146764_() == 0 && this.cochineal.m_5957_() && this.itemEntity != null && this.itemEntity.m_6084_() && this.cochineal.m_20280_((Entity)this.itemEntity) <= 256.0;
    }

    public void m_8056_() {
        this.eatTime = this.m_183277_(80);
        this.delayCounter = 0;
    }

    public void m_8041_() {
        this.cochineal.setEatingStack(ItemStack.f_41583_);
    }

    public void m_8037_() {
        if (this.cochineal.m_20191_().m_82400_(0.5).m_82381_(this.itemEntity.m_20191_())) {
            if (this.cochineal.m_20096_() || this.cochineal.isInFluidType()) {
                this.cochineal.setEatingStack(this.itemEntity.m_32055_());
                this.cochineal.m_21563_().m_24960_((Entity)this.itemEntity, 10.0f, (float)this.cochineal.m_8132_());
                if (this.eatTime-- <= 0) {
                    Player player = this.itemEntity.m_32057_() != null ? this.cochineal.f_19853_.m_46003_(this.itemEntity.m_32057_()) : null;
                    this.cochineal.m_27595_(player);
                    this.cochineal.m_146850_(GameEvent.f_157806_);
                    if (this.itemEntity.m_32055_().m_204117_(AtmosphericItemTags.COCHINEAL_SUPER_LOVE_FOOD)) {
                        this.cochineal.setSuperInLove(true);
                    }
                    ItemStack itemstack = this.itemEntity.m_32055_().m_41777_();
                    itemstack.m_41774_(1);
                    if (itemstack.m_41619_()) {
                        this.itemEntity.m_146870_();
                    } else {
                        this.itemEntity.m_32045_(itemstack);
                    }
                }
            }
        } else {
            this.cochineal.setEatingStack(ItemStack.f_41583_);
            if (this.cochineal.isInFluidType()) {
                if (--this.delayCounter <= 0) {
                    this.delayCounter = this.m_183277_(20);
                    Path path = this.cochineal.m_21573_().m_6570_((Entity)this.itemEntity, 0);
                    if (path != null) {
                        this.cochineal.m_21573_().m_26536_(path, this.moveSpeed);
                    }
                }
            } else if (this.cochineal.canLeap()) {
                Cochineal.CochinealMoveControl control = (Cochineal.CochinealMoveControl)this.cochineal.m_21566_();
                Vec3 vec3 = this.itemEntity.m_20182_();
                if (this.cochineal.m_20238_(vec3) < 64.0 && control.canReach(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)) {
                    control.leapTo(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                } else {
                    Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.cochineal, (int)12, (int)3, (Vec3)vec3, (double)0.5235987755982988);
                    if (vec31 != null) {
                        vec31.m_82520_(0.5, 0.0, 0.5);
                        if (control.canReach(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_)) {
                            control.leapTo(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                        }
                    }
                }
            }
        }
    }
}

