/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.client;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.atmospheric.common.block.DragonRootsBlock;
import com.teamabnormals.atmospheric.common.block.OrangeBlock;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericBlockFamilies;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.block.VerticalSlabBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AtmosphericBlockStateProvider
extends BlockStateProvider {
    public static final BooleanProperty[] CHAINED = new BooleanProperty[]{BooleanProperty.m_61465_((String)"chain_down"), BooleanProperty.m_61465_((String)"chain_up"), BooleanProperty.m_61465_((String)"chain_north"), BooleanProperty.m_61465_((String)"chain_south"), BooleanProperty.m_61465_((String)"chain_west"), BooleanProperty.m_61465_((String)"chain_east")};

    public AtmosphericBlockStateProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "atmospheric", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockFamily(AtmosphericBlockFamilies.DOLERITE_FAMILY, (Block)AtmosphericBlocks.DOLERITE_VERTICAL_SLAB.get());
        this.blockFamily(AtmosphericBlockFamilies.POLISHED_DOLERITE_FAMILY, (Block)AtmosphericBlocks.POLISHED_DOLERITE_VERTICAL_SLAB.get());
        this.blockFamily(AtmosphericBlockFamilies.ROSEWOOD_PLANKS_FAMILY, (Block)AtmosphericBlocks.ROSEWOOD_VERTICAL_SLAB.get());
        this.logBlocks((Block)AtmosphericBlocks.ROSEWOOD_LOG.get(), (Block)AtmosphericBlocks.ROSEWOOD.get());
        this.logBlocks((Block)AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_ROSEWOOD.get());
        this.leavesBlock((Block)AtmosphericBlocks.ROSEWOOD_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.ROSEWOOD_SAPLING.get(), (Block)AtmosphericBlocks.POTTED_ROSEWOOD_SAPLING.get());
        this.planksCompat((Block)AtmosphericBlocks.ROSEWOOD_PLANKS.get(), (Block)AtmosphericBlocks.ROSEWOOD_BOARDS.get(), (Block)AtmosphericBlocks.ROSEWOOD_LADDER.get(), (Block)AtmosphericBlocks.ROSEWOOD_BOOKSHELF.get(), (Block)AtmosphericBlocks.ROSEWOOD_BEEHIVE.get(), AtmosphericBlocks.ROSEWOOD_CHESTS, (Block)AtmosphericBlocks.VERTICAL_ROSEWOOD_PLANKS.get());
        this.logCompat((Block)AtmosphericBlocks.ROSEWOOD_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG.get(), (Block)AtmosphericBlocks.ROSEWOOD_POST.get(), (Block)AtmosphericBlocks.STRIPPED_ROSEWOOD_POST.get());
        this.leavesCompat((Block)AtmosphericBlocks.ROSEWOOD_LEAVES.get(), (Block)AtmosphericBlocks.ROSEWOOD_LOG.get(), (Block)AtmosphericBlocks.ROSEWOOD_LEAF_PILE.get(), (Block)AtmosphericBlocks.ROSEWOOD_HEDGE.get(), (Block)AtmosphericBlocks.ROSEWOOD_LEAF_CARPET.get());
        this.directionalBlock((Block)AtmosphericBlocks.PASSION_FRUIT_CRATE.get());
        this.directionalBlockSharedBottom((Block)AtmosphericBlocks.SHIMMERING_PASSION_FRUIT_CRATE.get(), (Block)AtmosphericBlocks.PASSION_FRUIT_CRATE.get());
        this.blockFamily(AtmosphericBlockFamilies.MORADO_PLANKS_FAMILY, (Block)AtmosphericBlocks.MORADO_VERTICAL_SLAB.get());
        this.logBlocks((Block)AtmosphericBlocks.MORADO_LOG.get(), (Block)AtmosphericBlocks.MORADO_WOOD.get());
        this.logBlocks((Block)AtmosphericBlocks.STRIPPED_MORADO_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_MORADO_WOOD.get());
        this.leavesBlock((Block)AtmosphericBlocks.MORADO_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.MORADO_SAPLING.get(), (Block)AtmosphericBlocks.POTTED_MORADO_SAPLING.get());
        this.planksCompat((Block)AtmosphericBlocks.MORADO_PLANKS.get(), (Block)AtmosphericBlocks.MORADO_BOARDS.get(), (Block)AtmosphericBlocks.MORADO_LADDER.get(), (Block)AtmosphericBlocks.MORADO_BOOKSHELF.get(), (Block)AtmosphericBlocks.MORADO_BEEHIVE.get(), AtmosphericBlocks.MORADO_CHESTS, (Block)AtmosphericBlocks.VERTICAL_MORADO_PLANKS.get());
        this.logCompat((Block)AtmosphericBlocks.MORADO_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_MORADO_LOG.get(), (Block)AtmosphericBlocks.MORADO_POST.get(), (Block)AtmosphericBlocks.STRIPPED_MORADO_POST.get());
        this.leavesCompat((Block)AtmosphericBlocks.MORADO_LEAVES.get(), (Block)AtmosphericBlocks.MORADO_LOG.get(), (Block)AtmosphericBlocks.MORADO_LEAF_PILE.get(), (Block)AtmosphericBlocks.MORADO_HEDGE.get(), (Block)AtmosphericBlocks.MORADO_LEAF_CARPET.get());
        this.blockFamily(AtmosphericBlockFamilies.YUCCA_PLANKS_FAMILY, (Block)AtmosphericBlocks.YUCCA_VERTICAL_SLAB.get());
        this.logBlocks((Block)AtmosphericBlocks.YUCCA_LOG.get(), (Block)AtmosphericBlocks.YUCCA_WOOD.get());
        this.logBlocks((Block)AtmosphericBlocks.STRIPPED_YUCCA_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_YUCCA_WOOD.get());
        this.leavesBlock((Block)AtmosphericBlocks.YUCCA_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.YUCCA_SAPLING.get(), (Block)AtmosphericBlocks.POTTED_YUCCA_SAPLING.get());
        this.planksCompat((Block)AtmosphericBlocks.YUCCA_PLANKS.get(), (Block)AtmosphericBlocks.YUCCA_BOARDS.get(), (Block)AtmosphericBlocks.YUCCA_LADDER.get(), (Block)AtmosphericBlocks.YUCCA_BOOKSHELF.get(), (Block)AtmosphericBlocks.YUCCA_BEEHIVE.get(), AtmosphericBlocks.YUCCA_CHESTS, (Block)AtmosphericBlocks.VERTICAL_YUCCA_PLANKS.get());
        this.logCompat((Block)AtmosphericBlocks.YUCCA_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_YUCCA_LOG.get(), (Block)AtmosphericBlocks.YUCCA_POST.get(), (Block)AtmosphericBlocks.STRIPPED_YUCCA_POST.get());
        this.leavesCompat((Block)AtmosphericBlocks.YUCCA_LEAVES.get(), (Block)AtmosphericBlocks.YUCCA_LOG.get(), (Block)AtmosphericBlocks.YUCCA_LEAF_PILE.get(), (Block)AtmosphericBlocks.YUCCA_HEDGE.get(), (Block)AtmosphericBlocks.YUCCA_LEAF_CARPET.get());
        this.directionalBlock((Block)AtmosphericBlocks.YUCCA_CASK.get());
        this.directionalBlockSharedSide((Block)AtmosphericBlocks.ROASTED_YUCCA_CASK.get(), (Block)AtmosphericBlocks.YUCCA_CASK.get());
        this.blockFamily(AtmosphericBlockFamilies.ASPEN_PLANKS_FAMILY, (Block)AtmosphericBlocks.ASPEN_VERTICAL_SLAB.get());
        this.logBlocks((Block)AtmosphericBlocks.ASPEN_LOG.get(), (Block)AtmosphericBlocks.ASPEN_WOOD.get());
        this.logBlocks((Block)AtmosphericBlocks.STRIPPED_ASPEN_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_ASPEN_WOOD.get());
        this.logBlocks((Block)AtmosphericBlocks.WATCHFUL_ASPEN_LOG.get(), (Block)AtmosphericBlocks.WATCHFUL_ASPEN_WOOD.get());
        this.leavesBlock((Block)AtmosphericBlocks.ASPEN_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.ASPEN_SAPLING.get(), (Block)AtmosphericBlocks.POTTED_ASPEN_SAPLING.get());
        this.planksCompat((Block)AtmosphericBlocks.ASPEN_PLANKS.get(), (Block)AtmosphericBlocks.ASPEN_BOARDS.get(), (Block)AtmosphericBlocks.ASPEN_LADDER.get(), (Block)AtmosphericBlocks.ASPEN_BOOKSHELF.get(), (Block)AtmosphericBlocks.ASPEN_BEEHIVE.get(), AtmosphericBlocks.ASPEN_CHESTS, (Block)AtmosphericBlocks.VERTICAL_ASPEN_PLANKS.get());
        this.logCompat((Block)AtmosphericBlocks.ASPEN_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_ASPEN_LOG.get(), (Block)AtmosphericBlocks.ASPEN_POST.get(), (Block)AtmosphericBlocks.STRIPPED_ASPEN_POST.get());
        this.leavesCompat((Block)AtmosphericBlocks.ASPEN_LEAVES.get(), (Block)AtmosphericBlocks.ASPEN_LOG.get(), (Block)AtmosphericBlocks.ASPEN_LEAF_PILE.get(), (Block)AtmosphericBlocks.ASPEN_HEDGE.get(), (Block)AtmosphericBlocks.ASPEN_LEAF_CARPET.get());
        this.leavesBlock((Block)AtmosphericBlocks.GREEN_ASPEN_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.GREEN_ASPEN_SAPLING.get(), (Block)AtmosphericBlocks.POTTED_GREEN_ASPEN_SAPLING.get());
        this.leavesCompat((Block)AtmosphericBlocks.GREEN_ASPEN_LEAVES.get(), (Block)AtmosphericBlocks.ASPEN_LOG.get(), (Block)AtmosphericBlocks.GREEN_ASPEN_LEAF_PILE.get(), (Block)AtmosphericBlocks.GREEN_ASPEN_HEDGE.get(), (Block)AtmosphericBlocks.GREEN_ASPEN_LEAF_CARPET.get());
        this.crossBlockWithCustomPot((Block)AtmosphericBlocks.AGAVE.get(), (Block)AtmosphericBlocks.POTTED_AGAVE.get());
        this.crossBlockWithCustomPot((Block)AtmosphericBlocks.GOLDEN_GROWTHS.get(), (Block)AtmosphericBlocks.POTTED_GOLDEN_GROWTHS.get());
        this.blockFamily(AtmosphericBlockFamilies.LAUREL_PLANKS_FAMILY, (Block)AtmosphericBlocks.LAUREL_VERTICAL_SLAB.get());
        this.logBlocks((Block)AtmosphericBlocks.LAUREL_LOG.get(), (Block)AtmosphericBlocks.LAUREL_WOOD.get());
        this.logBlocks((Block)AtmosphericBlocks.STRIPPED_LAUREL_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_LAUREL_WOOD.get());
        this.leavesBlock((Block)AtmosphericBlocks.LAUREL_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.LAUREL_SAPLING.get(), (Block)AtmosphericBlocks.POTTED_LAUREL_SAPLING.get());
        this.planksCompat((Block)AtmosphericBlocks.LAUREL_PLANKS.get(), (Block)AtmosphericBlocks.LAUREL_BOARDS.get(), (Block)AtmosphericBlocks.LAUREL_LADDER.get(), (Block)AtmosphericBlocks.LAUREL_BOOKSHELF.get(), (Block)AtmosphericBlocks.LAUREL_BEEHIVE.get(), AtmosphericBlocks.LAUREL_CHESTS, (Block)AtmosphericBlocks.VERTICAL_LAUREL_PLANKS.get());
        this.logCompat((Block)AtmosphericBlocks.LAUREL_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_LAUREL_LOG.get(), (Block)AtmosphericBlocks.LAUREL_POST.get(), (Block)AtmosphericBlocks.STRIPPED_LAUREL_POST.get());
        this.leavesCompat((Block)AtmosphericBlocks.LAUREL_LEAVES.get(), (Block)AtmosphericBlocks.LAUREL_LOG.get(), (Block)AtmosphericBlocks.LAUREL_LEAF_PILE.get(), (Block)AtmosphericBlocks.LAUREL_HEDGE.get(), (Block)AtmosphericBlocks.LAUREL_LEAF_CARPET.get());
        this.leavesBlock((Block)AtmosphericBlocks.DRY_LAUREL_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.DRY_LAUREL_SAPLING.get(), (Block)AtmosphericBlocks.POTTED_DRY_LAUREL_SAPLING.get());
        this.leavesCompat((Block)AtmosphericBlocks.DRY_LAUREL_LEAVES.get(), (Block)AtmosphericBlocks.LAUREL_LOG.get(), (Block)AtmosphericBlocks.DRY_LAUREL_LEAF_PILE.get(), (Block)AtmosphericBlocks.DRY_LAUREL_HEDGE.get(), (Block)AtmosphericBlocks.DRY_LAUREL_LEAF_CARPET.get());
        this.orange((Block)AtmosphericBlocks.ORANGE.get());
        this.orange((Block)AtmosphericBlocks.BLOOD_ORANGE.get());
        this.directionalBlock((Block)AtmosphericBlocks.ORANGE_CRATE.get());
        this.directionalBlock((Block)AtmosphericBlocks.BLOOD_ORANGE_CRATE.get());
        this.blockFamily(AtmosphericBlockFamilies.KOUSA_PLANKS_FAMILY, (Block)AtmosphericBlocks.KOUSA_VERTICAL_SLAB.get());
        this.logBlocks((Block)AtmosphericBlocks.KOUSA_LOG.get(), (Block)AtmosphericBlocks.KOUSA_WOOD.get());
        this.logBlocks((Block)AtmosphericBlocks.STRIPPED_KOUSA_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_KOUSA_WOOD.get());
        this.leavesBlock((Block)AtmosphericBlocks.KOUSA_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.KOUSA_SAPLING.get(), (Block)AtmosphericBlocks.POTTED_KOUSA_SAPLING.get());
        this.planksCompat((Block)AtmosphericBlocks.KOUSA_PLANKS.get(), (Block)AtmosphericBlocks.KOUSA_BOARDS.get(), (Block)AtmosphericBlocks.KOUSA_LADDER.get(), (Block)AtmosphericBlocks.KOUSA_BOOKSHELF.get(), (Block)AtmosphericBlocks.KOUSA_BEEHIVE.get(), AtmosphericBlocks.KOUSA_CHESTS, (Block)AtmosphericBlocks.VERTICAL_KOUSA_PLANKS.get());
        this.logCompat((Block)AtmosphericBlocks.KOUSA_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_KOUSA_LOG.get(), (Block)AtmosphericBlocks.KOUSA_POST.get(), (Block)AtmosphericBlocks.STRIPPED_KOUSA_POST.get());
        this.leavesCompat((Block)AtmosphericBlocks.KOUSA_LEAVES.get(), (Block)AtmosphericBlocks.KOUSA_LOG.get(), (Block)AtmosphericBlocks.KOUSA_LEAF_PILE.get(), (Block)AtmosphericBlocks.KOUSA_HEDGE.get(), (Block)AtmosphericBlocks.KOUSA_LEAF_CARPET.get());
        this.crossBlock((Block)AtmosphericBlocks.HANGING_CURRANT.get());
        this.logBlock((Block)AtmosphericBlocks.CURRANT_STALK_BUNDLE.get());
        this.leavesBlock((Block)AtmosphericBlocks.CURRANT_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.CURRANT_SEEDLING.get(), (Block)AtmosphericBlocks.POTTED_CURRANT_SEEDLING.get());
        this.leavesCompat((Block)AtmosphericBlocks.CURRANT_LEAVES.get(), (Block)AtmosphericBlocks.CURRANT_STALK.get(), (Block)AtmosphericBlocks.CURRANT_LEAF_PILE.get(), (Block)AtmosphericBlocks.CURRANT_HEDGE.get(), (Block)AtmosphericBlocks.CURRANT_LEAF_CARPET.get());
        this.directionalBlock((Block)AtmosphericBlocks.CURRANT_CRATE.get());
        this.blockFamily(AtmosphericBlockFamilies.GRIMWOOD_PLANKS_FAMILY, (Block)AtmosphericBlocks.GRIMWOOD_VERTICAL_SLAB.get());
        this.logBlocks((Block)AtmosphericBlocks.GRIMWOOD_LOG.get(), (Block)AtmosphericBlocks.GRIMWOOD.get());
        this.logBlocks((Block)AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_GRIMWOOD.get());
        this.leavesBlock((Block)AtmosphericBlocks.GRIMWOOD_LEAVES.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.GRIMWOOD_SAPLING.get(), (Block)AtmosphericBlocks.POTTED_GRIMWOOD_SAPLING.get());
        this.planksCompat((Block)AtmosphericBlocks.GRIMWOOD_PLANKS.get(), (Block)AtmosphericBlocks.GRIMWOOD_BOARDS.get(), (Block)AtmosphericBlocks.GRIMWOOD_LADDER.get(), (Block)AtmosphericBlocks.GRIMWOOD_BOOKSHELF.get(), (Block)AtmosphericBlocks.GRIMWOOD_BEEHIVE.get(), AtmosphericBlocks.GRIMWOOD_CHESTS, (Block)AtmosphericBlocks.VERTICAL_GRIMWOOD_PLANKS.get());
        this.logCompat((Block)AtmosphericBlocks.GRIMWOOD_LOG.get(), (Block)AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG.get(), (Block)AtmosphericBlocks.GRIMWOOD_POST.get(), (Block)AtmosphericBlocks.STRIPPED_GRIMWOOD_POST.get());
        this.leavesCompat((Block)AtmosphericBlocks.GRIMWOOD_LEAVES.get(), (Block)AtmosphericBlocks.GRIMWOOD_LOG.get(), (Block)AtmosphericBlocks.GRIMWOOD_LEAF_PILE.get(), (Block)AtmosphericBlocks.GRIMWOOD_HEDGE.get(), (Block)AtmosphericBlocks.GRIMWOOD_LEAF_CARPET.get());
        this.crossBlock((Block)AtmosphericBlocks.GRIMWEB.get());
        this.directionalBlock((Block)AtmosphericBlocks.CARMINE_BLOCK.get());
        this.blockFamily(AtmosphericBlockFamilies.CARMINE_SHINGLES_FAMILY, (Block)AtmosphericBlocks.CARMINE_SHINGLE_VERTICAL_SLAB.get());
        this.blockFamily(AtmosphericBlockFamilies.CARMINE_PAVEMENT_FAMILY, (Block)AtmosphericBlocks.CARMINE_PAVEMENT_VERTICAL_SLAB.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.FIRETHORN.get(), (Block)AtmosphericBlocks.POTTED_FIRETHORN.get());
        this.crossBlockWithPot((Block)AtmosphericBlocks.FORSYTHIA.get(), (Block)AtmosphericBlocks.POTTED_FORSYTHIA.get());
        this.directionalBlock((Block)AtmosphericBlocks.DRAGON_FRUIT_CRATE.get());
        this.directionalBlockSharedSide((Block)AtmosphericBlocks.GOLDEN_DRAGON_FRUIT_CRATE.get(), (Block)AtmosphericBlocks.DRAGON_FRUIT_CRATE.get());
        this.dragonRoots((Block)AtmosphericBlocks.DRAGON_ROOTS.get());
    }

    public void block(Block block) {
        this.simpleBlock(block, this.cubeAll(block));
        this.blockItem(block);
    }

    public void blockFamily(BlockFamily family, Block verticalSlab) {
        Block block = family.m_175951_();
        this.block(block);
        if (family.m_175954_().containsKey(BlockFamily.Variant.CHISELED)) {
            this.block(family.m_175952_(BlockFamily.Variant.CHISELED));
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.SLAB)) {
            SlabBlock slab = (SlabBlock)family.m_175952_(BlockFamily.Variant.SLAB);
            this.slabBlock(slab, this.blockTexture(block), this.blockTexture(block));
            this.blockItem((Block)slab);
            this.verticalSlabBlock(block, (VerticalSlabBlock)verticalSlab);
            this.blockItem(verticalSlab);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.STAIRS)) {
            StairBlock stairs = (StairBlock)family.m_175952_(BlockFamily.Variant.STAIRS);
            this.stairsBlock(stairs, this.blockTexture(block));
            this.blockItem((Block)stairs);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.WALL)) {
            WallBlock wall = (WallBlock)family.m_175952_(BlockFamily.Variant.WALL);
            this.wallBlock(wall, this.blockTexture(block));
            ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)wall))).parent((ModelFile)this.models().wallInventory(this.name((Block)wall) + "_inventory", this.blockTexture(block)));
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.FENCE)) {
            FenceBlock fence = (FenceBlock)family.m_175952_(BlockFamily.Variant.FENCE);
            this.fenceBlock(fence, this.blockTexture(block));
            ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)fence))).parent((ModelFile)this.models().fenceInventory(this.name((Block)fence) + "_inventory", this.blockTexture(block)));
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.FENCE_GATE)) {
            FenceGateBlock fenceGate = (FenceGateBlock)family.m_175952_(BlockFamily.Variant.FENCE_GATE);
            this.fenceGateBlock(fenceGate, this.blockTexture(block));
            this.blockItem((Block)fenceGate);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.BUTTON)) {
            ButtonBlock button = (ButtonBlock)family.m_175952_(BlockFamily.Variant.BUTTON);
            ModelBuilder buttonModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)button), "block/button")).texture("texture", this.blockTexture(block));
            ModelBuilder buttonPressedModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)button) + "_pressed", "block/button_pressed")).texture("texture", this.blockTexture(block));
            ModelBuilder buttonInventoryModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)button) + "_inventory", "block/button_inventory")).texture("texture", this.blockTexture(block));
            this.buttonBlock((Block)button, arg_0 -> AtmosphericBlockStateProvider.lambda$blockFamily$0((ModelFile)buttonPressedModel, (ModelFile)buttonModel, arg_0));
            ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)button))).parent((ModelFile)buttonInventoryModel);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.PRESSURE_PLATE)) {
            BasePressurePlateBlock pressurePlate = (BasePressurePlateBlock)family.m_175952_(BlockFamily.Variant.PRESSURE_PLATE);
            ModelBuilder pressurePlateModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)pressurePlate), "block/pressure_plate_up")).texture("texture", this.blockTexture(block));
            ModelBuilder pressurePlateDownModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)pressurePlate) + "_down", "block/pressure_plate_down")).texture("texture", this.blockTexture(block));
            this.pressurePlateBlock((Block)pressurePlate, arg_0 -> AtmosphericBlockStateProvider.lambda$blockFamily$1((ModelFile)pressurePlateDownModel, (ModelFile)pressurePlateModel, arg_0));
            this.blockItem((Block)pressurePlate);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.DOOR)) {
            DoorBlock door = (DoorBlock)family.m_175952_(BlockFamily.Variant.DOOR);
            this.doorBlock(door, this.suffix(this.blockTexture((Block)door), "_bottom"), this.suffix(this.blockTexture((Block)door), "_top"));
            this.generatedItem((ItemLike)door, "item");
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.TRAPDOOR)) {
            TrapDoorBlock trapdoor = (TrapDoorBlock)family.m_175952_(BlockFamily.Variant.TRAPDOOR);
            this.trapdoorBlock(trapdoor, this.blockTexture((Block)trapdoor), true);
            ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)trapdoor))).parent((ModelFile)this.models().trapdoorOrientableBottom(this.name((Block)trapdoor) + "_bottom", this.blockTexture((Block)trapdoor)));
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.SIGN)) {
            SignBlock sign = (SignBlock)family.m_175952_(BlockFamily.Variant.SIGN);
            this.simpleBlock((Block)sign, this.particle((Block)sign, this.blockTexture(block)));
            this.generatedItem((ItemLike)sign, "item");
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.WALL_SIGN)) {
            WallSignBlock wallSign = (WallSignBlock)family.m_175952_(BlockFamily.Variant.WALL_SIGN);
            this.simpleBlock((Block)wallSign, this.particle((Block)wallSign, this.blockTexture(block)));
        }
    }

    public void blockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper));
    }

    private void generatedItem(ItemLike item, String type) {
        this.generatedItem(item, item, type);
    }

    private void generatedItem(ItemLike item, ItemLike texture, String type) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_(), "item/generated")).texture("layer0", new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)texture.m_5456_()).m_135827_(), type + "/" + ForgeRegistries.ITEMS.getKey((Object)texture.m_5456_()).m_135815_()));
    }

    public void crossBlockWithPot(Block cross, Block flowerPot) {
        this.crossBlock(cross);
        this.simpleBlock(flowerPot, (ModelFile)this.models().singleTexture(this.name(flowerPot), new ResourceLocation("block/flower_pot_cross"), "plant", this.blockTexture(cross)));
    }

    public void crossBlockWithCustomPot(Block cross, Block flowerPot) {
        this.crossBlock(cross);
        this.simpleBlock(flowerPot, (ModelFile)this.models().singleTexture(this.name(flowerPot), new ResourceLocation("block/flower_pot_cross"), "plant", this.blockTexture(flowerPot)));
    }

    public void crossBlock(Block cross) {
        this.simpleBlock(cross, (ModelFile)this.models().cross(this.name(cross), this.blockTexture(cross)));
        this.generatedItem((ItemLike)cross, "block");
    }

    public void cubeBottomTopBlock(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), this.suffix(this.blockTexture(block), "_side"), this.suffix(this.blockTexture(block), "_bottom"), this.suffix(this.blockTexture(block), "_top")));
        this.blockItem(block);
    }

    public void directionalBlock(Block block) {
        this.directionalBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), this.suffix(this.blockTexture(block), "_side"), this.suffix(this.blockTexture(block), "_bottom"), this.suffix(this.blockTexture(block), "_top")));
        this.blockItem(block);
    }

    public void cubeBottomTopBlock(Block block, Block parent) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), this.suffix(this.blockTexture(parent), "_side"), this.suffix(this.blockTexture(parent), "_bottom"), this.suffix(this.blockTexture(block), "_top")));
        this.blockItem(block);
    }

    public void directionalBlockSharedSide(Block block, Block parent) {
        this.directionalBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), this.suffix(this.blockTexture(parent), "_side"), this.suffix(this.blockTexture(parent), "_bottom"), this.suffix(this.blockTexture(block), "_top")));
        this.blockItem(block);
    }

    public void directionalBlockSharedBottom(Block block, Block parent) {
        this.directionalBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), this.suffix(this.blockTexture(block), "_side"), this.suffix(this.blockTexture(parent), "_bottom"), this.suffix(this.blockTexture(block), "_top")));
        this.blockItem(block);
    }

    public void bookshelfBlock(Block planks, Block bookshelf) {
        this.simpleBlock(bookshelf, (ModelFile)this.models().cubeColumn(this.name(bookshelf), this.blockTexture(bookshelf), this.blockTexture(planks)));
        this.blockItem(bookshelf);
    }

    public void ladderBlock(Block ladder) {
        this.horizontalBlock(ladder, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(ladder), "block/ladder")).texture("particle", this.blockTexture(ladder))).texture("texture", this.blockTexture(ladder)));
        this.generatedItem((ItemLike)ladder, "block");
    }

    public void boardsBlock(Block boards) {
        ModelBuilder boardsModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(boards))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/template_boards")))).texture("all", this.blockTexture(boards));
        ModelBuilder boardsHorizontalModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(boards) + "_horizontal")).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/template_boards_horizontal")))).texture("all", this.blockTexture(boards));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(boards).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)boardsModel).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)boardsHorizontalModel).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)boardsHorizontalModel).rotationY(270).addModel();
        this.blockItem(boards);
    }

    public void verticalPlanksBlock(Block planks, Block verticalPlanks) {
        this.simpleBlock(verticalPlanks, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(verticalPlanks))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/vertical_planks")))).texture("all", this.blockTexture(planks)));
        this.blockItem(verticalPlanks);
    }

    public void beehiveBlock(Block block) {
        ModelBuilder beehive = ((BlockModelBuilder)this.models().orientableWithBottom(this.name(block), this.suffix(this.blockTexture(block), "_side"), this.suffix(this.blockTexture(block), "_front"), this.suffix(this.blockTexture(block), "_end"), this.suffix(this.blockTexture(block), "_end"))).texture("particle", this.suffix(this.blockTexture(block), "_side"));
        ModelBuilder beehiveHoney = ((BlockModelBuilder)this.models().orientableWithBottom(this.name(block) + "_honey", this.suffix(this.blockTexture(block), "_side"), this.suffix(this.blockTexture(block), "_front_honey"), this.suffix(this.blockTexture(block), "_end"), this.suffix(this.blockTexture(block), "_end"))).texture("particle", this.suffix(this.blockTexture(block), "_side"));
        this.horizontalBlock(block, arg_0 -> AtmosphericBlockStateProvider.lambda$beehiveBlock$2((ModelFile)beehiveHoney, (ModelFile)beehive, arg_0));
        this.blockItem(block);
    }

    public void buttonBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).uvLock(state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.WALL).rotationX(state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.WALL ? 90 : (state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.CEILING ? 180 : 0)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + (state.m_61143_((Property)BlockStateProperties.f_61376_) != AttachFace.CEILING ? 180 : 0)) % 360).build());
    }

    public void orange(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            boolean horizontal = Direction.Plane.HORIZONTAL.test((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
            String addition = ((Integer)state.m_61143_((Property)OrangeBlock.ORANGES) == 2 ? "_double" : "") + (horizontal ? "_wall" : (state.m_61143_((Property)OrangeBlock.f_52588_) == Direction.DOWN ? "_ceiling" : ""));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block) + addition)).parent((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location("block/template_orange" + addition)))).texture("orange", this.blockTexture(block))).rotationY(horizontal ? (int)((((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122435_() + 180.0f) % 360.0f) : 0).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    public void dragonRoots(Block block) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        DragonRootsBlock.FACING.m_6908_().forEach(dir -> {
            int yRot = ((int)dir.m_122435_() + 180) % 360;
            for (DragonRootsStage stage : DragonRootsStage.values()) {
                if (stage == DragonRootsStage.NONE) continue;
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location("block/dragon_roots_top"))).rotationY(yRot).addModel()).condition(DragonRootsBlock.TOP_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location("block/dragon_roots_bottom"))).rotationY(yRot).addModel()).condition(DragonRootsBlock.BOTTOM_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
                if (stage == DragonRootsStage.ROOTS) continue;
                boolean flowering = stage == DragonRootsStage.FLOWERING || stage == DragonRootsStage.FLOWERING_ENDER;
                boolean ender = stage == DragonRootsStage.ENDER || stage == DragonRootsStage.FLOWERING_ENDER;
                String name = (flowering ? "flowering_" : "") + (ender ? "ender_" : "") + "dragon_fruit";
                String texture = Atmospheric.location("block/" + name).toString();
                String parent = "block/template_" + (flowering ? "flowering_" : "") + "dragon_fruit";
                ModelBuilder top = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(Atmospheric.location(name) + "_top")).parent((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location(parent + "_top")))).texture("fruit", texture);
                ModelBuilder bottom = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(Atmospheric.location(name) + "_bottom")).parent((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location(parent + "_bottom")))).texture("fruit", texture);
                if (flowering) {
                    ResourceLocation emissiveTexture = Atmospheric.location("block/flowering_dragon_fruit_emissive");
                    top = top.texture("overlay", emissiveTexture).renderType("translucent");
                    bottom = bottom.texture("overlay", emissiveTexture).renderType("translucent");
                }
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)top).rotationY(yRot).addModel()).condition(DragonRootsBlock.TOP_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)bottom).rotationY(yRot).addModel()).condition(DragonRootsBlock.BOTTOM_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
            }
        });
    }

    public void pressurePlateBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).build());
    }

    public void planksCompat(Block planks, Block boards, Block ladder, Block bookshelf, Block beehive, Pair<RegistryObject<BlueprintChestBlock>, RegistryObject<BlueprintTrappedChestBlock>> chests, Block verticalPlanks) {
        this.boardsBlock(boards);
        this.ladderBlock(ladder);
        this.bookshelfBlock(planks, bookshelf);
        this.beehiveBlock(beehive);
        this.chestBlocks(planks, chests);
        this.verticalPlanksBlock(planks, verticalPlanks);
    }

    public void logCompat(Block log, Block strippedLog, Block post, Block strippedPost) {
        this.postBlock(log, post);
        this.postBlock(strippedLog, strippedPost);
    }

    public void leavesCompat(Block leaves, Block log, Block leafPile, Block hedge, Block leafCarpet) {
        this.leafPileBlock(leaves, leafPile);
        this.leafCarpetBlock(leaves, leafCarpet);
        this.hedgeBlock(leaves, log, hedge);
    }

    public void leavesBlock(Block leaves) {
        this.simpleBlock(leaves, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(leaves))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("block/leaves")))).texture("all", this.blockTexture(leaves)));
        this.blockItem(leaves);
    }

    public void leafPileBlock(Block leaves, Block leafPile) {
        this.leafPileBlock(leaves, leafPile, true);
    }

    public void leafPileBlock(Block leaves, Block leafPile, boolean tint) {
        ModelBuilder leafPileModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(leafPile))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/" + (tint ? "tinted_" : "") + "leaf_pile")))).texture("all", this.blockTexture(leaves));
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(leafPile);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        this.generatedItem((ItemLike)leafPile, (ItemLike)leaves, "block");
    }

    public void leafCarpetBlock(Block leaves, Block leafCarpet) {
        this.simpleBlock(leafCarpet, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(leafCarpet))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/leaf_carpet")))).texture("all", this.blockTexture(leaves)));
        this.blockItem(leafCarpet);
    }

    public void hedgeBlock(Block leaves, Block log, Block hedge) {
        ModelFile hedgePost = this.hedgePost(this.name(hedge) + "_post", this.blockTexture(log), this.blockTexture(leaves));
        ModelFile hedgeSide = this.hedgeSide(this.name(hedge) + "_side", this.blockTexture(leaves));
        ModelFile hedgeExtend = this.hedgeExtend(this.name(hedge) + "_extend", this.blockTexture(leaves));
        this.hedgeBlock(hedge, hedgePost, hedgeSide, hedgeExtend);
        ((ItemModelBuilder)this.itemModels().getBuilder(this.name(hedge))).parent(hedgePost);
    }

    public void postBlock(Block log, Block post) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(post))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/post")))).texture("texture", this.blockTexture(log));
        ModelFile.UncheckedModelFile chainSmall = new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/chain_small"));
        ModelFile.UncheckedModelFile chainSmallTop = new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/chain_small_top"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(post).part().modelFile((ModelFile)model).addModel()).condition((Property)RotatedPillarBlock.f_55923_, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile((ModelFile)model).rotationX(90).addModel()).condition((Property)RotatedPillarBlock.f_55923_, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel()).condition((Property)RotatedPillarBlock.f_55923_, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)chainSmall).addModel()).condition((Property)CHAINED[0], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmallTop).addModel()).condition((Property)CHAINED[1], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmallTop).rotationX(90).addModel()).condition((Property)CHAINED[2], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmall).rotationX(90).addModel()).condition((Property)CHAINED[3], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmall).rotationX(90).rotationY(90).addModel()).condition((Property)CHAINED[4], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmallTop).rotationX(90).rotationY(90).addModel()).condition((Property)CHAINED[5], (Comparable[])new Boolean[]{true}).end();
        this.blockItem(post);
    }

    public void hedgeBlock(Block block, ModelFile post, ModelFile side, ModelFile extend) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).addModel()).condition((Property)BooleanProperty.m_61465_((String)"extend"), (Comparable[])new Boolean[]{false}).end().part().modelFile(extend).addModel()).condition((Property)BooleanProperty.m_61465_((String)"extend"), (Comparable[])new Boolean[]{true});
        PipeBlock.f_55154_.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.m_122434_().m_122479_()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
            }
        });
    }

    public ModelFile hedgePost(String name, ResourceLocation log, ResourceLocation leaf) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/hedge_post")))).texture("log", log)).texture("leaf", leaf);
    }

    public ModelFile hedgeSide(String name, ResourceLocation leaf) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/hedge_side")))).texture("leaf", leaf);
    }

    public ModelFile hedgeExtend(String name, ResourceLocation leaf) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/hedge_extend")))).texture("leaf", leaf);
    }

    public void signBlocks(Block planks, Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> pair) {
        this.simpleBlock((Block)((RegistryObject)pair.getFirst()).get(), this.particle((Block)((RegistryObject)pair.getFirst()).get(), this.blockTexture(planks)));
        this.simpleBlock((Block)((RegistryObject)pair.getSecond()).get(), this.particle((Block)((RegistryObject)pair.getFirst()).get(), this.blockTexture(planks)));
        this.generatedItem((ItemLike)((RegistryObject)pair.getFirst()).get(), "item");
    }

    public void chestBlocks(Block planks, Pair<RegistryObject<BlueprintChestBlock>, RegistryObject<BlueprintTrappedChestBlock>> chests) {
        this.simpleBlock((Block)((RegistryObject)chests.getFirst()).get(), this.particle((Block)((RegistryObject)chests.getFirst()).get(), this.blockTexture(planks)));
        this.simpleBlock((Block)((RegistryObject)chests.getSecond()).get(), this.particle((Block)((RegistryObject)chests.getFirst()).get(), this.blockTexture(planks)));
        this.simpleBlockItem((Block)((RegistryObject)chests.getFirst()).get(), (ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "item/template_chest")));
        this.simpleBlockItem((Block)((RegistryObject)chests.getSecond()).get(), (ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "item/template_chest")));
    }

    public ModelFile particle(Block block, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", texture);
    }

    public void logBlocks(Block log, Block wood) {
        this.logBlock(log);
        this.axisBlock((RotatedPillarBlock)wood, this.blockTexture(log), this.blockTexture(log));
        this.blockItem(wood);
    }

    public void logBlock(Block block) {
        this.axisBlock((RotatedPillarBlock)block, this.blockTexture(block), this.suffix(this.remove(this.blockTexture(block), "watchful_"), "_top"));
        this.blockItem(block);
    }

    public ModelFile verticalSlab(String name, ResourceLocation texture) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/vertical_slab")))).texture("side", texture)).texture("bottom", texture)).texture("top", texture);
    }

    public void verticalSlabBlock(Block planks, VerticalSlabBlock slab) {
        ModelFile verticalSlab = this.verticalSlab(this.name((Block)slab), this.blockTexture(planks));
        this.getVariantBuilder((Block)slab).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.NORTH).addModels(new ConfiguredModel[]{new ConfiguredModel(verticalSlab, 0, 0, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.SOUTH).addModels(new ConfiguredModel[]{new ConfiguredModel(verticalSlab, 0, 180, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.EAST).addModels(new ConfiguredModel[]{new ConfiguredModel(verticalSlab, 0, 90, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.WEST).addModels(new ConfiguredModel[]{new ConfiguredModel(verticalSlab, 0, 270, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cubeAll(this.name(planks), this.blockTexture(planks)))});
    }

    private String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    private ResourceLocation prefix(String prefix, ResourceLocation rl) {
        return new ResourceLocation(rl.m_135827_(), prefix + rl.m_135815_());
    }

    private ResourceLocation suffix(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    private ResourceLocation remove(ResourceLocation rl, String remove) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_().replace(remove, ""));
    }

    private static /* synthetic */ ModelFile lambda$beehiveBlock$2(ModelFile beehiveHoney, ModelFile beehive, BlockState state) {
        return (Integer)state.m_61143_((Property)BlockStateProperties.f_61421_) == 5 ? beehiveHoney : beehive;
    }

    private static /* synthetic */ ModelFile lambda$blockFamily$1(ModelFile pressurePlateDownModel, ModelFile pressurePlateModel, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? pressurePlateDownModel : pressurePlateModel;
    }

    private static /* synthetic */ ModelFile lambda$blockFamily$0(ModelFile buttonPressedModel, ModelFile buttonModel, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? buttonPressedModel : buttonModel;
    }
}

