/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server;

import com.google.common.collect.Maps;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.AtmosphericConfig;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.world.modification.structure.SimpleStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterProvider;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.EventPriority;

public final class AtmosphericStructureRepaletterProvider
extends StructureRepaletterProvider {
    public AtmosphericStructureRepaletterProvider(DataGenerator dataGenerator) {
        super(dataGenerator, "atmospheric");
    }

    protected void registerRepaletters() {
        this.simpleRepaletter("yucca_buttons_in_desert_villages", AtmosphericStructureRepaletterProvider.desertVillageSelector(), Blocks.f_50254_, (Block)AtmosphericBlocks.YUCCA_BUTTON.get());
        this.simpleRepaletter("yucca_doors_in_desert_villages", AtmosphericStructureRepaletterProvider.desertVillageSelector(), Blocks.f_50486_, (Block)AtmosphericBlocks.YUCCA_DOOR.get());
        this.simpleRepaletter("yucca_fences_in_desert_villages", AtmosphericStructureRepaletterProvider.desertVillageSelector(), Blocks.f_50481_, (Block)AtmosphericBlocks.YUCCA_FENCE.get());
        this.simpleRepaletter("yucca_fence_gates_in_desert_villages", AtmosphericStructureRepaletterProvider.desertVillageSelector(), Blocks.f_50476_, (Block)AtmosphericBlocks.YUCCA_FENCE_GATE.get());
        this.simpleRepaletter("yucca_trapdoors_in_desert_villages", AtmosphericStructureRepaletterProvider.desertVillageSelector(), Blocks.f_50219_, (Block)AtmosphericBlocks.YUCCA_TRAPDOOR.get());
        this.simpleRepaletter("grimwood_logs_in_ancient_cities", AtmosphericStructureRepaletterProvider.ancientCitySelector(), Blocks.f_50004_, (Block)AtmosphericBlocks.GRIMWOOD_LOG.get());
        this.simpleRepaletter("grimwood_fences_in_ancient_cities", AtmosphericStructureRepaletterProvider.ancientCitySelector(), Blocks.f_50483_, (Block)AtmosphericBlocks.GRIMWOOD_FENCE.get());
        this.simpleRepaletter("grimwood_planks_in_ancient_cities", AtmosphericStructureRepaletterProvider.ancientCitySelector(), Blocks.f_50745_, (Block)AtmosphericBlocks.GRIMWOOD_PLANKS.get());
    }

    public void simpleRepaletter(String name, ConditionedResourceSelector selector, Block toReplace, Block replacesWith) {
        this.registerRepaletter(name, selector, EventPriority.HIGH, (StructureRepaletter)new SimpleStructureRepaletter(toReplace, replacesWith));
    }

    private static ConditionedResourceSelector desertVillageSelector() {
        return AtmosphericStructureRepaletterProvider.selector(AtmosphericConfig.COMMON.yuccaDesertVillages, "yucca_desert_villages", BuiltinStructures.f_209865_.m_135782_());
    }

    private static ConditionedResourceSelector ancientCitySelector() {
        return AtmosphericStructureRepaletterProvider.selector(AtmosphericConfig.COMMON.grimwoodAncientCities, "grimwood_ancient_cities", BuiltinStructures.f_226492_.m_135782_());
    }

    private static ConditionedResourceSelector selector(ForgeConfigSpec.ConfigValue<?> value, String key, ResourceLocation ... structures) {
        return new ConditionedResourceSelector((ResourceSelector)new NamesResourceSelector(structures), new ICondition[]{new ConfigValueCondition(Atmospheric.location("config"), value, key, (Map)Maps.newHashMap(), false)});
    }
}

