/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericGeneration;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.blueprint.core.util.registry.BiomeSubRegistryHelper;
import javax.annotation.Nullable;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericBiomes {
    public static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)Atmospheric.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome RAINFOREST = HELPER.createBiome("rainforest", () -> AtmosphericBiomes.rainforest(false, false));
    public static final BiomeSubRegistryHelper.KeyedBiome SPARSE_RAINFOREST = HELPER.createBiome("sparse_rainforest", () -> AtmosphericBiomes.rainforest(false, true));
    public static final BiomeSubRegistryHelper.KeyedBiome RAINFOREST_BASIN = HELPER.createBiome("rainforest_basin", () -> AtmosphericBiomes.rainforest(true, false));
    public static final BiomeSubRegistryHelper.KeyedBiome SPARSE_RAINFOREST_BASIN = HELPER.createBiome("sparse_rainforest_basin", () -> AtmosphericBiomes.rainforest(true, true));
    public static final BiomeSubRegistryHelper.KeyedBiome DUNES = HELPER.createBiome("dunes", () -> AtmosphericBiomes.dunes(false, false));
    public static final BiomeSubRegistryHelper.KeyedBiome FLOURISHING_DUNES = HELPER.createBiome("flourishing_dunes", () -> AtmosphericBiomes.dunes(false, true));
    public static final BiomeSubRegistryHelper.KeyedBiome ROCKY_DUNES = HELPER.createBiome("rocky_dunes", () -> AtmosphericBiomes.dunes(true, false));
    public static final BiomeSubRegistryHelper.KeyedBiome PETRIFIED_DUNES = HELPER.createBiome("petrified_dunes", () -> AtmosphericBiomes.dunes(true, true));
    public static final BiomeSubRegistryHelper.KeyedBiome SPINY_THICKET = HELPER.createBiome("spiny_thicket", AtmosphericBiomes::spinyThicket);
    public static final BiomeSubRegistryHelper.KeyedBiome SCRUBLAND = HELPER.createBiome("scrubland", () -> AtmosphericBiomes.scrubland(false));
    public static final BiomeSubRegistryHelper.KeyedBiome SNOWY_SCRUBLAND = HELPER.createBiome("snowy_scrubland", () -> AtmosphericBiomes.scrubland(true));
    public static final BiomeSubRegistryHelper.KeyedBiome ASPEN_PARKLAND = HELPER.createBiome("aspen_parkland", AtmosphericBiomes::aspenParkland);
    public static final BiomeSubRegistryHelper.KeyedBiome KOUSA_JUNGLE = HELPER.createBiome("kousa_jungle", AtmosphericBiomes::kousaJungle);
    public static final BiomeSubRegistryHelper.KeyedBiome GRIMWOODS = HELPER.createBiome("grimwoods", AtmosphericBiomes::grimwoods);
    public static final BiomeSubRegistryHelper.KeyedBiome LAUREL_FOREST = HELPER.createBiome("laurel_forest", AtmosphericBiomes::laurelForest);
    public static final BiomeSubRegistryHelper.KeyedBiome HOT_SPRINGS = HELPER.createBiome("hot_springs", AtmosphericBiomes::hotSprings);

    private static Biome rainforest(boolean basin, boolean sparse) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.rainforest(generation, basin, sparse);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        return AtmosphericBiomes.biome(Biome.Precipitation.RAIN, 0.9f, 0.95f, 6675400, 408635, spawns, generation, null);
    }

    private static Biome dunes(boolean rocky, boolean variant) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.dunes(generation, rocky, variant);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawns, (int)19, (int)1, (int)100, (boolean)false);
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 80, 4, 4));
        return AtmosphericBiomes.biome(Biome.Precipitation.NONE, 2.0f, 0.0f, 14988944, spawns, generation, null);
    }

    private static Biome spinyThicket() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.spinyThicket(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawns, (int)19, (int)1, (int)100, (boolean)false);
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 80, 4, 4));
        return AtmosphericBiomes.biome(Biome.Precipitation.NONE, 2.0f, 0.85f, 14988944, spawns, generation, null);
    }

    private static Biome scrubland(boolean snowy) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.scrubland(generation, snowy);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20457_, 2, 1, 1));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 1, 1, 1));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 2, 2, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtmosphericEntityTypes.COCHINEAL.get(), 4, 1, 4));
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawns, (int)19, (int)1, (int)(!snowy ? 100 : 20), (boolean)false);
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 80, 4, 4));
        if (snowy) {
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20481_, 80, 4, 4));
        }
        return AtmosphericBiomes.biome(!snowy ? Biome.Precipitation.NONE : Biome.Precipitation.SNOW, !snowy ? 2.0f : 0.0f, 0.0f, 13021599, spawns, generation, null);
    }

    private static Biome aspenParkland() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.aspenParkland(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 10, 1, 1));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 15, 1, 1));
        return AtmosphericBiomes.biome(Biome.Precipitation.RAIN, 2.0f, 0.0f, spawns, generation, Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
    }

    private static Biome kousaJungle() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.kousaJungle(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 3));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        return AtmosphericBiomes.biome(Biome.Precipitation.SNOW, -0.5f, 0.5f, spawns, generation, null);
    }

    private static Biome grimwoods() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.grimwoods(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        return AtmosphericBiomes.biome(Biome.Precipitation.RAIN, 0.25f, 0.0f, 9539946, 8882547, 5403055, 0x131333, 9866116, spawns, generation, null);
    }

    private static Biome laurelForest() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.laurelForest(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        return AtmosphericBiomes.biomeWithGrass(Biome.Precipitation.RAIN, 0.85f, 0.5f, 12249691, 11392595, spawns, generation, Musics.m_11653_((SoundEvent)SoundEvents.f_215731_));
    }

    private static Biome hotSprings() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.hotSprings(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        return AtmosphericBiomes.biome(Biome.Precipitation.NONE, 0.25f, 0.4f, 4445678, 270131, spawns, generation, null);
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return AtmosphericBiomes.biome(precipitation, temperature, downfall, 12638463, spawns, generation, music);
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return AtmosphericBiomes.biome(precipitation, temperature, downfall, waterColor, waterFogColor, 12638463, spawns, generation, music);
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return AtmosphericBiomes.biome(precipitation, temperature, downfall, 4159204, 329011, fogColor, spawns, generation, music);
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(AtmosphericBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static Biome biomeWithGrass(Biome.Precipitation precipitation, float temperature, float downfall, int grassColor, int foliageColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48045_(grassColor).m_48043_(foliageColor).m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(AtmosphericBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int grassColor, int foliageColor, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48045_(grassColor).m_48043_(foliageColor).m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(AtmosphericBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

