/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats;

import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.server.BetterStatsServer;
import io.github.thecsdev.tcdcommons.TCDCommons;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="betterstats")
public class BetterStats {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)BetterStats.getModID());
    public static final String ModID = "betterstats";
    private static BetterStats Instance;
    public final ModContainer ModInfo = (ModContainer)ModList.get().getModContainerById("betterstats").get();

    public BetterStats() {
        if (BetterStats.isModInitialized()) {
            throw new IllegalStateException(BetterStats.getModID() + " has already been initialized.");
        }
        if (this.getClass().equals(BetterStats.class)) {
            if (FMLEnvironment.dist.isClient()) {
                new BetterStatsClient();
            } else if (FMLEnvironment.dist.isDedicatedServer()) {
                new BetterStatsServer();
            } else {
                TCDCommons.crash((String)"Attempting to initialize betterstats", (Throwable)new RuntimeException("Invalid FMLEnvironment.dist()"));
            }
            return;
        }
        Instance = this;
        LOGGER.info("Initializing '" + BetterStats.getModName() + "' as '" + this.getClass().getSimpleName() + "'.");
    }

    public ModContainer getModInfo() {
        return this.ModInfo;
    }

    public static BetterStats getInstance() {
        return Instance;
    }

    public static String getModName() {
        return BetterStats.getInstance().getModInfo().getModInfo().getDisplayName();
    }

    public static String getModID() {
        return ModID;
    }

    public static boolean isModInitialized() {
        return BetterStats.isInstanceValid(Instance);
    }

    private static boolean isInstanceValid(BetterStats instance) {
        return BetterStats.isServer(instance) || BetterStats.isClient(instance);
    }

    public static boolean isServer() {
        return BetterStats.isServer(Instance);
    }

    public static boolean isClient() {
        return BetterStats.isClient(Instance);
    }

    private static boolean isServer(BetterStats arg0) {
        return arg0 instanceof BetterStatsServer;
    }

    private static boolean isClient(BetterStats arg0) {
        return arg0 instanceof BetterStatsClient;
    }
}

