/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.energy;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.EnergyItem;
import earth.terrarium.botarium.api.energy.PlatformEnergyManager;
import earth.terrarium.botarium.api.energy.PlatformItemEnergyManager;
import earth.terrarium.botarium.api.energy.StatefulEnergyContainer;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import earth.terrarium.botarium.forge.energy.ForgeEnergyManager;
import earth.terrarium.botarium.forge.energy.ForgeItemEnergyManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class EnergyHooks {
    public static PlatformItemEnergyManager getItemEnergyManager(ItemStack stack) {
        return new ForgeItemEnergyManager((CapabilityProvider<?>)stack);
    }

    public static PlatformEnergyManager getBlockEnergyManager(BlockEntity entity, Direction direction) {
        return new ForgeEnergyManager((CapabilityProvider<?>)entity, direction);
    }

    public static boolean isEnergyItem(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public static boolean isEnergyContainer(BlockEntity block, Direction direction) {
        return block.getCapability(ForgeCapabilities.ENERGY, direction).isPresent();
    }

    public static long moveEnergy(PlatformEnergyManager from, PlatformEnergyManager to, long amount) {
        long extracted = from.extract(amount, true);
        long inserted = to.insert(extracted, true);
        from.extract(inserted, false);
        return to.insert(inserted, false);
    }

    public static long safeMoveEnergy(Optional<PlatformEnergyManager> from, Optional<PlatformEnergyManager> to, long amount) {
        return from.map(f -> to.map(t -> EnergyHooks.moveEnergy(f, t, amount)).orElse(0L)).orElse(0L);
    }

    public static Optional<PlatformEnergyManager> safeGetBlockEnergyManager(BlockEntity entity, @Nullable Direction direction) {
        return EnergyHooks.isEnergyContainer(entity, direction) ? Optional.of(EnergyHooks.getBlockEnergyManager(entity, direction)) : Optional.empty();
    }

    public static Optional<PlatformItemEnergyManager> safeGetItemEnergyManager(ItemStack stack) {
        return EnergyHooks.isEnergyItem(stack) ? Optional.of(EnergyHooks.getItemEnergyManager(stack)) : Optional.empty();
    }

    public static long moveItemToItemEnergy(PlatformItemEnergyManager from, ItemStackHolder sender, PlatformItemEnergyManager to, ItemStackHolder receiver, long amount) {
        long extracted = from.extract(sender, amount, true);
        long inserted = to.insert(receiver, extracted, true);
        from.extract(sender, inserted, false);
        return to.insert(receiver, inserted, false);
    }

    public static long moveStandardToItemEnergy(PlatformEnergyManager from, PlatformItemEnergyManager to, ItemStackHolder receiver, long amount) {
        long extracted = from.extract(amount, true);
        long inserted = to.insert(receiver, extracted, true);
        from.extract(inserted, false);
        return to.insert(receiver, inserted, false);
    }

    public static long moveItemToStandardEnergy(PlatformItemEnergyManager from, ItemStackHolder sender, PlatformEnergyManager to, long amount) {
        long extracted = from.extract(sender, amount, true);
        long inserted = to.insert(extracted, true);
        from.extract(sender, inserted, false);
        return to.insert(inserted, false);
    }

    public static long safeMoveItemToItemEnergy(ItemStackHolder from, ItemStackHolder to, long amount) {
        return EnergyHooks.safeGetItemEnergyManager(from.getStack()).map(f -> EnergyHooks.safeGetItemEnergyManager(to.getStack()).map(t -> EnergyHooks.moveItemToItemEnergy(f, from, t, to, amount)).orElse(0L)).orElse(0L);
    }

    public static long safeMoveItemToBlockEnergy(ItemStackHolder from, BlockEntity to, @Nullable Direction direction, long amount) {
        return EnergyHooks.safeGetItemEnergyManager(from.getStack()).map(f -> EnergyHooks.safeGetBlockEnergyManager(to, direction).map(t -> EnergyHooks.moveItemToStandardEnergy(f, from, t, amount)).orElse(0L)).orElse(0L);
    }

    public static long safeMoveBlockToItemEnergy(BlockEntity from, @Nullable Direction direction, ItemStackHolder to, long amount) {
        return EnergyHooks.safeGetBlockEnergyManager(from, direction).map(f -> EnergyHooks.safeGetItemEnergyManager(to.getStack()).map(t -> EnergyHooks.moveStandardToItemEnergy(f, t, to, amount)).orElse(0L)).orElse(0L);
    }

    public static long moveBlockToBlockEnergy(BlockEntity from, @Nullable Direction fromDirection, BlockEntity to, @Nullable Direction toDirection, long amount) {
        return EnergyHooks.safeMoveEnergy(EnergyHooks.safeGetBlockEnergyManager(from, fromDirection), EnergyHooks.safeGetBlockEnergyManager(to, toDirection), amount);
    }

    public static long moveBlockToBlockEnergy(BlockEntity from, BlockEntity to, long amount) {
        return EnergyHooks.safeMoveEnergy(EnergyHooks.safeGetBlockEnergyManager(from, null), EnergyHooks.safeGetBlockEnergyManager(to, null), amount);
    }

    public static <T extends BlockEntity> void distributeEnergyNearby(T energyBlock, long amount) {
        BlockPos blockPos = energyBlock.m_58899_();
        Level level = energyBlock.m_58904_();
        if (level == null) {
            return;
        }
        Direction.m_235666_().map(direction -> Pair.of((Object)direction, (Object)level.m_7702_(blockPos.m_121945_(direction)))).filter(pair -> pair.getSecond() != null).map(pair -> Pair.of(EnergyHooks.safeGetBlockEnergyManager((BlockEntity)pair.getSecond(), (Direction)pair.getFirst()), (Object)((Direction)pair.getFirst()))).filter(pair -> ((Optional)pair.getFirst()).isPresent()).forEach(pair -> {
            PlatformEnergyManager externalEnergy = (PlatformEnergyManager)((Optional)pair.getFirst()).get();
            EnergyHooks.safeGetBlockEnergyManager(energyBlock, ((Direction)pair.getSecond()).m_122424_()).ifPresent(platformEnergyManager -> EnergyHooks.moveEnergy(platformEnergyManager, externalEnergy, amount == -1L ? ((EnergyBlock)energyBlock).getEnergyStorage().getStoredEnergy() : amount));
        });
    }

    public static <T extends BlockEntity> void distributeEnergyNearby(T energyBlock) {
        EnergyHooks.distributeEnergyNearby(energyBlock, -1L);
    }

    public static int toDurabilityBar(EnergyItem energyItem, ItemStack stack) {
        StatefulEnergyContainer<ItemStack> energyStorage = energyItem.getEnergyStorage(stack);
        return (int)((double)energyStorage.getStoredEnergy() / (double)energyStorage.getMaxCapacity() * 13.0);
    }
}

