/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.energy;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergySnapshot;
import earth.terrarium.botarium.api.energy.SimpleEnergySnapshot;
import earth.terrarium.botarium.api.energy.StatefulEnergyContainer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SimpleUpdatingEnergyContainer
implements StatefulEnergyContainer<BlockEntity> {
    protected final long energyCapacity;
    protected final Updatable updatable;
    protected long energy;

    public SimpleUpdatingEnergyContainer(Updatable entity, long energyCapacity) {
        this.updatable = entity;
        this.energyCapacity = energyCapacity;
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        long inserted = Mth.m_14053_((long)maxAmount, (long)0L, (long)(this.getMaxCapacity() - this.getStoredEnergy()));
        if (simulate) {
            return inserted;
        }
        this.energy += inserted;
        return inserted;
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        long extracted = Mth.m_14053_((long)maxAmount, (long)0L, (long)this.getStoredEnergy());
        if (simulate) {
            return extracted;
        }
        this.energy -= extracted;
        return extracted;
    }

    public long internalInsert(long maxAmount, boolean simulate) {
        return this.insertEnergy(maxAmount, simulate);
    }

    public long internalExtract(long maxAmount, boolean simulate) {
        return this.extractEnergy(maxAmount, simulate);
    }

    @Override
    public void setEnergy(long energy) {
        this.energy = energy;
    }

    @Override
    public long getStoredEnergy() {
        return this.energy;
    }

    @Override
    public long getMaxCapacity() {
        return this.energyCapacity;
    }

    @Override
    public long maxInsert() {
        return 1024L;
    }

    @Override
    public long maxExtract() {
        return 1024L;
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128356_("Energy", this.getStoredEnergy());
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.setEnergy(tag.m_128454_("Energy"));
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot(this);
    }

    @Override
    public void update(BlockEntity block) {
        this.updatable.update();
    }
}

