/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.fluid;

import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.FluidSnapshot;
import earth.terrarium.botarium.api.fluid.ItemFluidContainer;
import earth.terrarium.botarium.api.fluid.SimpleFluidSnapshot;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;

public class ItemFilteredFluidContainer
implements ItemFluidContainer {
    public final NonNullList<FluidHolder> storedFluid;
    public final BiPredicate<Integer, FluidHolder> fluidFilter;
    public final long maxAmount;
    public final ItemStack containerItem;
    public static final String FLUID_KEY = "StoredFluids";

    public ItemFilteredFluidContainer(long maxAmount, int size, ItemStack itemStack, BiPredicate<Integer, FluidHolder> fluidFilter) {
        this.maxAmount = maxAmount;
        this.fluidFilter = fluidFilter;
        this.storedFluid = NonNullList.m_122780_((int)size, (Object)FluidHooks.emptyFluid());
        this.containerItem = itemStack;
        this.deserialize(itemStack.m_41698_("BotariumData"));
    }

    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            if (((FluidHolder)this.storedFluid.get(i)).isEmpty()) {
                FluidHolder insertedFluid = fluid.copyHolder();
                insertedFluid.setAmount(Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)this.maxAmount));
                if (simulate) {
                    return insertedFluid.getFluidAmount();
                }
                this.storedFluid.set(i, (Object)insertedFluid);
                return ((FluidHolder)this.storedFluid.get(i)).getFluidAmount();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long insertedAmount = Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)(this.maxAmount - ((FluidHolder)this.storedFluid.get(i)).getFluidAmount()));
            if (simulate) {
                return insertedAmount;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() + insertedAmount);
            return insertedAmount;
        }
        return 0L;
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            FluidHolder toExtract = fluid.copyHolder();
            if (this.storedFluid.isEmpty()) {
                return FluidHooks.emptyFluid();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long extractedAmount = Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)((FluidHolder)this.storedFluid.get(i)).getFluidAmount());
            toExtract.setAmount(extractedAmount);
            if (simulate) {
                return toExtract;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() - extractedAmount);
            if (((FluidHolder)this.storedFluid.get(i)).getFluidAmount() == 0L) {
                this.storedFluid.set(i, (Object)FluidHooks.emptyFluid());
            }
            return toExtract;
        }
        return FluidHooks.emptyFluid();
    }

    @Override
    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        if (Objects.equals(fluidHolder.getCompound(), toInsert.getCompound()) && fluidHolder.getFluid().m_6212_(toInsert.getFluid())) {
            long extracted = Mth.m_14053_((long)toInsert.getFluidAmount(), (long)0L, (long)fluidHolder.getFluidAmount());
            snapshot.run();
            fluidHolder.setAmount(fluidHolder.getFluidAmount() - extracted);
            if (fluidHolder.getFluidAmount() == 0L) {
                fluidHolder.setFluid(Fluids.f_76191_);
            }
            return extracted;
        }
        return 0L;
    }

    @Override
    public void setFluid(int slot, FluidHolder fluid) {
        this.storedFluid.set(slot, (Object)fluid);
    }

    @Override
    public List<FluidHolder> getFluids() {
        return this.storedFluid;
    }

    @Override
    public int getSize() {
        return this.getFluids().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getFluids().isEmpty() || this.getFluids().get(0) == null || this.getFluids().get(0).isEmpty();
    }

    @Override
    public ItemFilteredFluidContainer copy() {
        return new ItemFilteredFluidContainer(this.maxAmount, this.getSize(), this.containerItem.m_41777_(), this.fluidFilter);
    }

    @Override
    public long getTankCapacity(int slot) {
        return this.maxAmount;
    }

    @Override
    public void fromContainer(FluidContainer container) {
        for (int i = 0; i < container.getSize(); ++i) {
            this.storedFluid.set(i, (Object)container.getFluids().get(i).copyHolder());
        }
    }

    @Override
    public void deserialize(CompoundTag tag) {
        ListTag fluids = tag.m_128437_(FLUID_KEY, 10);
        for (int i = 0; i < fluids.size(); ++i) {
            CompoundTag fluid = fluids.m_128728_(i);
            this.storedFluid.set(i, (Object)FluidHooks.fluidFromCompound(fluid));
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        if (!this.storedFluid.isEmpty()) {
            ListTag tags = new ListTag();
            for (FluidHolder fluidHolder : this.storedFluid) {
                tags.add((Object)fluidHolder.serialize());
            }
            tag.m_128365_(FLUID_KEY, (Tag)tags);
        }
        return tag;
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return new SimpleFluidSnapshot(this);
    }

    @Override
    public ItemStack getContainerItem() {
        return this.containerItem;
    }

    @Override
    public void update(ItemStack itemStack) {
        this.serialize(itemStack.m_41698_("BotariumData"));
    }
}

