/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.energy;

import earth.terrarium.botarium.Botarium;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyItem;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.util.Updatable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EnergyApi {
    private static final Map<Supplier<BlockEntityType<?>>, BotariumEnergyBlock<?>> BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Block>, BotariumEnergyBlock<?>> BLOCK_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Item>, BotariumEnergyItem<?>> ITEM_LOOKUP_MAP = new HashMap();
    private static Map<BlockEntityType<?>, BotariumEnergyBlock<?>> FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = null;
    private static Map<Block, BotariumEnergyBlock<?>> FINALIZED_BLOCK_LOOKUP_MAP = null;
    private static Map<Item, BotariumEnergyItem<?>> FINALIZED_ITEM_LOOKUP_MAP = null;

    public static Map<BlockEntityType<?>, BotariumEnergyBlock<?>> getBlockEntityRegistry() {
        FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = Botarium.finalizeRegistration(BLOCK_ENTITY_LOOKUP_MAP, FINALIZED_BLOCK_ENTITY_LOOKUP_MAP, "energy block entity");
        return FINALIZED_BLOCK_ENTITY_LOOKUP_MAP;
    }

    public static Map<Block, BotariumEnergyBlock<?>> getBlockRegistry() {
        FINALIZED_BLOCK_LOOKUP_MAP = Botarium.finalizeRegistration(BLOCK_LOOKUP_MAP, FINALIZED_BLOCK_LOOKUP_MAP, "energy block");
        return FINALIZED_BLOCK_LOOKUP_MAP;
    }

    public static Map<Item, BotariumEnergyItem<?>> getItemRegistry() {
        FINALIZED_ITEM_LOOKUP_MAP = Botarium.finalizeRegistration(ITEM_LOOKUP_MAP, FINALIZED_ITEM_LOOKUP_MAP, "energy item");
        return FINALIZED_ITEM_LOOKUP_MAP;
    }

    public static BotariumEnergyBlock<?> getEnergyBlock(Block block) {
        return EnergyApi.getBlockRegistry().get(block);
    }

    public static BotariumEnergyBlock<?> getEnergyBlock(BlockEntityType<?> blockEntity) {
        return EnergyApi.getBlockEntityRegistry().get(blockEntity);
    }

    public static BotariumEnergyItem<?> getEnergyItem(Item item) {
        return EnergyApi.getItemRegistry().get(item);
    }

    public static <T extends EnergyContainer & Updatable> T getAPIEnergyContainer(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        BotariumEnergyBlock getter = EnergyApi.getEnergyBlock(state.m_60734_());
        if (getter == null && entity != null && (getter = EnergyApi.getEnergyBlock(entity.m_58903_())) == null && entity instanceof BotariumEnergyBlock) {
            BotariumEnergyBlock energyGetter;
            getter = energyGetter = (BotariumEnergyBlock)entity;
        }
        if (getter == null) {
            return null;
        }
        return (T)getter.getEnergyStorage(level, pos, state, entity, direction);
    }

    public static void registerEnergyBlockEntity(Supplier<BlockEntityType<?>> block, BotariumEnergyBlock<?> getter) {
        BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlockEntity(BotariumEnergyBlock<?> getter, Supplier<BlockEntityType<?>> ... blocks) {
        for (Supplier<BlockEntityType<?>> block : blocks) {
            BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyBlock(Supplier<Block> block, BotariumEnergyBlock<?> getter) {
        BLOCK_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlock(BotariumEnergyBlock<?> getter, Supplier<Block> ... blocks) {
        for (Supplier<Block> block : blocks) {
            BLOCK_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyItem(Supplier<Item> item, BotariumEnergyItem<?> getter) {
        ITEM_LOOKUP_MAP.put(item, getter);
    }

    @SafeVarargs
    public static void registerEnergyItem(BotariumEnergyItem<?> getter, Supplier<Item> ... items) {
        for (Supplier<Item> item : items) {
            ITEM_LOOKUP_MAP.put(item, getter);
        }
    }

    public static long distributeEnergyNearby(BlockEntity energyBlock, @Nullable Direction extractDirection, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.m_58904_(), energyBlock.m_58899_(), extractDirection, amount);
    }

    public static long distributeEnergyNearby(BlockEntity energyBlock, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.m_58904_(), energyBlock.m_58899_(), null, amount);
    }

    public static long distributeEnergyNearby(Level level, BlockPos energyPos, @Nullable Direction extractDirection, long amount) {
        EnergyContainer internalEnergy = EnergyContainer.of(level, energyPos, extractDirection);
        long amountToDistribute = internalEnergy.extractEnergy(amount, true);
        if (amountToDistribute == 0L) {
            return 0L;
        }
        List<EnergyContainer> list = Direction.m_235666_().map(direction -> EnergyContainer.of(level, energyPos.m_121945_(direction), direction.m_122424_())).filter(Objects::nonNull).sorted(Comparator.comparingLong(energy -> energy.insertEnergy(amount, true))).toList();
        int receiverCount = list.size();
        for (EnergyContainer energy2 : list) {
            if (energy2 == null) continue;
            long inserted = EnergyApi.moveEnergy(internalEnergy, energy2, amountToDistribute / (long)receiverCount, false);
            amountToDistribute -= inserted;
            --receiverCount;
        }
        return amount - amountToDistribute;
    }

    public static long moveEnergy(EnergyContainer from, EnergyContainer to, long amount, boolean simulate) {
        long extracted = from.extractEnergy(amount, true);
        long inserted = to.insertEnergy(extracted, true);
        long simulatedExtraction = from.extractEnergy(inserted, true);
        if (!simulate && inserted > 0L && simulatedExtraction == inserted) {
            from.extractEnergy(inserted, false);
            to.insertEnergy(inserted, false);
        }
        return Math.max(0L, inserted);
    }

    public static long moveEnergy(ItemStackHolder from, ItemStackHolder to, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from);
        EnergyContainer toEnergy = EnergyContainer.of(to);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(BlockEntity from, BlockEntity to, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from, null);
        EnergyContainer toEnergy = EnergyContainer.of(to, null);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(Level level, BlockPos fromPos, @Nullable Direction fromDirection, BlockPos toPos, @Nullable Direction toDirection, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(level, fromPos, fromDirection);
        EnergyContainer toEnergy = EnergyContainer.of(level, toPos, toDirection);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(BlockEntity from, Direction direction, ItemStackHolder to, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from, direction);
        EnergyContainer toEnergy = EnergyContainer.of(to);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(ItemStackHolder from, BlockEntity to, Direction direction, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from);
        EnergyContainer toEnergy = EnergyContainer.of(to, direction);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }
}

