/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid;

import earth.terrarium.botarium.Botarium;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.util.Updatable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FluidApi {
    private static final Map<Supplier<BlockEntityType<?>>, BotariumFluidBlock<?>> BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Block>, BotariumFluidBlock<?>> BLOCK_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Item>, BotariumFluidItem<?>> ITEM_LOOKUP_MAP = new HashMap();
    private static Map<BlockEntityType<?>, BotariumFluidBlock<?>> FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = null;
    private static Map<Block, BotariumFluidBlock<?>> FINALIZED_BLOCK_LOOKUP_MAP = null;
    private static Map<Item, BotariumFluidItem<?>> FINALIZED_ITEM_LOOKUP_MAP = null;

    public static Map<BlockEntityType<?>, BotariumFluidBlock<?>> getBlockEntityRegistry() {
        FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = Botarium.finalizeRegistration(BLOCK_ENTITY_LOOKUP_MAP, FINALIZED_BLOCK_ENTITY_LOOKUP_MAP, "fluid containing block entity");
        return FINALIZED_BLOCK_ENTITY_LOOKUP_MAP;
    }

    public static Map<Block, BotariumFluidBlock<?>> getBlockRegistry() {
        FINALIZED_BLOCK_LOOKUP_MAP = Botarium.finalizeRegistration(BLOCK_LOOKUP_MAP, FINALIZED_BLOCK_LOOKUP_MAP, "fluid containing block");
        return FINALIZED_BLOCK_LOOKUP_MAP;
    }

    public static Map<Item, BotariumFluidItem<?>> getItemRegistry() {
        FINALIZED_ITEM_LOOKUP_MAP = Botarium.finalizeRegistration(ITEM_LOOKUP_MAP, FINALIZED_ITEM_LOOKUP_MAP, "fluid containing item");
        return FINALIZED_ITEM_LOOKUP_MAP;
    }

    public static BotariumFluidBlock<?> getFluidBlock(Block block) {
        return FluidApi.getBlockRegistry().get(block);
    }

    public static BotariumFluidBlock<?> getFluidBlock(BlockEntityType<?> blockEntity) {
        return FluidApi.getBlockEntityRegistry().get(blockEntity);
    }

    public static BotariumFluidItem<?> getFluidItem(Item item) {
        return FluidApi.getItemRegistry().get(item);
    }

    public static <T extends FluidContainer & Updatable> T getAPIFluidContainer(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        BotariumFluidBlock getter = FluidApi.getFluidBlock(state.m_60734_());
        if (getter == null && entity != null && (getter = FluidApi.getFluidBlock(entity.m_58903_())) == null && entity instanceof BotariumFluidBlock) {
            BotariumFluidBlock fluidGetter;
            getter = fluidGetter = (BotariumFluidBlock)entity;
        }
        if (getter == null) {
            return null;
        }
        return (T)getter.getFluidContainer(level, pos, state, entity, direction);
    }

    public static void registerFluidBlockEntity(Supplier<BlockEntityType<?>> block, BotariumFluidBlock<?> getter) {
        BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerFluidBlockEntity(BotariumFluidBlock<?> getter, Supplier<BlockEntityType<?>> ... blocks) {
        for (Supplier<BlockEntityType<?>> block : blocks) {
            BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerFluidBlock(Supplier<Block> block, BotariumFluidBlock<?> getter) {
        BLOCK_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerFluidBlock(BotariumFluidBlock<?> getter, Supplier<Block> ... blocks) {
        for (Supplier<Block> block : blocks) {
            BLOCK_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerFluidItem(Supplier<Item> item, BotariumFluidItem<?> getter) {
        ITEM_LOOKUP_MAP.put(item, getter);
    }

    @SafeVarargs
    public static void registerFluidItem(BotariumFluidItem<?> getter, Supplier<Item> ... items) {
        for (Supplier<Item> item : items) {
            ITEM_LOOKUP_MAP.put(item, getter);
        }
    }

    public static long moveFluid(FluidContainer from, FluidContainer to, FluidHolder amount, boolean simulate) {
        FluidHolder extracted = from.extractFluid(amount, true);
        long inserted = to.insertFluid(extracted, true);
        FluidHolder toInsert = amount.copyWithAmount(inserted);
        FluidHolder simulatedExtraction = from.extractFluid(toInsert, true);
        if (!simulate && inserted > 0L && simulatedExtraction.getFluidAmount() == inserted) {
            from.extractFluid(toInsert, false);
            to.insertFluid(toInsert, false);
        }
        return Math.max(0L, inserted);
    }

    public static long moveFluid(ItemStackHolder from, ItemStackHolder to, FluidHolder fluidHolder, boolean simulate) {
        ItemFluidContainer fromFluid = FluidContainer.of(from);
        ItemFluidContainer toFluid = FluidContainer.of(to);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(BlockEntity from, BlockEntity to, FluidHolder fluidHolder, boolean simulate) {
        FluidContainer fromFluid = FluidContainer.of(from, null);
        FluidContainer toFluid = FluidContainer.of(to, null);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(Level level, BlockPos fromPos, @Nullable Direction fromDirection, BlockPos toPos, @Nullable Direction toDirection, FluidHolder fluidHolder, boolean simulate) {
        FluidContainer fromFluid = FluidContainer.of(level, fromPos, fromDirection);
        FluidContainer toFluid = FluidContainer.of(level, toPos, toDirection);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(BlockEntity from, Direction direction, ItemStackHolder to, FluidHolder fluidHolder, boolean simulate) {
        FluidContainer fromFluid = FluidContainer.of(from, direction);
        ItemFluidContainer toFluid = FluidContainer.of(to);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(ItemStackHolder from, BlockEntity to, Direction direction, FluidHolder fluidHolder, boolean simulate) {
        ItemFluidContainer fromFluid = FluidContainer.of(from);
        FluidContainer toFluid = FluidContainer.of(to, direction);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }
}

