/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge;

import earth.terrarium.botarium.Botarium;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.fluid.FluidHoldingBlock;
import earth.terrarium.botarium.api.item.ItemContainerBlock;
import earth.terrarium.botarium.forge.energy.ForgeEnergyContainer;
import earth.terrarium.botarium.forge.fluid.ForgeFluidContainer;
import earth.terrarium.botarium.forge.item.ItemContainerWrapper;
import earth.terrarium.botarium.impl.NewApiForge;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

@Mod(value="botarium")
public class BotariumForge {
    public BotariumForge() {
        Botarium.init();
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addGenericListener(BlockEntity.class, BotariumForge::attachBlockCapabilities);
        bus.addGenericListener(BlockEntity.class, NewApiForge::attachBlockCapabilities);
        bus.addGenericListener(ItemStack.class, NewApiForge::attachItemCapabilities);
    }

    public static void attachBlockCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof EnergyBlock) {
            EnergyBlock energyBlock = (EnergyBlock)object;
            event.addCapability(new ResourceLocation("botarium", "energy"), (ICapabilityProvider)new ForgeEnergyContainer(energyBlock.getEnergyStorage(), (BlockEntity)event.getObject()));
        }
        if ((object = event.getObject()) instanceof FluidHoldingBlock) {
            FluidHoldingBlock fluidHoldingBlock = (FluidHoldingBlock)object;
            event.addCapability(new ResourceLocation("botarium", "fluid"), (ICapabilityProvider)new ForgeFluidContainer(fluidHoldingBlock.getFluidContainer()));
        }
        if ((object = event.getObject()) instanceof ItemContainerBlock) {
            ItemContainerBlock itemContainerBlock = (ItemContainerBlock)object;
            event.addCapability(new ResourceLocation("botarium", "item"), (ICapabilityProvider)new ItemContainerWrapper(itemContainerBlock.getContainer()));
        }
    }
}

