/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge.extensions;

import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.PlatformFluidHandler;
import earth.terrarium.botarium.api.fluid.PlatformFluidItemHandler;
import earth.terrarium.botarium.forge.fluid.ForgeFluidHandler;
import earth.terrarium.botarium.forge.fluid.ForgeFluidHolder;
import earth.terrarium.botarium.forge.fluid.ForgeFluidItemHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.msrandom.extensions.annotations.ClassExtension;
import org.jetbrains.annotations.Nullable;

@ClassExtension(value=FluidHooks.class)
public class FluidHooksImpl {
    public static FluidHolder newFluidHolder(Fluid fluid, long amount, CompoundTag tag) {
        return new ForgeFluidHolder(fluid, (int)amount, tag);
    }

    public static FluidHolder fluidFromCompound(CompoundTag compoundTag) {
        return ForgeFluidHolder.fromCompound(compoundTag);
    }

    public static PlatformFluidItemHandler getItemFluidManager(ItemStack stack) {
        return new ForgeFluidItemHandler((IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(IllegalArgumentException::new));
    }

    public static PlatformFluidHandler getBlockFluidManager(BlockEntity entity, @Nullable Direction direction) {
        return new ForgeFluidHandler((IFluidHandler)entity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).orElseThrow(IllegalArgumentException::new));
    }

    public static boolean isFluidContainingBlock(BlockEntity entity, @Nullable Direction direction) {
        return entity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).isPresent();
    }

    public static boolean isFluidContainingItem(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    public static FluidHolder emptyFluid() {
        return ForgeFluidHolder.empty();
    }

    public static long toMillibuckets(long amount) {
        return amount;
    }

    public static long getBucketAmount() {
        return 1000L;
    }

    public static long getBottleAmount() {
        return 250L;
    }

    public static long getBlockAmount() {
        return 1000L;
    }

    public static long getIngotAmount() {
        return 90L;
    }

    public static long getNuggetAmount() {
        return 10L;
    }
}

