/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.block.entity;

import com.izofar.bygonenether.entity.PiglinPrisoner;
import com.izofar.bygonenether.init.ModEntityTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableInt;

public class NetheriteBellBlockEntity
extends BlockEntity {
    private static final int DURATION = 50;
    private static final int GLOW_DURATION = 300;
    private static final int MIN_TICKS_BETWEEN_SEARCHES = 60;
    private static final int MAX_RESONATION_TICKS = 40;
    private static final int TICKS_BEFORE_RESONATION = 5;
    private static final int SEARCH_RADIUS = 48;
    private static final int HEAR_BELL_RADIUS = 32;
    private static final int HIGHLIGHT_PIGLIN_PRISONERS_RADIUS = 48;
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public Direction clickDirection;
    private List<LivingEntity> nearbyEntities;
    private boolean resonating;
    private int resonationTicks;

    public NetheriteBellBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModEntityTypes.NETHERITE_BELL.get(), blockPos, blockState);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = Direction.m_122376_((int)type);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, NetheriteBellBlockEntity blockEntity) {
        NetheriteBellBlockEntity.tick(level, blockPos, blockState, blockEntity, NetheriteBellBlockEntity::showBellParticles);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, NetheriteBellBlockEntity blockEntity) {
        NetheriteBellBlockEntity.tick(level, blockPos, blockState, blockEntity, NetheriteBellBlockEntity::completePiglinPrisoneRescue);
    }

    private static void tick(Level level, BlockPos blockPos, BlockState blockState, NetheriteBellBlockEntity blockEntity, ResonationEndAction endAction) {
        if (blockEntity.shaking) {
            ++blockEntity.ticks;
        }
        if (blockEntity.ticks >= 50) {
            blockEntity.shaking = false;
            blockEntity.ticks = 0;
        }
        if (blockEntity.ticks >= 5 && blockEntity.resonationTicks == 0 && NetheriteBellBlockEntity.arePiglinPrisonersNearby(blockPos, blockEntity.nearbyEntities)) {
            blockEntity.resonating = true;
            level.m_5594_(null, blockPos, SoundEvents.f_11700_, SoundSource.BLOCKS, 1.5f, 0.8f);
        }
        if (blockEntity.resonating) {
            if (blockEntity.resonationTicks < 40) {
                ++blockEntity.resonationTicks;
            } else {
                endAction.run(level, blockPos, blockEntity.nearbyEntities);
                blockEntity.resonating = false;
            }
        }
    }

    public void onHit(Direction direction) {
        BlockPos blockPos = this.m_58899_();
        this.clickDirection = direction;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        this.f_58857_.m_7696_(blockPos, this.m_58900_().m_60734_(), 1, direction.m_122411_());
    }

    private void updateEntities() {
        BlockPos blockpos = this.m_58899_();
        if (this.f_58857_.m_46467_() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
            this.lastRingTimestamp = this.f_58857_.m_46467_();
            AABB aabb = new AABB(blockpos).m_82400_(48.0);
            this.nearbyEntities = this.f_58857_.m_45976_(LivingEntity.class, aabb);
        }
        if (!this.f_58857_.f_46443_) {
            for (LivingEntity livingentity : this.nearbyEntities) {
                if (!NetheriteBellBlockEntity.isLivingEntityWithinRange(blockpos, livingentity, 32)) continue;
                livingentity.m_6274_().m_21879_(MemoryModuleType.f_26325_, (Object)this.f_58857_.m_46467_());
            }
        }
    }

    private static boolean arePiglinPrisonersNearby(BlockPos blockPos, List<LivingEntity> piglinPrisoners) {
        for (LivingEntity livingentity : piglinPrisoners) {
            if (!NetheriteBellBlockEntity.isRescuedPiglinPrisonerWithinRange(blockPos, livingentity, 32)) continue;
            return true;
        }
        return false;
    }

    private static void completePiglinPrisoneRescue(Level level, BlockPos blockPos, List<LivingEntity> piglinPrisoners) {
        piglinPrisoners.stream().filter(piglinPrisoner -> NetheriteBellBlockEntity.isRescuedPiglinPrisonerWithinRange(blockPos, piglinPrisoner, 48)).forEach(NetheriteBellBlockEntity::rescue);
    }

    private static void showBellParticles(Level level, BlockPos blockPos, List<LivingEntity> piglinPrisoners) {
        MutableInt mutableint = new MutableInt(16700985);
        int i = (int)piglinPrisoners.stream().filter(piglinPrisoner -> blockPos.m_203195_((Position)piglinPrisoner.m_20182_(), 48.0)).count();
        piglinPrisoners.stream().filter(piglinPrisoner -> NetheriteBellBlockEntity.isRescuedPiglinPrisonerWithinRange(blockPos, piglinPrisoner, 48)).forEach(p_155195_ -> {
            double d0 = Math.sqrt((p_155195_.m_20185_() - (double)blockPos.m_123341_()) * (p_155195_.m_20185_() - (double)blockPos.m_123341_()) + (p_155195_.m_20189_() - (double)blockPos.m_123343_()) * (p_155195_.m_20189_() - (double)blockPos.m_123343_()));
            double d1 = (double)((float)blockPos.m_123341_() + 0.5f) + 1.0 / d0 * (p_155195_.m_20185_() - (double)blockPos.m_123341_());
            double d2 = (double)((float)blockPos.m_123343_() + 0.5f) + 1.0 / d0 * (p_155195_.m_20189_() - (double)blockPos.m_123343_());
            int j = Mth.m_14045_((int)((i - 21) / -2), (int)3, (int)15);
            for (int k = 0; k < j; ++k) {
                int l = mutableint.addAndGet(5);
                double d3 = (double)FastColor.ARGB32.m_13665_((int)l) / 255.0;
                double d4 = (double)FastColor.ARGB32.m_13667_((int)l) / 255.0;
                double d5 = (double)FastColor.ARGB32.m_13669_((int)l) / 255.0;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, d1, (double)((float)blockPos.m_123342_() + 0.5f), d2, d3, d4, d5);
            }
        });
    }

    private static boolean isLivingEntityWithinRange(BlockPos blockPos, LivingEntity livingentity, int radius) {
        return livingentity.m_6084_() && !livingentity.m_213877_() && blockPos.m_203195_((Position)livingentity.m_20182_(), (double)radius);
    }

    private static boolean isRescuedPiglinPrisonerWithinRange(BlockPos blockPos, LivingEntity livingEntity, int radius) {
        return NetheriteBellBlockEntity.isLivingEntityWithinRange(blockPos, livingEntity, radius) && livingEntity.m_6095_() == ModEntityTypes.PIGLIN_PRISONER.get() && ((PiglinPrisoner)livingEntity).getTempter() != null;
    }

    private static void rescue(LivingEntity entity) {
        NetheriteBellBlockEntity.glow(entity);
        NetheriteBellBlockEntity.broadcastRescue(entity);
    }

    private static void glow(LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 300));
    }

    private static void broadcastRescue(LivingEntity entity) {
        ((PiglinPrisoner)entity).rescue();
    }

    @FunctionalInterface
    static interface ResonationEndAction {
        public void run(Level var1, BlockPos var2, List<LivingEntity> var3);
    }
}

