/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.turtle.TurtleUtil;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;

public class TurtleEquipCommand
implements ITurtleCommand {
    private final TurtleSide side;

    public TurtleEquipCommand(TurtleSide side) {
        this.side = side;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        ItemStack craftingItem;
        ITurtleUpgrade oldUpgrade;
        ITurtleUpgrade newUpgrade;
        ItemStack newUpgradeStack;
        ItemStack selectedStack = turtle.getInventory().m_8020_(turtle.getSelectedSlot());
        if (!selectedStack.m_41619_()) {
            newUpgradeStack = selectedStack.m_41777_();
            newUpgrade = TurtleUpgrades.instance().get(newUpgradeStack);
            if (newUpgrade == null) {
                return TurtleCommandResult.failure("Not a valid upgrade");
            }
        } else {
            newUpgradeStack = null;
            newUpgrade = null;
        }
        ItemStack oldUpgradeStack = (oldUpgrade = turtle.getUpgrade(this.side)) != null ? (!(craftingItem = oldUpgrade.getCraftingItem()).m_41619_() ? craftingItem.m_41777_() : null) : null;
        if (newUpgradeStack != null) {
            turtle.getInventory().m_7407_(turtle.getSelectedSlot(), 1);
        }
        if (oldUpgradeStack != null) {
            TurtleUtil.storeItemOrDrop(turtle, oldUpgradeStack);
        }
        turtle.setUpgrade(this.side, newUpgrade);
        if (newUpgrade != null || oldUpgrade != null) {
            turtle.playAnimation(TurtleAnimation.WAIT);
        }
        return TurtleCommandResult.success();
    }
}

