/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.blockEntity;

import cc.tweaked_programs.cccbridge.CCCRegister;
import cc.tweaked_programs.cccbridge.CCCSoundEvents;
import cc.tweaked_programs.cccbridge.behaviour.LuaScrollValueBehaviour;
import cc.tweaked_programs.cccbridge.blockEntity.PeripheralBlockEntity;
import cc.tweaked_programs.cccbridge.peripherals.ScrollerBlockPeripheral;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.VecHelper;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ScrollerBlockEntity
extends SmartBlockEntity
implements PeripheralBlockEntity {
    private ScrollerBlockPeripheral peripheral;
    private boolean locked = false;
    private boolean updateLock = false;
    private boolean playTickSound = false;
    private LuaScrollValueBehaviour scroller;

    public ScrollerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CCCRegister.SCROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public IPeripheral getPeripheral(@Nullable Direction side) {
        if (side == ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_() || side == null) {
            if (this.peripheral == null) {
                this.peripheral = new ScrollerBlockPeripheral(this);
            }
            return this.peripheral;
        }
        return null;
    }

    public void setLock(boolean state) {
        this.locked = state;
        this.updateLock = true;
    }

    public int getValue() {
        return this.scroller.getValue();
    }

    public void setValue(int value) {
        this.scroller.setValue(value);
    }

    public void fireUpdateValueEvent() {
        if (this.peripheral != null) {
            this.peripheral.sendEvent("scroller_changed", new Object[]{this.scroller.getValue()});
        }
    }

    public static void tick(Level world, BlockPos blockPos, BlockState state, BlockEntity be) {
        if (!(be instanceof ScrollerBlockEntity)) {
            return;
        }
        ScrollerBlockEntity scroller = (ScrollerBlockEntity)be;
        if (scroller.updateLock && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61444_) != scroller.locked) {
            world.m_5594_(null, blockPos, scroller.locked ? CCCSoundEvents.CAGE_LOCK : CCCSoundEvents.CAGE_UNLOCK, SoundSource.BLOCKS, 1.0f, 1.5f);
            world.m_7731_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61444_, (Comparable)Boolean.valueOf(scroller.locked)), 19);
            scroller.updateLock = false;
        }
        if (scroller.playTickSound) {
            world.m_5594_(null, blockPos, AllSoundEvents.SCROLL_VALUE.getMainEvent(), SoundSource.BLOCKS, 0.25f, 1.5f);
            scroller.playTickSound = false;
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        if (this.scroller == null) {
            this.scroller = new LuaScrollValueBehaviour(this, (ValueBoxTransform)new ControllerValueBoxTransform());
        }
        behaviours.add((BlockEntityBehaviour)this.scroller);
    }

    public int getLimit() {
        return this.scroller.getMax();
    }

    public void setLimit(int limit) {
        this.scroller.between(limit);
    }

    public boolean hasMinus() {
        return this.scroller.hasMinus();
    }

    public void toggleMinusSpectrum(boolean state) {
        this.scroller.setHasMinus(state);
    }

    private static class ControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        private ControllerValueBoxTransform() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)0.01);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return state.m_61143_((Property)BlockStateProperties.f_61372_) == direction;
        }
    }
}

