/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.events;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.check.RegisterMod;
import com.natamus.collective_common_forge.config.CollectiveConfigHandler;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.features.PlayerHeadCacheFeature;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.functions.HeadFunctions;
import com.natamus.collective_common_forge.functions.SpawnEntityFunctions;
import com.natamus.collective_common_forge.objects.SAMObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CollectiveEvents {
    public static WeakHashMap<ServerLevel, List<Entity>> entitiesToSpawn = new WeakHashMap();
    public static WeakHashMap<ServerLevel, WeakHashMap<Entity, Entity>> entitiesToRide = new WeakHashMap();
    public static CopyOnWriteArrayList<Pair<Integer, Runnable>> scheduledRunnables = new CopyOnWriteArrayList();

    public static void onWorldTick(ServerLevel serverLevel) {
        if (entitiesToSpawn.computeIfAbsent(serverLevel, k -> new ArrayList()).size() > 0) {
            Entity tospawn = entitiesToSpawn.get(serverLevel).get(0);
            serverLevel.m_47205_(tospawn);
            if (entitiesToRide.computeIfAbsent(serverLevel, k -> new WeakHashMap()).containsKey(tospawn)) {
                Entity rider = entitiesToRide.get(serverLevel).get(tospawn);
                rider.m_20329_(tospawn);
                entitiesToRide.get(serverLevel).remove(tospawn);
            }
            entitiesToSpawn.get(serverLevel).remove(0);
        }
    }

    public static void onServerTick(MinecraftServer minecraftServer) {
        int serverTickCount = minecraftServer.m_129921_();
        for (Pair<Integer, Runnable> pair : scheduledRunnables) {
            if ((Integer)pair.getFirst() > serverTickCount) continue;
            minecraftServer.m_6937_((Runnable)new TickTask(minecraftServer.m_129921_(), (Runnable)pair.getSecond()));
            scheduledRunnables.remove(pair);
        }
    }

    public static boolean onEntityJoinLevel(Level level, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (RegisterMod.shouldDoCheck) {
                RegisterMod.joinWorldProcess(level, player);
            }
            if (PlayerHeadCacheFeature.isHeadCachingEnabled()) {
                PlayerHeadCacheFeature.cachePlayer(player);
            }
        }
        if (entity.m_213877_()) {
            return true;
        }
        if (GlobalVariables.globalSAMs.isEmpty()) {
            return true;
        }
        Set tags = entity.m_19880_();
        if (tags.contains("collective.checked")) {
            return true;
        }
        entity.m_20049_("collective.checked");
        EntityType entityType = entity.m_6095_();
        if (!GlobalVariables.activeSAMEntityTypes.contains(entityType)) {
            return true;
        }
        boolean isFromSpawner = tags.contains("collective.fromspawner");
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject sam : GlobalVariables.globalSAMs) {
            if (sam == null || sam.fromEntityType == null || !sam.fromEntityType.equals((Object)entityType) || sam.onlyFromSpawner && !isFromSpawner || !sam.onlyFromSpawner && isFromSpawner) continue;
            possibles.add(sam);
        }
        int size = possibles.size();
        if (size == 0) {
            return true;
        }
        Vec3 eVec = entity.m_20182_();
        boolean ageable = entity instanceof AgeableMob;
        boolean isOnSurface = BlockPosFunctions.isOnSurface(level, eVec);
        for (SAMObject sam : possibles) {
            LivingEntity le;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.changeChance || (!sam.onlyOnSurface ? sam.onlyBelowSurface && isOnSurface : !isOnSurface)) continue;
            if (sam.onlyBelowSpecificY && eVec.f_82480_ >= (double)sam.specificY) continue;
            Entity to = sam.toEntityType.m_20615_(level);
            if (to == null) {
                return true;
            }
            to.m_6034_(eVec.f_82479_, eVec.f_82480_, eVec.f_82481_);
            if (ageable && to instanceof AgeableMob) {
                AgeableMob am = (AgeableMob)to;
                am.m_146762_(((AgeableMob)entity).m_146764_());
                to = am;
            }
            boolean ignoreMainhand = false;
            if (sam.itemToHold != null && to instanceof LivingEntity && !(le = (LivingEntity)to).m_21205_().m_41720_().equals(sam.itemToHold)) {
                le.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)sam.itemToHold, 1));
                ignoreMainhand = true;
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideNotReplace) {
                AbstractHorse ah = (AbstractHorse)to;
                ah.m_30651_(true);
                ride = true;
            } else if (CollectiveConfigHandler.transferItemsBetweenReplacedEntities) {
                EntityFunctions.transferItemsBetweenEntities(entity, to, ignoreMainhand);
            }
            if (!(level instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (ride) {
                SpawnEntityFunctions.startRidingEntityOnNextTick(serverLevel, to, entity);
            } else {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            to.m_20049_("collective.checked");
            SpawnEntityFunctions.spawnEntityOnNextTick(serverLevel, to);
            return ride;
        }
        return true;
    }

    public static boolean onBlockBreak(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity) {
        if (level.f_46443_) {
            return true;
        }
        Block block = state.m_60734_();
        if (block instanceof SkullBlock || block instanceof WallSkullBlock) {
            if (player.m_7500_()) {
                return true;
            }
            BlockEntity targetBlockEntity = level.m_7702_(pos);
            if (!(targetBlockEntity instanceof SkullBlockEntity)) {
                return true;
            }
            SkullBlockEntity skullBlockEntity = (SkullBlockEntity)targetBlockEntity;
            if (skullBlockEntity == null) {
                return true;
            }
            GameProfile gameProfile = skullBlockEntity.m_59779_();
            if (gameProfile == null) {
                return true;
            }
            UUID uuid = gameProfile.getId();
            if (uuid.toString().startsWith("ffffffff")) {
                return true;
            }
            ItemStack namedHeadStack = null;
            if (gameProfile.getName() != null && !gameProfile.getName().equals("")) {
                namedHeadStack = HeadFunctions.getNewPlayerHead(gameProfile, 1);
            }
            if (namedHeadStack == null) {
                GameProfile uuidGameProfile;
                if (PlayerHeadCacheFeature.cachedGameProfileMap.containsKey(uuid)) {
                    uuidGameProfile = PlayerHeadCacheFeature.cachedGameProfileMap.get(uuid);
                } else {
                    MinecraftSessionService minecraftSessionService = ((ServerLevel)level).m_7654_().m_129925_();
                    uuidGameProfile = minecraftSessionService.fillProfileProperties(new GameProfile(uuid, null), false);
                    String gameProfileName = uuidGameProfile.getName();
                    if (gameProfileName == null || gameProfileName.equals("")) {
                        return true;
                    }
                    PlayerHeadCacheFeature.cachedGameProfileMap.put(uuid, uuidGameProfile);
                }
                namedHeadStack = HeadFunctions.getNewPlayerHead(uuidGameProfile, 1);
            }
            if (namedHeadStack != null) {
                level.m_46961_(pos, false);
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), namedHeadStack));
                return false;
            }
        }
        return true;
    }

    public static boolean onEntityBlockPlace(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack itemStack) {
        if (level.f_46443_) {
            return true;
        }
        if (!(entity instanceof Player)) {
            return true;
        }
        if (!(itemStack.m_41720_() instanceof PlayerHeadItem)) {
            return true;
        }
        String itemName = itemStack.m_41786_().getString();
        if (!itemName.contains("'s Head")) {
            return true;
        }
        CompoundTag skullOwner = itemStack.m_41737_("SkullOwner");
        if (skullOwner == null) {
            return true;
        }
        int[] idIntArray = skullOwner.m_128465_("Id");
        if (idIntArray[0] != -1) {
            return true;
        }
        String headName = itemName.replace("'s Head", "");
        CompoundTag skullOwnerCompoundTag = HeadFunctions.getSkullOwnerCompoundTag((ServerLevel)level, headName);
        itemStack.m_41700_("SkullOwner", (Tag)skullOwnerCompoundTag);
        return false;
    }
}

