/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_forge.data.Constants;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PlayerFunctions {
    public static boolean respawnPlayer(Level world, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        MinecraftServer server = world.m_7654_();
        ServerPlayer serverplayer = (ServerPlayer)player;
        if (serverplayer.f_8944_) {
            serverplayer.f_8944_ = false;
            serverplayer = server.m_6846_().m_11236_(serverplayer, true);
            CriteriaTriggers.f_10588_.m_19757_(serverplayer, Level.f_46430_, Level.f_46428_);
        } else if (serverplayer.m_21223_() <= 0.0f) {
            server.m_6846_().m_11236_(serverplayer, false);
        }
        return true;
    }

    public static Player matchPlayer(Player player, String other) {
        return PlayerFunctions.matchPlayer(player.m_20193_(), other);
    }

    public static Player matchPlayer(Level world, String other) {
        List players = world.m_6907_();
        for (Player onlineplayer : players) {
            if (!onlineplayer.m_7755_().getString().toLowerCase().equals(other)) continue;
            return onlineplayer;
        }
        return null;
    }

    public static boolean isHoldingWater(Player player) {
        return player.m_21120_(InteractionHand.OFF_HAND).m_41720_().equals(Items.f_42447_) || player.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(Items.f_42447_);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid) {
        return PlayerFunctions.isJoiningWorldForTheFirstTime(player, modid, false);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid, boolean mustHaveEmptyInventory) {
        return PlayerFunctions.isJoiningWorldForTheFirstTime(player, modid, false, true);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid, boolean mustHaveEmptyInventory, boolean mustBeCloseToSpawn) {
        String firstjointag = "collective.firstJoin." + modid;
        String playerName = player.m_7755_().getString();
        Set tags = player.m_19880_();
        if (tags.contains(firstjointag)) {
            return false;
        }
        player.m_20049_(firstjointag);
        if (mustHaveEmptyInventory) {
            Inventory inv = player.m_150109_();
            boolean isempty = true;
            for (int i = 0; i < 36; ++i) {
                if (inv.m_8020_(i).m_41619_()) continue;
                isempty = false;
                break;
            }
            if (!isempty) {
                Constants.LOG.debug("[" + modid + "] Inventory of " + playerName + " is not empty, first join is false.");
                return false;
            }
        }
        if (mustBeCloseToSpawn) {
            Level level = player.m_20193_();
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockPos spawnPos = serverPlayer.m_8961_();
            if (spawnPos == null) {
                spawnPos = serverLevel.m_220360_();
            }
            Constants.LOG.debug("[" + modid + "] Checking for first join of " + playerName + " with spawn position: " + spawnPos.m_123344_());
            BlockPos playerPos = player.m_20183_();
            BlockPos checkPos = new BlockPos(playerPos.m_123341_(), spawnPos.m_123342_(), playerPos.m_123343_());
            int spawnRadius = ((GameRules.IntegerValue)serverLevel.m_46469_().m_46170_(GameRules.f_46147_)).m_46288_();
            Constants.LOG.debug("[" + modid + "] Checking for first join of " + playerName + " with spawn radius: " + spawnRadius);
            return checkPos.m_123314_((Vec3i)spawnPos, (double)(spawnRadius * 2));
        }
        return true;
    }

    public static BlockPos getSpawnPoint(Level world, Player player) {
        Vec3 spawnvec = PlayerFunctions.getSpawnVec(world, player);
        return new BlockPos(spawnvec.f_82479_, spawnvec.f_82480_, spawnvec.f_82481_);
    }

    public static Vec3 getSpawnVec(Level world, Player player) {
        Optional optionalbed;
        ServerPlayer serverplayer = (ServerPlayer)player;
        ServerLevel ServerLevel2 = (ServerLevel)world;
        BlockPos respawnlocation = ServerLevel2.m_220360_();
        Vec3 respawnvec = new Vec3((double)respawnlocation.m_123341_(), (double)respawnlocation.m_123342_(), (double)respawnlocation.m_123343_());
        BlockPos bedpos = serverplayer.m_8961_();
        if (bedpos != null && (optionalbed = Player.m_36130_((ServerLevel)ServerLevel2, (BlockPos)bedpos, (float)1.0f, (boolean)false, (boolean)false)).isPresent()) {
            Vec3 bedvec = (Vec3)optionalbed.get();
            BlockPos bp = new BlockPos(bedvec);
            Iterator it = BlockPos.m_121886_((int)(bp.m_123341_() - 1), (int)(bp.m_123342_() - 1), (int)(bp.m_123343_() - 1), (int)(bp.m_123341_() + 1), (int)(bp.m_123342_() + 1), (int)(bp.m_123343_() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos np = (BlockPos)it.next();
                BlockState state = world.m_8055_(np);
                Block block = state.m_60734_();
                if (!(block instanceof BedBlock)) continue;
                respawnvec = bedvec;
                break;
            }
        }
        return respawnvec;
    }

    public static InteractionHand getOtherHand(InteractionHand hand) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionHand.OFF_HAND;
        }
        return InteractionHand.MAIN_HAND;
    }

    public static String getPlayerGearString(Player player) {
        StringBuilder skconfig = new StringBuilder();
        ItemStack offhand = player.m_6844_(EquipmentSlot.OFFHAND);
        if (!offhand.m_41619_()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(offhand);
            skconfig.append("'offhand' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("'offhand' : '',");
        }
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (!head.m_41619_()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(head);
            skconfig.append("\n'head' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'head' : '',");
        }
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (!chest.m_41619_()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(chest);
            skconfig.append("\n'chest' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'chest' : '',");
        }
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        if (!legs.m_41619_()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(legs);
            skconfig.append("\n'legs' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'legs' : '',");
        }
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        if (!feet.m_41619_()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(feet);
            skconfig.append("\n'feet' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'feet' : '',");
        }
        Inventory inv = player.m_150109_();
        for (int i = 0; i < 36; ++i) {
            ItemStack slot = inv.m_8020_(i);
            if (!slot.m_41619_()) {
                String nbtstring = ItemFunctions.getNBTStringFromItemStack(slot);
                skconfig.append("\n").append(i).append(" : ").append("'").append(nbtstring).append("',");
                continue;
            }
            skconfig.append("\n").append(i).append(" : '',");
        }
        return skconfig.toString();
    }

    public static String getPlayerGearStringFromHashMap(HashMap<String, ItemStack> gear) {
        StringBuilder gearstring = new StringBuilder();
        ArrayList<String> specialslots = new ArrayList<String>(Arrays.asList("offhand", "head", "chest", "legs", "feet"));
        for (String specialslot : specialslots) {
            String specialslotstring = "";
            if (gear.containsKey(specialslot)) {
                specialslotstring = ItemFunctions.getNBTStringFromItemStack(gear.get(specialslot));
            }
            if (!gearstring.toString().equals("")) {
                gearstring.append("\n");
            }
            gearstring.append("'").append(specialslot).append("'").append(" : ").append("'").append(specialslotstring).append("',");
        }
        NonNullList emptyinventory = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
        for (int i = 0; i < emptyinventory.size(); ++i) {
            String itemstring = "";
            if (gear.containsKey("" + i)) {
                itemstring = ItemFunctions.getNBTStringFromItemStack(gear.get("" + i));
            }
            gearstring.append("\n").append(i).append(" : '").append(itemstring).append("',");
        }
        return gearstring.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void setPlayerGearFromString(Player player, String gearconfig) {
        String[] gearspl = gearconfig.split("',[\\r\\n]+");
        int newlinecount = gearspl.length;
        if (newlinecount < 40) {
            Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The gear config does not contain 40 lines and is invalid.");
            return;
        }
        boolean cleared = false;
        block18: for (String string : gearspl) {
            EquipmentSlot type;
            void var8_8;
            String[] lspl;
            void var8_12;
            String string2 = string.trim();
            if (string2.endsWith(",")) {
                String string3 = string2.substring(0, string2.length() - 1);
            }
            if (!var8_12.endsWith("'")) {
                String string4 = (String)var8_12 + "'";
            }
            if ((lspl = var8_8.split(" : ")).length != 2) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The line " + (String)var8_8 + " is invalid.");
                return;
            }
            String slotstring = lspl[0].replace("'", "");
            String data = lspl[1];
            if (data.startsWith("'")) {
                data = data.substring(1);
            }
            if (data.endsWith("'")) {
                data = data.substring(0, data.length() - 1);
            }
            if (data.length() < 2) continue;
            data = data.replaceAll("\r", "");
            ItemStack itemstack = null;
            try {
                CompoundTag newnbt = TagParser.m_129359_((String)data);
                itemstack = ItemStack.m_41712_((CompoundTag)newnbt);
            }
            catch (CommandSyntaxException e0) {
                try {
                    data = data.replace("\",\"", "|||,|||").replace(" \"", " '").replace("\" ", "' ").replace("|||,|||", "\",\"");
                    CompoundTag newnbt = TagParser.m_129359_((String)data);
                    itemstack = ItemStack.m_41712_((CompoundTag)newnbt);
                }
                catch (CommandSyntaxException e1) {
                    e1.printStackTrace();
                }
            }
            if (itemstack == null) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: Unable to get the correct itemstack data from data " + data);
                return;
            }
            if (!cleared) {
                cleared = true;
                player.m_150109_().m_6211_();
            }
            if (NumberFunctions.isNumeric(slotstring)) {
                int slot = Integer.parseInt(slotstring);
                player.m_150109_().m_6836_(slot, itemstack);
                continue;
            }
            switch (slotstring) {
                case "offhand": {
                    type = EquipmentSlot.OFFHAND;
                    break;
                }
                case "head": {
                    type = EquipmentSlot.HEAD;
                    break;
                }
                case "chest": {
                    type = EquipmentSlot.CHEST;
                    break;
                }
                case "legs": {
                    type = EquipmentSlot.LEGS;
                    break;
                }
                case "feet": {
                    type = EquipmentSlot.FEET;
                    break;
                }
                default: {
                    continue block18;
                }
            }
            player.m_8061_(type, itemstack);
        }
    }
}

