/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.events;

import com.mojang.brigadier.CommandDispatcher;
import com.natamus.collective_common_forge.cmds.CommandCollective;
import com.natamus.collective_common_forge.config.GenerateJSONFiles;
import com.natamus.collective_common_forge.events.CollectiveEvents;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RegisterCollectiveForgeEvents {
    @SubscribeEvent
    public void onServerStarted(ServerAboutToStartEvent e) {
        GenerateJSONFiles.initGeneration(e.getServer());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent e) {
        Level level = e.level;
        if (level.f_46443_ || !e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        CollectiveEvents.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (!e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        CollectiveEvents.onServerTick(e.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMobSpawnerSpecialSpawn(LivingSpawnEvent.SpecialSpawn e) {
        Level Level2 = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getLevel());
        if (Level2 == null) {
            return;
        }
        if (e.getSpawner() != null) {
            e.getEntity().m_20049_("collective.fromspawner");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMobSpawnerCheckSpawn(LivingSpawnEvent.CheckSpawn e) {
        Level Level2 = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getLevel());
        if (Level2 == null) {
            return;
        }
        if (e.getSpawner() != null) {
            e.getEntity().m_20049_("collective.fromspawner");
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent e) {
        if (!CollectiveEvents.onEntityJoinLevel(e.getLevel(), e.getEntity())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getLevel());
        if (level == null) {
            return;
        }
        if (!CollectiveEvents.onBlockBreak(level, e.getPlayer(), e.getPos(), e.getState(), null)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityBlockPlace(BlockEvent.EntityPlaceEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getLevel());
        if (level == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_41619_()) {
            itemStack = player.m_21206_();
        }
        if (!CollectiveEvents.onEntityBlockPlace(level, e.getPos(), e.getPlacedBlock(), (LivingEntity)entity, itemStack)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent e) {
        CommandCollective.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }
}

