/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.mixin;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import me.pepperbell.continuity.client.mixinterface.SpriteAtlasTextureDataExtension;
import me.pepperbell.continuity.client.mixinterface.SpriteExtension;
import me.pepperbell.continuity.client.resource.EmissiveSuffixLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextureAtlas.class})
public class SpriteAtlasTextureMixin {
    @Shadow
    @Final
    private Map<ResourceLocation, TextureAtlasSprite> f_118264_;
    @Unique
    private boolean continuity$loadingEmissiveSprites;
    @Unique
    private Map<ResourceLocation, ResourceLocation> continuity$emissiveIdMap;

    @Shadow
    private Collection<TextureAtlasSprite.Info> m_118304_(ResourceManager resourceManager, Set<ResourceLocation> ids) {
        return null;
    }

    @Shadow
    private ResourceLocation m_118324_(ResourceLocation id) {
        return null;
    }

    @Inject(method={"loadSprites(Lnet/minecraft/resource/ResourceManager;Ljava/util/Set;)Ljava/util/Collection;"}, at={@At(value="TAIL")})
    private void continuity$onTailLoadSprites(ResourceManager resourceManager, Set<ResourceLocation> ids, CallbackInfoReturnable<Collection<TextureAtlasSprite.Info>> cir) {
        if (!this.continuity$loadingEmissiveSprites) {
            this.continuity$loadingEmissiveSprites = true;
            String emissiveSuffix = EmissiveSuffixLoader.getEmissiveSuffix();
            if (emissiveSuffix != null) {
                Collection spriteInfos = (Collection)cir.getReturnValue();
                ObjectOpenHashSet emissiveIds = new ObjectOpenHashSet();
                this.continuity$emissiveIdMap = new Object2ObjectOpenHashMap();
                for (TextureAtlasSprite.Info spriteInfo : spriteInfos) {
                    ResourceLocation emissiveId;
                    ResourceLocation emissiveLocation;
                    ResourceLocation id = spriteInfo.m_118431_();
                    if (id.m_135815_().endsWith(emissiveSuffix) || !resourceManager.m_213713_(emissiveLocation = this.m_118324_(emissiveId = new ResourceLocation(id.m_135827_(), id.m_135815_() + emissiveSuffix))).isPresent()) continue;
                    emissiveIds.add(emissiveId);
                    this.continuity$emissiveIdMap.put(id, emissiveId);
                }
                if (!emissiveIds.isEmpty()) {
                    Collection<TextureAtlasSprite.Info> emissiveSpriteInfos = this.m_118304_(resourceManager, (Set<ResourceLocation>)emissiveIds);
                    spriteInfos.addAll(emissiveSpriteInfos);
                } else {
                    this.continuity$emissiveIdMap = null;
                }
            }
            this.continuity$loadingEmissiveSprites = false;
        }
    }

    @Inject(method={"stitch(Lnet/minecraft/resource/ResourceManager;Ljava/util/stream/Stream;Lnet/minecraft/util/profiler/Profiler;I)Lnet/minecraft/client/texture/SpriteAtlasTexture$Data;"}, at={@At(value="TAIL")})
    private void continuity$onTailStitch(ResourceManager resourceManager, Stream<ResourceLocation> idStream, ProfilerFiller profiler, int mipmapLevel, CallbackInfoReturnable<TextureAtlas.Preparations> cir) {
        TextureAtlas.Preparations data = (TextureAtlas.Preparations)cir.getReturnValue();
        ((SpriteAtlasTextureDataExtension)data).continuity$setEmissiveIdMap(this.continuity$emissiveIdMap);
        this.continuity$emissiveIdMap = null;
    }

    @Inject(method={"upload(Lnet/minecraft/client/texture/SpriteAtlasTexture$Data;)V"}, at={@At(value="TAIL")})
    private void continuity$onTailUpload(TextureAtlas.Preparations data, CallbackInfo ci) {
        Map<ResourceLocation, ResourceLocation> emissiveIdMap = ((SpriteAtlasTextureDataExtension)data).continuity$getEmissiveIdMap();
        if (emissiveIdMap != null) {
            emissiveIdMap.forEach((id, emissiveId) -> {
                TextureAtlasSprite emissiveSprite;
                TextureAtlasSprite sprite = this.f_118264_.get(id);
                if (sprite != null && (emissiveSprite = this.f_118264_.get(emissiveId)) != null) {
                    ((SpriteExtension)sprite).continuity$setEmissiveSprite(emissiveSprite);
                }
            });
        }
    }
}

