/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import java.util.List;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.model.CullingCache;
import me.pepperbell.continuity.client.model.ModelObjectsContainer;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.impl.client.ProcessingContextImpl;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CTMBakedModel
extends ForwardingBakedModel {
    public static final int MULTIPASS_LIMIT = 3;
    protected final List<QuadProcessor> processors;
    @Nullable
    protected final List<QuadProcessor> multipassProcessors;

    public CTMBakedModel(BakedModel wrapped, List<QuadProcessor> processors, @Nullable List<QuadProcessor> multipassProcessors) {
        this.wrapped = wrapped;
        this.processors = processors;
        this.multipassProcessors = multipassProcessors;
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        if (!((Boolean)ContinuityConfig.INSTANCE.connectedTextures.get()).booleanValue()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getConnectedTexturesState().isEnabled()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        CTMQuadTransform quadTransform = container.ctmQuadTransform;
        if (quadTransform.isActive()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        quadTransform.prepare(this.processors, this.multipassProcessors, blockView, state, pos, randomSupplier, (Boolean)ContinuityConfig.INSTANCE.useManualCulling.get());
        context.pushTransform((RenderContext.QuadTransform)quadTransform);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
        quadTransform.processingContext.accept(context);
        quadTransform.reset();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    protected static class CTMQuadTransform
    implements RenderContext.QuadTransform {
        protected final ProcessingContextImpl processingContext = new ProcessingContextImpl();
        protected final CullingCache cullingCache = new CullingCache();
        protected List<QuadProcessor> processors;
        protected List<QuadProcessor> multipassProcessors;
        protected BlockAndTintGetter blockView;
        protected BlockState state;
        protected BlockPos pos;
        protected Supplier<RandomSource> randomSupplier;
        protected boolean useManualCulling;
        protected boolean active;

        protected CTMQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            if (this.useManualCulling && this.cullingCache.shouldCull((QuadView)quad, this.blockView, this.pos, this.state)) {
                return false;
            }
            Boolean result = this.transformOnce(quad, this.processors, 0);
            if (result != null) {
                return result;
            }
            if (this.multipassProcessors != null) {
                for (int pass = 0; pass < 3; ++pass) {
                    result = this.transformOnce(quad, this.multipassProcessors, pass + 1);
                    if (result == null) continue;
                    return result;
                }
            }
            return true;
        }

        protected Boolean transformOnce(MutableQuadView quad, List<QuadProcessor> processors, int pass) {
            TextureAtlasSprite sprite = RenderUtil.getSpriteFinder().find((QuadView)quad, 0);
            int amount = processors.size();
            for (int i = 0; i < amount; ++i) {
                QuadProcessor processor = processors.get(i);
                QuadProcessor.ProcessingResult result = processor.processQuad(quad, sprite, this.blockView, this.state, this.pos, this.randomSupplier, pass, i, this.processingContext);
                if (result == QuadProcessor.ProcessingResult.CONTINUE) continue;
                if (result == QuadProcessor.ProcessingResult.STOP) {
                    return null;
                }
                if (result == QuadProcessor.ProcessingResult.ABORT_AND_CANCEL_QUAD) {
                    return false;
                }
                if (result != QuadProcessor.ProcessingResult.ABORT_AND_RENDER_QUAD) continue;
                return true;
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public void prepare(List<QuadProcessor> processors, List<QuadProcessor> multipassProcessors, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, boolean useManualCulling) {
            this.processors = processors;
            this.multipassProcessors = multipassProcessors;
            this.blockView = blockView;
            this.state = state;
            this.pos = pos;
            this.randomSupplier = randomSupplier;
            this.useManualCulling = useManualCulling;
            this.active = true;
            this.processingContext.prepare();
            this.cullingCache.prepare();
        }

        public void reset() {
            this.processors = null;
            this.multipassProcessors = null;
            this.blockView = null;
            this.state = null;
            this.pos = null;
            this.randomSupplier = null;
            this.useManualCulling = false;
            this.active = false;
            this.processingContext.reset();
        }
    }
}

