/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.model.CTMBakedModel;
import me.pepperbell.continuity.client.model.WrappingUnbakedModel;
import me.pepperbell.continuity.client.resource.CTMLoadingContainer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CTMUnbakedModel
extends WrappingUnbakedModel {
    private final List<CTMLoadingContainer<?>> containerList;
    @Nullable
    private final List<CTMLoadingContainer<?>> multipassContainerList;

    public CTMUnbakedModel(UnbakedModel wrapped, List<CTMLoadingContainer<?>> containerList, @Nullable List<CTMLoadingContainer<?>> multipassContainerList) {
        super(wrapped);
        this.containerList = containerList;
        this.multipassContainerList = multipassContainerList;
    }

    public Set<Material> getTextureDependencies(Function<ResourceLocation, UnbakedModel> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        ObjectOpenHashSet dependencies = new ObjectOpenHashSet(this.wrapped.m_5500_(unbakedModelGetter, unresolvedTextureReferences));
        for (CTMLoadingContainer<?> container : this.containerList) {
            dependencies.addAll(container.getProperties().getTextureDependencies());
        }
        if (this.multipassContainerList != null) {
            for (CTMLoadingContainer<?> container : this.multipassContainerList) {
                dependencies.addAll(container.getProperties().getTextureDependencies());
            }
        }
        return dependencies;
    }

    @Override
    @Nullable
    public BakedModel wrapBaked(@Nullable BakedModel bakedWrapped, ModelBakery loader, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotationContainer, ResourceLocation modelId) {
        if (bakedWrapped == null || bakedWrapped.m_7521_()) {
            return bakedWrapped;
        }
        return new CTMBakedModel(bakedWrapped, (List<QuadProcessor>)CTMUnbakedModel.toProcessorList(this.containerList, textureGetter), (List<QuadProcessor>)(this.multipassContainerList == null ? null : CTMUnbakedModel.toProcessorList(this.multipassContainerList, textureGetter)));
    }

    protected static ImmutableList<QuadProcessor> toProcessorList(List<CTMLoadingContainer<?>> containerList, Function<Material, TextureAtlasSprite> textureGetter) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (CTMLoadingContainer<?> container : containerList) {
            listBuilder.add((Object)container.toProcessor(textureGetter));
        }
        return listBuilder.build();
    }
}

