/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.VerticalQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.properties.StandardConnectingCTMProperties;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class VerticalHorizontalQuadProcessor
extends VerticalQuadProcessor {
    protected static final int[] SECONDARY_SPRITE_INDEX_MAP = new int[]{3, 6, 3, 3, 3, 6, 3, 3, 4, 5, 4, 4, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};

    public VerticalHorizontalQuadProcessor(TextureAtlasSprite[] sprites, ProcessingPredicate processingPredicate, ConnectionPredicate connectionPredicate, boolean innerSeams) {
        super(sprites, processingPredicate, connectionPredicate, innerSeams);
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        TextureAtlasSprite newSprite;
        BlockPos.MutableBlockPos mutablePos;
        Direction[] directions = DirectionMaps.getDirections((QuadView)quad);
        int connections = this.getConnections(directions, mutablePos = context.getData(ProcessingDataKeys.MUTABLE_POS_KEY), blockView, state, pos, quad.lightFace(), sprite);
        if (connections != 0) {
            newSprite = this.sprites[SPRITE_INDEX_MAP[connections]];
        } else {
            int secondaryConnections = this.getSecondaryConnections(directions, mutablePos, blockView, state, pos, quad.lightFace(), sprite);
            newSprite = this.sprites[SECONDARY_SPRITE_INDEX_MAP[secondaryConnections]];
        }
        return SimpleQuadProcessor.process(quad, sprite, newSprite);
    }

    protected int getSecondaryConnections(Direction[] directions, BlockPos.MutableBlockPos mutablePos, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Direction face, TextureAtlasSprite quadSprite) {
        int connections = 0;
        for (int i = 0; i < 2; ++i) {
            Direction direction = directions[i * 2];
            mutablePos.m_122159_((Vec3i)pos, direction);
            if (!this.connectionPredicate.shouldConnect(blockView, state, pos, mutablePos, face, quadSprite, this.innerSeams)) continue;
            connections |= 1 << i * 3;
            for (int j = 0; j < 2; ++j) {
                mutablePos.m_122159_((Vec3i)pos, direction).m_122173_(directions[(i + j) % 2 * 2 + 1]);
                if (!this.connectionPredicate.shouldConnect(blockView, state, pos, mutablePos, face, quadSprite, this.innerSeams)) continue;
                connections |= 1 << (i * 3 + j * 2 + 5) % 6;
            }
        }
        return connections;
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<StandardConnectingCTMProperties> {
        @Override
        public QuadProcessor createProcessor(StandardConnectingCTMProperties properties, TextureAtlasSprite[] sprites) {
            return new VerticalHorizontalQuadProcessor(sprites, BaseProcessingPredicate.fromProperties(properties), properties.getConnectionPredicate(), properties.getInnerSeams());
        }

        @Override
        public int getTextureAmount(StandardConnectingCTMProperties properties) {
            return 7;
        }
    }
}

