/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ConnectingQuadProcessor;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.properties.StandardConnectingCTMProperties;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class VerticalQuadProcessor
extends ConnectingQuadProcessor {
    protected static final int[] SPRITE_INDEX_MAP = new int[]{3, 2, 0, 1};

    public VerticalQuadProcessor(TextureAtlasSprite[] sprites, ProcessingPredicate processingPredicate, ConnectionPredicate connectionPredicate, boolean innerSeams) {
        super(sprites, processingPredicate, connectionPredicate, innerSeams);
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        Direction[] directions = DirectionMaps.getDirections((QuadView)quad);
        BlockPos.MutableBlockPos mutablePos = context.getData(ProcessingDataKeys.MUTABLE_POS_KEY);
        int connections = this.getConnections(directions, mutablePos, blockView, state, pos, quad.lightFace(), sprite);
        TextureAtlasSprite newSprite = this.sprites[SPRITE_INDEX_MAP[connections]];
        return SimpleQuadProcessor.process(quad, sprite, newSprite);
    }

    protected int getConnections(Direction[] directions, BlockPos.MutableBlockPos mutablePos, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Direction face, TextureAtlasSprite quadSprite) {
        int connections = 0;
        for (int i = 0; i < 2; ++i) {
            mutablePos.m_122159_((Vec3i)pos, directions[i * 2 + 1]);
            if (!this.connectionPredicate.shouldConnect(blockView, state, pos, mutablePos, face, quadSprite, this.innerSeams)) continue;
            connections |= 1 << i;
        }
        return connections;
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<StandardConnectingCTMProperties> {
        @Override
        public QuadProcessor createProcessor(StandardConnectingCTMProperties properties, TextureAtlasSprite[] sprites) {
            return new VerticalQuadProcessor(sprites, BaseProcessingPredicate.fromProperties(properties), properties.getConnectionPredicate(), properties.getInnerSeams());
        }

        @Override
        public int getTextureAmount(StandardConnectingCTMProperties properties) {
            return 4;
        }
    }
}

