/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.overlay;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.overlay.OverlayProcessingPredicate;
import me.pepperbell.continuity.client.properties.overlay.OverlayPropertiesSection;
import me.pepperbell.continuity.client.properties.overlay.StandardOverlayCTMProperties;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class StandardOverlayQuadProcessor
extends AbstractQuadProcessor {
    protected Set<ResourceLocation> matchTilesSet;
    protected Predicate<BlockState> matchBlocksPredicate;
    protected Set<ResourceLocation> connectTilesSet;
    protected Predicate<BlockState> connectBlocksPredicate;
    protected ConnectionPredicate connectionPredicate;
    protected int tintIndex;
    protected BlockState tintBlock;
    protected RenderMaterial material;

    public StandardOverlayQuadProcessor(TextureAtlasSprite[] sprites, ProcessingPredicate processingPredicate, Set<ResourceLocation> matchTilesSet, Predicate<BlockState> matchBlocksPredicate, Set<ResourceLocation> connectTilesSet, Predicate<BlockState> connectBlocksPredicate, ConnectionPredicate connectionPredicate, int tintIndex, BlockState tintBlock, BlendMode layer) {
        super(sprites, processingPredicate);
        this.matchTilesSet = matchTilesSet;
        this.matchBlocksPredicate = matchBlocksPredicate;
        this.connectTilesSet = connectTilesSet;
        this.connectBlocksPredicate = connectBlocksPredicate;
        this.connectionPredicate = connectionPredicate;
        this.tintIndex = tintIndex;
        this.tintBlock = tintBlock;
        this.material = RenderUtil.getMaterialFinder().blendMode(0, layer).find();
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        Direction lightFace = quad.lightFace();
        OverlayRenderer renderer = this.getRenderer(blockView, pos, state, lightFace, sprite, DirectionMaps.getMap(lightFace)[0], context);
        if (renderer != null) {
            context.addEmitterConsumer(renderer);
        }
        return QuadProcessor.ProcessingResult.CONTINUE;
    }

    protected boolean appliesOverlay(BlockState other, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Direction face, TextureAtlasSprite quadSprite) {
        if (other.m_60734_().m_49967_()) {
            return false;
        }
        if (!other.m_60838_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_)) {
            return false;
        }
        if (this.connectBlocksPredicate != null && !this.connectBlocksPredicate.test(other)) {
            return false;
        }
        if (this.connectTilesSet != null && !this.connectTilesSet.contains(SpriteCalculator.getSprite(other, face, blockView, pos).m_118413_())) {
            return false;
        }
        return !this.connectionPredicate.shouldConnect(blockView, state, pos, other, face, quadSprite);
    }

    protected boolean hasSameOverlay(BlockState other, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Direction face, TextureAtlasSprite quadSprite) {
        if (this.matchBlocksPredicate != null && !this.matchBlocksPredicate.test(other)) {
            return false;
        }
        return this.matchTilesSet == null || this.matchTilesSet.contains(SpriteCalculator.getSprite(other, face, blockView, pos).m_118413_());
    }

    protected boolean appliesOverlayUnobscured(BlockState state0, Direction direction0, BlockAndTintGetter blockView, BlockPos pos, BlockState state, Direction lightFace, TextureAtlasSprite quadSprite, BlockPos.MutableBlockPos mutablePos) {
        boolean a0 = this.appliesOverlay(state0, blockView, state, pos, lightFace, quadSprite);
        if (a0) {
            mutablePos.m_122159_((Vec3i)pos, direction0).m_122173_(lightFace);
            a0 = !blockView.m_8055_((BlockPos)mutablePos).m_60804_((BlockGetter)blockView, (BlockPos)mutablePos);
        }
        return a0;
    }

    protected boolean hasSameOverlayUnobscured(BlockState state0, Direction direction0, BlockAndTintGetter blockView, BlockPos pos, BlockState state, Direction lightFace, TextureAtlasSprite quadSprite, BlockPos.MutableBlockPos mutablePos) {
        boolean s0 = this.hasSameOverlay(state0, blockView, state, pos, lightFace, quadSprite);
        if (s0) {
            mutablePos.m_122159_((Vec3i)pos, direction0).m_122173_(lightFace);
            s0 = !blockView.m_8055_((BlockPos)mutablePos).m_60804_((BlockGetter)blockView, (BlockPos)mutablePos);
        }
        return s0;
    }

    protected boolean appliesOverlayCorner(Direction direction0, Direction direction1, BlockAndTintGetter blockView, BlockPos pos, BlockState state, Direction lightFace, TextureAtlasSprite quadSprite, BlockPos.MutableBlockPos mutablePos) {
        mutablePos.m_122159_((Vec3i)pos, direction0).m_122173_(direction1);
        boolean corner0 = this.appliesOverlay(blockView.m_8055_((BlockPos)mutablePos), blockView, state, pos, lightFace, quadSprite);
        if (corner0) {
            mutablePos.m_122173_(lightFace);
            corner0 = !blockView.m_8055_((BlockPos)mutablePos).m_60804_((BlockGetter)blockView, (BlockPos)mutablePos);
        }
        return corner0;
    }

    protected OverlayRenderer fromCorner(Direction direction0, Direction direction1, int sprite0, int sprite1, OverlayRenderer renderer, BlockAndTintGetter blockView, BlockPos pos, BlockState state, Direction lightFace, TextureAtlasSprite quadSprite, BlockPos.MutableBlockPos mutablePos) {
        TextureAtlasSprite[] rendererSprites = this.prepareRenderer(renderer, lightFace, blockView, pos);
        mutablePos.m_122159_((Vec3i)pos, direction0).m_122173_(direction1);
        if (this.appliesOverlay(blockView.m_8055_((BlockPos)mutablePos), blockView, state, pos, lightFace, quadSprite)) {
            mutablePos.m_122173_(lightFace);
            if (!blockView.m_8055_((BlockPos)mutablePos).m_60804_((BlockGetter)blockView, (BlockPos)mutablePos)) {
                rendererSprites[1] = this.sprites[sprite1];
            }
        }
        rendererSprites[0] = this.sprites[sprite0];
        return renderer;
    }

    protected OverlayRenderer fromOneSide(BlockState state0, BlockState state1, BlockState state2, Direction direction0, Direction direction1, Direction direction2, int sprite0, int sprite1, int sprite2, OverlayRenderer renderer, BlockAndTintGetter blockView, BlockPos pos, BlockState state, Direction lightFace, TextureAtlasSprite quadSprite, BlockPos.MutableBlockPos mutablePos) {
        boolean s0 = this.hasSameOverlayUnobscured(state0, direction0, blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s1 = this.hasSameOverlayUnobscured(state1, direction1, blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s2 = this.hasSameOverlayUnobscured(state2, direction2, blockView, pos, state, lightFace, quadSprite, mutablePos);
        TextureAtlasSprite[] rendererSprites = this.prepareRenderer(renderer, lightFace, blockView, pos);
        rendererSprites[0] = this.sprites[sprite0];
        if (s0 | s1 && this.appliesOverlayCorner(direction0, direction1, blockView, pos, state, lightFace, quadSprite, mutablePos)) {
            rendererSprites[1] = this.sprites[sprite1];
        }
        if (s1 | s2 && this.appliesOverlayCorner(direction1, direction2, blockView, pos, state, lightFace, quadSprite, mutablePos)) {
            rendererSprites[2] = this.sprites[sprite2];
        }
        return renderer;
    }

    protected static OverlayRenderer getRenderer(ProcessingDataProvider dataProvider) {
        return dataProvider.getData(ProcessingDataKeys.STANDARD_OVERLAY_RENDERER_POOL_KEY).getRenderer();
    }

    protected TextureAtlasSprite[] prepareRenderer(OverlayRenderer renderer, Direction face, BlockAndTintGetter blockView, BlockPos pos) {
        return renderer.prepare(face, RenderUtil.getTintColor(this.tintBlock, blockView, pos, this.tintIndex), this.material);
    }

    protected OverlayRenderer prepareRenderer(OverlayRenderer renderer, Direction face, BlockAndTintGetter blockView, BlockPos pos, int sprite1) {
        TextureAtlasSprite[] rendererSprites = this.prepareRenderer(renderer, face, blockView, pos);
        rendererSprites[0] = this.sprites[sprite1];
        return renderer;
    }

    protected OverlayRenderer prepareRenderer(OverlayRenderer renderer, Direction face, BlockAndTintGetter blockView, BlockPos pos, int sprite1, int sprite2) {
        TextureAtlasSprite[] rendererSprites = this.prepareRenderer(renderer, face, blockView, pos);
        rendererSprites[0] = this.sprites[sprite1];
        rendererSprites[1] = this.sprites[sprite2];
        return renderer;
    }

    protected OverlayRenderer getRenderer(BlockAndTintGetter blockView, BlockPos pos, BlockState state, Direction lightFace, TextureAtlasSprite quadSprite, Direction[] directions, ProcessingDataProvider dataProvider) {
        BlockPos.MutableBlockPos mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS_KEY);
        mutablePos.m_122159_((Vec3i)pos, directions[0]);
        BlockState state0 = blockView.m_8055_((BlockPos)mutablePos);
        boolean left = this.appliesOverlayUnobscured(state0, directions[0], blockView, pos, state, lightFace, quadSprite, mutablePos);
        mutablePos.m_122159_((Vec3i)pos, directions[1]);
        BlockState state1 = blockView.m_8055_((BlockPos)mutablePos);
        boolean down = this.appliesOverlayUnobscured(state1, directions[1], blockView, pos, state, lightFace, quadSprite, mutablePos);
        mutablePos.m_122159_((Vec3i)pos, directions[2]);
        BlockState state2 = blockView.m_8055_((BlockPos)mutablePos);
        boolean right = this.appliesOverlayUnobscured(state2, directions[2], blockView, pos, state, lightFace, quadSprite, mutablePos);
        mutablePos.m_122159_((Vec3i)pos, directions[3]);
        BlockState state3 = blockView.m_8055_((BlockPos)mutablePos);
        boolean up = this.appliesOverlayUnobscured(state3, directions[3], blockView, pos, state, lightFace, quadSprite, mutablePos);
        if (left & down & right & up) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 8);
        }
        if (left & down & right) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 5);
        }
        if (left & down & up) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 6);
        }
        if (left & right & up) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 13);
        }
        if (down & right & up) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 12);
        }
        if (left & right) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 9, 7);
        }
        if (up & down) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 15, 1);
        }
        if (left & down) {
            return this.fromCorner(directions[2], directions[3], 4, 14, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (down & right) {
            return this.fromCorner(directions[0], directions[3], 3, 16, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (right & up) {
            return this.fromCorner(directions[0], directions[1], 10, 2, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (up & left) {
            return this.fromCorner(directions[1], directions[2], 11, 0, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (left) {
            return this.fromOneSide(state1, state2, state3, directions[1], directions[2], directions[3], 9, 0, 14, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (down) {
            return this.fromOneSide(state2, state3, state0, directions[2], directions[3], directions[0], 1, 14, 16, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (right) {
            return this.fromOneSide(state3, state0, state1, directions[3], directions[0], directions[1], 7, 16, 2, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (up) {
            return this.fromOneSide(state0, state1, state2, directions[0], directions[1], directions[2], 15, 2, 0, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        boolean s0 = this.hasSameOverlayUnobscured(state0, directions[0], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s1 = this.hasSameOverlayUnobscured(state1, directions[1], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s2 = this.hasSameOverlayUnobscured(state2, directions[2], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s3 = this.hasSameOverlayUnobscured(state3, directions[3], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean corner0 = false;
        boolean corner1 = false;
        boolean corner2 = false;
        boolean corner3 = false;
        if (s0 | s1) {
            corner0 = this.appliesOverlayCorner(directions[0], directions[1], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (s1 | s2) {
            corner1 = this.appliesOverlayCorner(directions[1], directions[2], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (s2 | s3) {
            corner2 = this.appliesOverlayCorner(directions[2], directions[3], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (s3 | s0) {
            corner3 = this.appliesOverlayCorner(directions[3], directions[0], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (corner0 | corner1 | corner2 | corner3) {
            OverlayRenderer renderer = StandardOverlayQuadProcessor.getRenderer(dataProvider);
            TextureAtlasSprite[] rendererSprites = this.prepareRenderer(renderer, lightFace, blockView, pos);
            if (corner0) {
                rendererSprites[0] = this.sprites[2];
            }
            if (corner1) {
                rendererSprites[1] = this.sprites[0];
            }
            if (corner2) {
                rendererSprites[2] = this.sprites[14];
            }
            if (corner3) {
                rendererSprites[3] = this.sprites[16];
            }
            return renderer;
        }
        return null;
    }

    public static class OverlayRenderer
    implements Consumer<QuadEmitter> {
        protected static final TextureAtlasSprite[] EMPTY_SPRITES = new TextureAtlasSprite[4];
        protected TextureAtlasSprite[] sprites = new TextureAtlasSprite[4];
        protected Direction face;
        protected int color;
        protected RenderMaterial material;

        @Override
        public void accept(QuadEmitter emitter) {
            for (TextureAtlasSprite sprite : this.sprites) {
                if (sprite == null || TextureUtil.isMissingSprite(sprite)) continue;
                QuadUtil.emitOverlayQuad(emitter, this.face, sprite, this.color, this.material);
            }
        }

        public TextureAtlasSprite[] prepare(Direction face, int color, RenderMaterial material) {
            System.arraycopy(EMPTY_SPRITES, 0, this.sprites, 0, EMPTY_SPRITES.length);
            this.face = face;
            this.color = color;
            this.material = material;
            return this.sprites;
        }
    }

    public static class OverlayRendererPool {
        protected final List<OverlayRenderer> list = new ObjectArrayList();
        protected int nextIndex = 0;

        public OverlayRenderer getRenderer() {
            if (this.nextIndex >= this.list.size()) {
                this.list.add(new OverlayRenderer());
            }
            OverlayRenderer renderer = this.list.get(this.nextIndex);
            ++this.nextIndex;
            return renderer;
        }

        public void reset() {
            this.nextIndex = 0;
        }
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<StandardOverlayCTMProperties> {
        @Override
        public QuadProcessor createProcessor(StandardOverlayCTMProperties properties, TextureAtlasSprite[] sprites) {
            OverlayPropertiesSection overlaySection = properties.getOverlayPropertiesSection();
            return new StandardOverlayQuadProcessor(sprites, OverlayProcessingPredicate.fromProperties(properties), properties.getMatchTilesSet(), properties.getMatchBlocksPredicate(), properties.getConnectTilesSet(), properties.getConnectBlocksPredicate(), properties.getConnectionPredicate(), overlaySection.getTintIndex(), overlaySection.getTintBlock(), overlaySection.getLayer());
        }

        @Override
        public int getTextureAmount(StandardOverlayCTMProperties properties) {
            return 17;
        }

        @Override
        public boolean supportsNullSprites(StandardOverlayCTMProperties properties) {
            return false;
        }
    }
}

