/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.simple;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.processor.simple.FixedSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.RandomCTMProperties;
import me.pepperbell.continuity.client.util.MathUtil;
import me.pepperbell.continuity.client.util.RandomIndexProvider;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RandomSpriteProvider
implements SpriteProvider {
    protected TextureAtlasSprite[] sprites;
    protected RandomIndexProvider indexProvider;
    protected int randomLoops;
    protected Symmetry symmetry;
    protected boolean linked;

    public RandomSpriteProvider(TextureAtlasSprite[] sprites, RandomIndexProvider indexProvider, int randomLoops, Symmetry symmetry, boolean linked) {
        this.sprites = sprites;
        this.indexProvider = indexProvider;
        this.randomLoops = randomLoops;
        this.symmetry = symmetry;
        this.linked = linked;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getSprite(QuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, ProcessingDataProvider dataProvider) {
        Direction face = this.symmetry.getActualFace(quad.lightFace());
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (this.linked) {
            Block block = state.m_60734_();
            BlockPos.MutableBlockPos mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS_KEY).m_122190_((Vec3i)pos);
            int i = 0;
            do {
                mutablePos.m_142448_(mutablePos.m_123342_() - 1);
            } while (++i < 3 && block == blockView.m_8055_((BlockPos)mutablePos).m_60734_());
            y = mutablePos.m_123342_() + 1;
        }
        int seed = MathUtil.mix(x, y, z, face.ordinal(), this.randomLoops);
        return this.sprites[this.indexProvider.getRandomIndex(seed)];
    }

    public static class Factory
    implements SpriteProvider.Factory<RandomCTMProperties> {
        @Override
        public SpriteProvider createSpriteProvider(TextureAtlasSprite[] sprites, RandomCTMProperties properties) {
            if (sprites.length == 1) {
                return new FixedSpriteProvider(sprites[0]);
            }
            return new RandomSpriteProvider(sprites, properties.getIndexProviderFactory().createIndexProvider(sprites.length), properties.getRandomLoops(), properties.getSymmetry(), properties.getLinked());
        }

        @Override
        public int getTextureAmount(RandomCTMProperties properties) {
            return properties.getSpriteIds().size();
        }
    }
}

