/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import java.util.Locale;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class ConnectingCTMProperties
extends BaseCTMProperties {
    protected ConnectionPredicate connectionPredicate;

    public ConnectingCTMProperties(Properties properties, ResourceLocation id, String packName, int packPriority, String method) {
        super(properties, id, packName, packPriority, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseConnect();
        this.detectConnect();
        this.validateConnect();
    }

    protected void parseConnect() {
        String connectStr = this.properties.getProperty("connect");
        if (connectStr == null) {
            return;
        }
        try {
            this.connectionPredicate = ConnectionType.valueOf(connectStr.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void detectConnect() {
        if (this.connectionPredicate == null) {
            if (this.affectsBlockStates()) {
                this.connectionPredicate = ConnectionType.BLOCK;
            } else if (this.affectsTextures()) {
                this.connectionPredicate = ConnectionType.TILE;
            }
        }
    }

    protected void validateConnect() {
        if (this.connectionPredicate == null) {
            ContinuityClient.LOGGER.error("No valid connection type provided in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    public ConnectionPredicate getConnectionPredicate() {
        return this.connectionPredicate;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ConnectionType implements ConnectionPredicate
    {
        BLOCK{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState state, BlockPos pos, BlockState toState, Direction face, TextureAtlasSprite quadSprite) {
                return state.m_60734_() == toState.m_60734_();
            }
        }
        ,
        TILE{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState state, BlockPos pos, BlockState toState, Direction face, TextureAtlasSprite quadSprite) {
                if (state == toState) {
                    return true;
                }
                return quadSprite == SpriteCalculator.getSprite(toState, face, blockView, pos);
            }
        }
        ,
        MATERIAL{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState state, BlockPos pos, BlockState toState, Direction face, TextureAtlasSprite quadSprite) {
                return state.m_60767_() == toState.m_60767_();
            }
        }
        ,
        STATE{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState state, BlockPos pos, BlockState toState, Direction face, TextureAtlasSprite quadSprite) {
                return state == toState;
            }
        };

    }
}

