/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import me.pepperbell.continuity.client.mixinterface.SpriteAtlasTextureDataExtension;
import me.pepperbell.continuity.client.model.CTMUnbakedModel;
import me.pepperbell.continuity.client.model.EmissiveUnbakedModel;
import me.pepperbell.continuity.client.resource.CTMLoadingContainer;
import me.pepperbell.continuity.client.resource.CTMPropertiesLoader;
import me.pepperbell.continuity.client.util.VoidSet;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public final class ModelWrappingHandler {
    private static final Map<ModelResourceLocation, BlockState> MODEL_ID_2_STATE_MAP = new Object2ObjectOpenHashMap();
    private static final Map<ModelResourceLocation, List<CTMLoadingContainer<?>>> MODEL_ID_2_CONTAINERS_MAP = new Object2ObjectOpenHashMap();

    public static void onAddBlockStateModel(ModelResourceLocation id, BlockState state) {
        MODEL_ID_2_STATE_MAP.put(id, state);
        List<CTMLoadingContainer<?>> containerList = CTMPropertiesLoader.getAllAffecting(state);
        if (containerList != null) {
            MODEL_ID_2_CONTAINERS_MAP.put(id, containerList);
        }
    }

    public static void wrapCTMModels(Map<ResourceLocation, UnbakedModel> unbakedModels, Map<ResourceLocation, UnbakedModel> modelsToBake) {
        if (CTMPropertiesLoader.isEmpty()) {
            ModelWrappingHandler.clearMaps();
            return;
        }
        Object2ObjectOpenHashMap wrappedModels = new Object2ObjectOpenHashMap();
        Function<ResourceLocation, UnbakedModel> unbakedModelGetter = ModelWrappingHandler.createUnbakedModelGetter(unbakedModels);
        VoidSet voidSet = VoidSet.get();
        CollectionBasedConsumer reusableConsumer = new CollectionBasedConsumer();
        modelsToBake.forEach((arg_0, arg_1) -> ModelWrappingHandler.lambda$wrapCTMModels$0(unbakedModelGetter, voidSet, reusableConsumer, (Map)wrappedModels, arg_0, arg_1));
        ModelWrappingHandler.clearMaps();
        ModelWrappingHandler.injectWrappedModels((Map<ResourceLocation, UnbakedModel>)wrappedModels, unbakedModels, modelsToBake);
    }

    public static void wrapEmissiveModels(Map<ResourceLocation, Pair<TextureAtlas, TextureAtlas.Preparations>> spriteAtlasData, Map<ResourceLocation, UnbakedModel> unbakedModels, Map<ResourceLocation, UnbakedModel> modelsToBake) {
        ObjectOpenHashSet spriteIdsToWrap = new ObjectOpenHashSet();
        spriteAtlasData.forEach((arg_0, arg_1) -> ModelWrappingHandler.lambda$wrapEmissiveModels$1((Set)spriteIdsToWrap, arg_0, arg_1));
        if (spriteIdsToWrap.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap wrappedModels = new Object2ObjectOpenHashMap();
        Function<ResourceLocation, UnbakedModel> unbakedModelGetter = ModelWrappingHandler.createUnbakedModelGetter(unbakedModels);
        VoidSet voidSet = VoidSet.get();
        unbakedModels.forEach((arg_0, arg_1) -> ModelWrappingHandler.lambda$wrapEmissiveModels$2(unbakedModelGetter, voidSet, (Set)spriteIdsToWrap, (Map)wrappedModels, arg_0, arg_1));
        ModelWrappingHandler.injectWrappedModels((Map<ResourceLocation, UnbakedModel>)wrappedModels, unbakedModels, modelsToBake);
    }

    private static Function<ResourceLocation, UnbakedModel> createUnbakedModelGetter(Map<ResourceLocation, UnbakedModel> unbakedModels) {
        return id -> {
            UnbakedModel model = (UnbakedModel)unbakedModels.get(id);
            if (model == null) {
                throw new ModelNotLoadedException();
            }
            return model;
        };
    }

    private static void injectWrappedModels(Map<ResourceLocation, UnbakedModel> wrappedModels, Map<ResourceLocation, UnbakedModel> unbakedModels, Map<ResourceLocation, UnbakedModel> modelsToBake) {
        wrappedModels.forEach((id, wrapped) -> {
            unbakedModels.replace((ResourceLocation)id, (UnbakedModel)wrapped);
            modelsToBake.replace((ResourceLocation)id, (UnbakedModel)wrapped);
        });
    }

    private static boolean isBlockStateModelId(ModelResourceLocation id) {
        return !id.m_119448_().equals("inventory");
    }

    private static void clearMaps() {
        MODEL_ID_2_STATE_MAP.clear();
        MODEL_ID_2_CONTAINERS_MAP.clear();
    }

    private static /* synthetic */ void lambda$wrapEmissiveModels$2(Function unbakedModelGetter, VoidSet voidSet, Set spriteIdsToWrap, Map wrappedModels, ResourceLocation id, UnbakedModel model) {
        Collection dependencies;
        try {
            dependencies = model.m_5500_(unbakedModelGetter, (Set)voidSet);
        }
        catch (ModelNotLoadedException e) {
            return;
        }
        for (Material spriteId : dependencies) {
            if (!spriteIdsToWrap.contains(spriteId)) continue;
            wrappedModels.put(id, new EmissiveUnbakedModel(model));
            return;
        }
    }

    private static /* synthetic */ void lambda$wrapEmissiveModels$1(Set spriteIdsToWrap, ResourceLocation atlasId, Pair pair) {
        TextureAtlas.Preparations data = (TextureAtlas.Preparations)pair.getSecond();
        Map<ResourceLocation, ResourceLocation> emissiveIdMap = ((SpriteAtlasTextureDataExtension)data).continuity$getEmissiveIdMap();
        if (emissiveIdMap != null) {
            for (ResourceLocation id : emissiveIdMap.keySet()) {
                spriteIdsToWrap.add(new Material(atlasId, id));
            }
        }
    }

    private static /* synthetic */ void lambda$wrapCTMModels$0(Function unbakedModelGetter, VoidSet voidSet, CollectionBasedConsumer reusableConsumer, Map wrappedModels, ResourceLocation id, UnbakedModel model) {
        ModelResourceLocation modelId;
        if (id instanceof ModelResourceLocation && ModelWrappingHandler.isBlockStateModelId(modelId = (ModelResourceLocation)id)) {
            Collection dependencies;
            try {
                dependencies = model.m_5500_(unbakedModelGetter, (Set)voidSet);
            }
            catch (ModelNotLoadedException e) {
                return;
            }
            List<CTMLoadingContainer<?>> containerList = MODEL_ID_2_CONTAINERS_MAP.get(modelId);
            if (containerList == null) {
                containerList = CTMPropertiesLoader.getAllAffecting(dependencies);
                if (containerList == null) {
                    return;
                }
            } else {
                reusableConsumer.setCollection(containerList);
                CTMPropertiesLoader.consumeAllAffecting(dependencies, reusableConsumer);
            }
            containerList.sort(Collections.reverseOrder());
            Set multipassContainerSet = null;
            int amount = containerList.size();
            for (int i = 0; i < amount; ++i) {
                CTMLoadingContainer<?> container = containerList.get(i);
                Set<CTMLoadingContainer<?>> dependents = container.getRecursiveMultipassDependents();
                if (dependents == null) continue;
                if (multipassContainerSet == null) {
                    multipassContainerSet = new ObjectOpenHashSet();
                }
                multipassContainerSet.addAll(dependents);
            }
            List multipassContainerList = null;
            if (multipassContainerSet != null) {
                BlockState state = MODEL_ID_2_STATE_MAP.get(modelId);
                for (CTMLoadingContainer container : multipassContainerSet) {
                    if (container.getProperties().affectsBlockStates() && !container.getProperties().affectsBlockState(state)) continue;
                    if (multipassContainerList == null) {
                        multipassContainerList = new ObjectArrayList();
                    }
                    multipassContainerList.add(container);
                }
                if (multipassContainerList != null) {
                    multipassContainerList.sort(Collections.reverseOrder());
                }
            }
            wrappedModels.put(modelId, new CTMUnbakedModel(model, containerList, multipassContainerList));
        }
    }

    private static class CollectionBasedConsumer<T>
    implements Consumer<T> {
        private Collection<T> collection;

        private CollectionBasedConsumer() {
        }

        @Override
        public void accept(T t) {
            this.collection.add(t);
        }

        public void setCollection(Collection<T> collection) {
            this.collection = collection;
        }
    }

    private static class ModelNotLoadedException
    extends RuntimeException {
        private ModelNotLoadedException() {
        }
    }
}

