/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import link.infra.indium.renderer.RenderMaterialImpl;
import me.pepperbell.continuity.client.ContinuityClient;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.ApiStatus;

public final class RenderUtil {
    private static final BlockColors BLOCK_COLORS = Minecraft.m_91087_().m_91298_();
    private static final ModelManager MODEL_MANAGER = Minecraft.m_91087_().m_91304_();
    private static final ThreadLocal<MaterialFinder> MATERIAL_FINDER = ThreadLocal.withInitial(() -> RendererAccess.INSTANCE.getRenderer().materialFinder());
    private static final BlendModeGetter BLEND_MODE_GETTER = RenderUtil.createBlendModeGetter();
    private static SpriteFinder blockAtlasSpriteFinder;

    private static BlendModeGetter createBlendModeGetter() {
        if (ModList.get().isLoaded("reforgium") && ModList.get().isLoaded("rubidium")) {
            return quad -> ((RenderMaterialImpl)quad.material()).blendMode(0);
        }
        if (RendererAccess.INSTANCE.getRenderer() instanceof IndigoRenderer) {
            return quad -> ((net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl)quad.material()).blendMode(0);
        }
        return quad -> BlendMode.DEFAULT;
    }

    public static int getTintColor(BlockState state, BlockAndTintGetter blockView, BlockPos pos, int tintIndex) {
        if (state == null || tintIndex == -1) {
            return -1;
        }
        return 0xFF000000 | BLOCK_COLORS.m_92577_(state, blockView, pos, tintIndex);
    }

    public static MaterialFinder getMaterialFinder() {
        return MATERIAL_FINDER.get().clear();
    }

    public static BlendMode getBlendMode(QuadView quad) {
        return BLEND_MODE_GETTER.getBlendMode(quad);
    }

    public static SpriteFinder getSpriteFinder() {
        return blockAtlasSpriteFinder;
    }

    private static interface BlendModeGetter {
        public BlendMode getBlendMode(QuadView var1);
    }

    public static class ReloadListener
    implements ResourceManagerReloadListener {
        public static final ResourceLocation ID = ContinuityClient.asId("render_util");
        private static final ReloadListener INSTANCE = new ReloadListener();

        @ApiStatus.Internal
        public static void init() {
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)INSTANCE);
        }

        @SubscribeEvent
        public void addListener(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)this);
        }

        public void m_6213_(ResourceManager manager) {
            blockAtlasSpriteFinder = SpriteFinder.get((TextureAtlas)MODEL_MANAGER.m_119428_(TextureAtlas.f_118259_));
        }
    }
}

