/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util.biome;

import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.pepperbell.continuity.client.util.biome.BiomeView;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class BiomeRetriever {
    private static final Provider PROVIDER = BiomeRetriever.createProvider();

    private static Provider createProvider() {
        ClassLoader classLoader = BiomeRetriever.class.getClassLoader();
        if (ModList.get().isLoaded("rubidium")) {
            try {
                Class<?> worldSliceClass = Class.forName("me.jellysquid.mods.sodium.client.world.WorldSlice", false, classLoader);
                worldSliceClass.getMethod("getBiomeAccess", new Class[0]);
                return BiomeRetriever::getBiomeByWorldSlice;
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                return BiomeRetriever::getBiomeByWorldView;
            }
        }
        if (ArrayUtils.contains((Object[])RenderChunkRegion.class.getInterfaces(), BiomeView.class)) {
            return BiomeRetriever::getBiomeByExtension;
        }
        return BiomeRetriever::getBiomeByWorldView;
    }

    @Nullable
    public static Biome getBiome(BlockAndTintGetter blockView, BlockPos pos) {
        return PROVIDER.getBiome(blockView, pos);
    }

    @ApiStatus.Internal
    public static void init() {
    }

    private static Biome getBiomeByWorldView(BlockAndTintGetter blockView, BlockPos pos) {
        if (blockView instanceof LevelReader) {
            LevelReader worldView = (LevelReader)blockView;
            return (Biome)worldView.m_204166_(pos).m_203334_();
        }
        return null;
    }

    private static Biome getBiomeByExtension(BlockAndTintGetter blockView, BlockPos pos) {
        if (blockView instanceof BiomeView) {
            BiomeView biomeView = (BiomeView)blockView;
            return (Biome)biomeView.continuity$getBiome(pos).m_203334_();
        }
        return BiomeRetriever.getBiomeByWorldView(blockView, pos);
    }

    private static Biome getBiomeByWorldSlice(BlockAndTintGetter blockView, BlockPos pos) {
        if (blockView instanceof WorldSlice) {
            WorldSlice worldSlice = (WorldSlice)blockView;
            return (Biome)worldSlice.getBiomeAccess().m_204214_(pos).m_203334_();
        }
        return BiomeRetriever.getBiomeByWorldView(blockView, pos);
    }

    private static interface Provider {
        public Biome getBiome(BlockAndTintGetter var1, BlockPos var2);
    }
}

