/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.copycatsplus.copycats.utility.BlockFaceUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.ITransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface ICopycatBlock
extends IWrenchable,
IStateType,
ITransformableBlock {
    @Nullable
    default public ICopycatBlockEntity getCopycatBlockEntity(BlockGetter worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity == null) {
            return null;
        }
        if (!(blockEntity instanceof ICopycatBlockEntity)) {
            return null;
        }
        ICopycatBlockEntity copycatBE = (ICopycatBlockEntity)blockEntity;
        return copycatBE;
    }

    default public boolean canToggleCT(BlockState state, BlockAndTintGetter level, BlockPos pos) {
        return true;
    }

    default public boolean isCTEnabled(BlockState state, BlockAndTintGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof ICopycatBlockEntity)) {
            return true;
        }
        ICopycatBlockEntity fbe = (ICopycatBlockEntity)be;
        if (!this.canToggleCT(state, level, pos)) {
            return true;
        }
        return fbe.isCTEnabled();
    }

    default public InteractionResult toggleCT(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_6144_() && pPlayer.m_21120_(pHand).equals(ItemStack.f_41583_)) {
            if (!this.canToggleCT(pState, (BlockAndTintGetter)pLevel, pPos)) {
                return InteractionResult.PASS;
            }
            BlockEntity be = pLevel.m_7702_(pPos);
            if (!(be instanceof ICopycatBlockEntity)) {
                return InteractionResult.PASS;
            }
            ICopycatBlockEntity fbe = (ICopycatBlockEntity)be;
            if (!this.canToggleCT(pState, (BlockAndTintGetter)pLevel, pPos)) {
                return InteractionResult.PASS;
            }
            fbe.setCTEnabled(!fbe.isCTEnabled());
            BlockEntityUtils.redraw((BlockEntity)fbe);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        this.onWrenched(state, context);
        return super.onSneakWrenched(state, context);
    }

    default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        ICopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)context.m_43725_(), context.m_8083_());
        if (copycatBE == null) {
            return InteractionResult.PASS;
        }
        ItemStack consumedItem = copycatBE.getConsumedItem();
        if (!copycatBE.hasCustomMaterial()) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (!player.m_7500_()) {
            player.m_150109_().m_150079_(consumedItem);
        }
        context.m_43725_().m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)ICopycatBlock.getMaterial((BlockGetter)context.m_43725_(), context.m_8083_())));
        copycatBE.setMaterial(AllBlocks.COPYCAT_BASE.getDefaultState());
        copycatBE.setConsumedItem(ItemStack.f_41583_);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    default public BlockState getAcceptedBlockState(Level pLevel, BlockPos pPos, ItemStack item, Direction face) {
        Item item2 = item.m_41720_();
        if (!(item2 instanceof BlockItem)) {
            return null;
        }
        BlockItem bi = (BlockItem)item2;
        Block block = bi.m_40614_();
        if (block instanceof ICopycatBlock) {
            return null;
        }
        BlockState appliedState = block.m_49966_();
        boolean hardCodedAllow = this.isAcceptedRegardless(appliedState);
        if (!AllTags.AllBlockTags.COPYCAT_ALLOW.matches(block) && !hardCodedAllow) {
            if (AllTags.AllBlockTags.COPYCAT_DENY.matches(block)) {
                return null;
            }
            if (block instanceof EntityBlock) {
                return null;
            }
            if (block instanceof StairBlock) {
                return null;
            }
            if (pLevel != null) {
                VoxelShape shape = appliedState.m_60808_((BlockGetter)pLevel, pPos);
                if (shape.m_83281_() || !shape.m_83215_().equals((Object)Shapes.m_83144_().m_83215_())) {
                    return null;
                }
                VoxelShape collisionShape = appliedState.m_60812_((BlockGetter)pLevel, pPos);
                if (collisionShape.m_83281_()) {
                    return null;
                }
            }
        }
        if (face != null) {
            Direction.Axis axis = face.m_122434_();
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61374_) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61365_)) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61364_) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)axis);
            }
        }
        return appliedState;
    }

    default public boolean isAcceptedRegardless(BlockState material) {
        return false;
    }

    default public BlockState prepareMaterial(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, BlockState material) {
        return material;
    }

    default public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        InteractionResult result;
        if (player.m_21120_(hand).m_204117_(AllTags.AllItemTags.WRENCH.tag) && (result = ((WrenchItem)AllItems.WRENCH.get()).m_6225_(new UseOnContext(player, hand, ray))).m_19077_()) {
            return result;
        }
        result = this.toggleCT(state, world, pos, player, hand, ray);
        if (result.m_19077_()) {
            return result;
        }
        if (player == null || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        Direction face = ray.m_82434_();
        ItemStack itemInHand = player.m_21120_(hand);
        BlockState materialIn = this.getAcceptedBlockState(world, pos, itemInHand, face);
        if (materialIn != null) {
            materialIn = this.prepareMaterial(world, pos, state, player, hand, ray, materialIn);
        }
        if (materialIn == null) {
            return InteractionResult.PASS;
        }
        BlockState material = materialIn;
        ICopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)world, pos);
        if (copycatBE == null) {
            return InteractionResult.PASS;
        }
        if (copycatBE.getMaterial().m_60713_(material.m_60734_())) {
            if (!copycatBE.cycleMaterial()) {
                return InteractionResult.PASS;
            }
            copycatBE.m_58904_().m_5594_(null, copycatBE.m_58899_(), SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 0.95f);
            return InteractionResult.SUCCESS;
        }
        if (copycatBE.hasCustomMaterial()) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        copycatBE.setMaterial(material);
        copycatBE.setConsumedItem(itemInHand);
        copycatBE.m_58904_().m_5594_(null, copycatBE.m_58899_(), material.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 0.75f);
        if (player.m_7500_()) {
            return InteractionResult.SUCCESS;
        }
        itemInHand.m_41774_(1);
        if (itemInHand.m_41619_()) {
            player.m_21008_(hand, ItemStack.f_41583_);
        }
        return InteractionResult.SUCCESS;
    }

    default public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Player player;
        if (placer == null) {
            return;
        }
        ItemStack offhandItem = placer.m_21120_(InteractionHand.OFF_HAND);
        BlockState appliedState = this.getAcceptedBlockState(worldIn, pos, offhandItem, Direction.m_122382_((Entity)placer)[0]);
        if (appliedState == null) {
            return;
        }
        ICopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)worldIn, pos);
        if (copycatBE == null) {
            return;
        }
        if (copycatBE.hasCustomMaterial()) {
            return;
        }
        copycatBE.setMaterial(appliedState);
        copycatBE.setConsumedItem(offhandItem);
        if (placer instanceof Player && (player = (Player)placer).m_7500_()) {
            return;
        }
        offhandItem.m_41774_(1);
        if (offhandItem.m_41619_()) {
            placer.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        }
    }

    default public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving, OnRemoveHandler handler) {
        ICopycatBlockEntity copycatBE;
        if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        if (!isMoving && (copycatBE = this.getCopycatBlockEntity((BlockGetter)world, pos)) != null) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)copycatBE.getConsumedItem());
        }
        handler.handle(state, world, pos, newState, isMoving);
        world.m_46747_(pos);
    }

    default public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        ICopycatBlockEntity copycatBE;
        if (player.m_7500_() && (copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos)) != null) {
            copycatBE.setConsumedItem(ItemStack.f_41583_);
        }
    }

    public static BlockState getAppearance(ICopycatBlock block, BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        if (block.isIgnoredConnectivitySide(level, state, side, pos, queryPos)) {
            return state;
        }
        BlockState material = ICopycatBlock.getMaterial((BlockGetter)level, pos);
        return material.m_60713_(Blocks.f_50016_) ? AllBlocks.COPYCAT_BASE.getDefaultState() : material;
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        BlockEntity blockEntity = reader.m_7702_(targetPos);
        if (blockEntity instanceof ICopycatBlockEntity) {
            ICopycatBlockEntity cbe = (ICopycatBlockEntity)blockEntity;
            return cbe.getMaterial();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static BlockState getMaterialCrossThread(BlockGetter reader, BlockPos targetPos) {
        BlockEntity blockEntity = BlockEntityUtils.getBlockEntityCrossThread(reader, targetPos);
        if (blockEntity instanceof ICopycatBlockEntity) {
            ICopycatBlockEntity cbe = (ICopycatBlockEntity)blockEntity;
            return cbe.getMaterial();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static ItemRequirement getRequiredItemsForLayer(BlockState state, IntegerProperty property) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, new ItemStack((ItemLike)state.m_60734_().m_5456_(), ((Integer)state.m_61143_((Property)property)).intValue()));
    }

    @NotNull
    default public BlockState m_6843_(@NotNull BlockState pState, Rotation pRot) {
        return this.transform(pState, new StructureTransform(BlockPos.f_121853_, Direction.Axis.Y, pRot, Mirror.NONE));
    }

    @NotNull
    default public BlockState m_6943_(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        return this.transform(pState, new StructureTransform(BlockPos.f_121853_, null, Rotation.NONE, pMirror));
    }

    default public BlockState transform(BlockState state, StructureTransform transform) {
        boolean halfTurn;
        Direction.Axis rotationAxis = transform.rotationAxis;
        Rotation rotation = transform.rotation;
        Mirror mirror = transform.mirror;
        Block block = state.m_60734_();
        if (mirror != null) {
            state = state.m_60715_(mirror);
        }
        if (rotationAxis == Direction.Axis.Y) {
            if (block instanceof BellBlock) {
                if (state.m_61143_((Property)BlockStateProperties.f_61377_) == BellAttachType.DOUBLE_WALL) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61377_, (Comparable)BellAttachType.SINGLE_WALL);
                }
                return (BlockState)state.m_61124_((Property)BellBlock.f_49679_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BellBlock.f_49679_)));
            }
            return state.m_60717_(rotation);
        }
        if (block instanceof FaceAttachedHorizontalDirectionalBlock) {
            Direction forcedAxis;
            DirectionProperty facingProperty = FaceAttachedHorizontalDirectionalBlock.f_54117_;
            EnumProperty faceProperty = FaceAttachedHorizontalDirectionalBlock.f_53179_;
            Direction stateFacing = (Direction)state.m_61143_((Property)facingProperty);
            AttachFace stateFace = (AttachFace)state.m_61143_((Property)faceProperty);
            boolean z = rotationAxis == Direction.Axis.Z;
            Direction direction = forcedAxis = z ? Direction.WEST : Direction.SOUTH;
            if (stateFacing.m_122434_() == rotationAxis && stateFace == AttachFace.WALL) {
                return state;
            }
            for (int i = 0; i < rotation.ordinal(); ++i) {
                stateFace = (AttachFace)state.m_61143_((Property)faceProperty);
                stateFacing = (Direction)state.m_61143_((Property)facingProperty);
                boolean b = state.m_61143_((Property)faceProperty) == AttachFace.CEILING;
                state = (BlockState)state.m_61124_((Property)facingProperty, (Comparable)(b ? forcedAxis : forcedAxis.m_122424_()));
                state = stateFace != AttachFace.WALL ? (BlockState)state.m_61124_((Property)faceProperty, (Comparable)AttachFace.WALL) : (stateFacing.m_122421_() == (z ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE) ? (BlockState)state.m_61124_((Property)faceProperty, (Comparable)AttachFace.FLOOR) : (BlockState)state.m_61124_((Property)faceProperty, (Comparable)AttachFace.CEILING));
            }
            return state;
        }
        boolean bl = halfTurn = rotation == Rotation.CLOCKWISE_180;
        if (block instanceof StairBlock) {
            if (((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122434_() != rotationAxis) {
                for (int i = 0; i < rotation.ordinal(); ++i) {
                    Direction direction = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
                    Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
                    state = direction.m_122421_() == Direction.AxisDirection.POSITIVE ^ half == Half.BOTTOM ^ direction.m_122434_() == Direction.Axis.Z ? (BlockState)state.m_61122_((Property)StairBlock.f_56842_) : (BlockState)state.m_61124_((Property)StairBlock.f_56841_, (Comparable)direction.m_122424_());
                }
            } else if (halfTurn) {
                state = (BlockState)state.m_61122_((Property)StairBlock.f_56842_);
            }
            return state;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)transform.rotateFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        } else if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)transform.rotateAxis((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)));
        } else if (halfTurn) {
            Direction stateFacing;
            if (state.m_61138_((Property)BlockStateProperties.f_61374_) && (stateFacing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() == rotationAxis) {
                return state;
            }
            if ((state = state.m_60717_(rotation)).m_61138_((Property)SlabBlock.f_56353_) && state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE) {
                state = (BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)(state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM));
            }
        }
        return state;
    }

    default public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        return false;
    }

    default public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return true;
    }

    default public boolean canOcclude(BlockGetter level, BlockState state, BlockPos pos) {
        BlockState material = ICopycatBlock.getMaterial(level, pos);
        if (AllBlocks.COPYCAT_BASE.has(material)) {
            return false;
        }
        return material.m_60815_();
    }

    default public Optional<Boolean> shapeCanOccludeNeighbor(BlockGetter level, BlockPos pos, BlockState state, BlockPos neighborPos, Direction dir) {
        return Optional.empty();
    }

    public static boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        BlockState neighborMaterial;
        BlockPos toPos = pos.m_121945_(dir);
        BlockState material = state.m_60734_() instanceof ICopycatBlock ? ICopycatBlock.getMaterial(level, pos) : state;
        BlockState blockState = neighborMaterial = neighborState.m_60734_() instanceof ICopycatBlock ? ICopycatBlock.getMaterial(level, toPos) : neighborState;
        if (material.m_60719_(neighborMaterial, dir.m_122424_())) {
            return BlockFaceUtils.canOcclude(level, neighborState, toPos, state, pos, dir.m_122424_());
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor wrappedColor() {
        return new WrappedBlockColor();
    }

    @FunctionalInterface
    public static interface OnRemoveHandler {
        public void handle(BlockState var1, Level var2, BlockPos var3, BlockState var4, boolean var5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBlockColor
    implements BlockColor {
        public int m_92566_(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
            if (pLevel == null || pPos == null) {
                return GrassColor.m_46415_((double)0.5, (double)1.0);
            }
            return Minecraft.m_91087_().m_91298_().m_92577_(ICopycatBlock.getMaterial((BlockGetter)pLevel, pPos), pLevel, pPos, pTintIndex);
        }
    }
}

