/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.compat.Mods;
import com.copycatsplus.copycats.mixin.foundation.copycat.ChunkAccessAccessor;
import com.copycatsplus.copycats.utility.ChatUtils;
import com.copycatsplus.copycats.utility.forge.BlockEntityUtilsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockEntityUtils {
    public static void redraw(BlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level != null) {
            if (level.m_5776_()) {
                BlockEntityUtils.requestModelDataUpdate(blockEntity);
            } else {
                blockEntity.m_6596_();
            }
            BlockState state = blockEntity.m_58900_();
            level.m_7260_(blockEntity.m_58899_(), state, state, 16);
            BlockEntityUtils.updateLight(blockEntity);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void requestModelDataUpdate(BlockEntity blockEntity) {
        BlockEntityUtilsImpl.requestModelDataUpdate(blockEntity);
    }

    @Nullable
    public static BlockEntity getBlockEntityCrossThread(BlockGetter reader, BlockPos targetPos) {
        if (Mods.STARLIGHT.getLoaded()) {
            ChatUtils.sendWarningOnce("starlight_deadlock", "Starlight is incompatible with Copycats+ due to a deadlock during lighting computation. Please remove Starlight to restore light emission in copycats.");
            return null;
        }
        try {
            if (reader instanceof Level) {
                Level level = (Level)reader;
                ChunkAccessAccessor chunkAccess = (ChunkAccessAccessor)level.m_46865_(targetPos);
                BlockEntity be = chunkAccess.getBlockEntities().get(targetPos);
                if (be.m_58901_()) {
                    return null;
                }
                return be;
            }
            return null;
        }
        catch (Exception $) {
            return null;
        }
    }

    private static void updateLight(BlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level != null) {
            BlockPos pos = blockEntity.m_58899_();
            ProfilerFiller profilerFiller = level.m_46473_();
            profilerFiller.m_6182_("queueCheckLight");
            level.m_7726_().m_7827_().m_7174_(pos);
            profilerFiller.m_7238_();
            level.m_46865_(pos).m_8092_(true);
        }
    }
}

