/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.industrial_gear;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mangomilk.design_decor.registry.CDDBlocks;
import com.mangomilk.design_decor.registry.CDDPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class IndustrialGearRenderer
extends KineticBlockEntityRenderer<BracketedKineticBlockEntity> {
    public IndustrialGearRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(BracketedKineticBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        if (!CDDBlocks.LARGE_COGWHEEL.has(be.m_58900_())) {
            super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
            return;
        }
        Direction.Axis axis = IndustrialGearRenderer.getRotationAxisOf((KineticBlockEntity)be);
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        IndustrialGearRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)CachedBufferer.partialFacingVertical((PartialModel)CDDPartialModels.SHAFTLESS_LARGE_COGWHEEL, (BlockState)be.m_58900_(), (Direction)facing), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
        float angle = IndustrialGearRenderer.getAngleForLargeCogShaft((SimpleKineticBlockEntity)be, axis);
        SuperByteBuffer shaft = CachedBufferer.partialFacingVertical((PartialModel)CDDPartialModels.EMPTY, (BlockState)be.m_58900_(), (Direction)facing);
        IndustrialGearRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)light);
        shaft.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    public static float getAngleForLargeCogShaft(SimpleKineticBlockEntity be, Direction.Axis axis) {
        BlockPos pos = be.m_58899_();
        float offset = IndustrialGearRenderer.getShaftAngleOffset(axis, pos);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float angle = (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static float getShaftAngleOffset(Direction.Axis axis, BlockPos pos) {
        float offset = 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.m_123341_()) + (axis == Direction.Axis.Y ? 0 : pos.m_123342_()) + (axis == Direction.Axis.Z ? 0 : pos.m_123343_())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }
}

