/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.doltcompat.core.compat.dispensers;

import com.dolthhaven.doltcompat.core.DoltCompatConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DoltCompatSheepDyeDispensers {
    private static final HashMap<DyeColor, DispenseItemBehavior> DYE_MAP = new HashMap();

    public static void registerSheepDispensers() {
        if (((Boolean)DoltCompatConfig.Common.COMMON.DoDispenseSheepDye.get()).booleanValue()) {
            for (DyeColor dye : DyeColor.values()) {
                DispenserBlock.m_52672_((ItemLike)((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", dye.m_41065_() + "_dye")))), (DispenseItemBehavior)DoltCompatSheepDyeDispensers.dispenserByDye(dye));
            }
        }
    }

    private static DispenseItemBehavior dispenserByDye(final DyeColor dye) {
        return new OptionalDispenseItemBehavior(){

            @NotNull
            protected ItemStack m_7498_(@NotNull BlockSource source, @NotNull ItemStack stack) {
                Iterator iterator;
                BlockPos affectPos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel level = source.m_7727_();
                List sheeps = level.m_6443_(Sheep.class, new AABB(affectPos), sheepie -> !sheepie.m_29874_().equals((Object)dye));
                if (!sheeps.isEmpty() && (iterator = sheeps.iterator()).hasNext()) {
                    Sheep sheep = (Sheep)iterator.next();
                    this.m_123573_(true);
                    stack.m_41774_(1);
                    sheep.m_29855_(dye);
                    return stack;
                }
                return DYE_MAP.get(dye).m_6115_(source, stack);
            }
        };
    }

    static {
        for (DyeColor dye : DyeColor.values()) {
            DYE_MAP.put(dye, (DispenseItemBehavior)DispenserBlock.f_52661_.get(ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", dye.m_41065_() + "_dye"))));
        }
    }
}

