/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.gen;

import com.barion.dungeons_enhanced.DEUtil;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;

public class DETerrainAnalyzer {
    public static Settings defaultCheckSettings = new Settings(1, 3, 3);
    protected static ChunkGenerator chunkGenerator;
    protected static LevelHeightAccessor heightAccessor;
    protected static RandomState randomState;

    public static boolean isFlatEnough(ChunkPos chunkPos, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState) {
        return DETerrainAnalyzer.isFlatEnough(chunkPos, chunkGenerator, defaultCheckSettings, heightAccessor, randomState);
    }

    public static boolean isFlatEnough(ChunkPos chunkPos, ChunkGenerator chunkGenerator, Settings settings, LevelHeightAccessor heightAccessor, RandomState randomState) {
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        DETerrainAnalyzer.randomState = randomState;
        return DETerrainAnalyzer.isFlatEnough(DETerrainAnalyzer.ChunkPosToBlockPos(chunkPos, Heightmap.Types.WORLD_SURFACE_WG), chunkGenerator, settings, heightAccessor, randomState);
    }

    public static boolean isFlatEnough(BlockPos pos, ChunkGenerator chunkGenerator, Settings settings, LevelHeightAccessor heightAccessor, RandomState randomState) {
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        DETerrainAnalyzer.randomState = randomState;
        if (DETerrainAnalyzer.getBlockAt(pos.m_7495_()).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        int columSpreading = settings.columSpreading();
        if (DETerrainAnalyzer.isColumBlocked(pos.m_122030_(columSpreading), settings)) {
            return false;
        }
        if (DETerrainAnalyzer.isColumBlocked(pos.m_122025_(columSpreading), settings)) {
            return false;
        }
        if (DETerrainAnalyzer.isColumBlocked(pos.m_122020_(columSpreading), settings)) {
            return false;
        }
        return !DETerrainAnalyzer.isColumBlocked(pos.m_122013_(columSpreading), settings);
    }

    public static boolean isUnderwater(ChunkPos chunkPos, ChunkGenerator chunkGenerator, int depth, LevelHeightAccessor heightAccessor, RandomState randomState) {
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        DETerrainAnalyzer.randomState = randomState;
        return DETerrainAnalyzer.getBlockAt(DETerrainAnalyzer.ChunkPosToBlockPos(chunkPos, Heightmap.Types.OCEAN_FLOOR_WG).m_6630_(depth)).m_60713_(Blocks.f_49990_);
    }

    public static boolean isGroundLevelAbove(ChunkPos chunkPos, ChunkGenerator chunkGenerator, int height, LevelHeightAccessor heightAccessor, RandomState randomState) {
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        DETerrainAnalyzer.randomState = randomState;
        return DETerrainAnalyzer.getSurfaceLevelAt(chunkPos, Heightmap.Types.WORLD_SURFACE_WG) > height;
    }

    public static boolean isGroundLevelBelow(ChunkPos chunkPos, ChunkGenerator chunkGenerator, int height, LevelHeightAccessor heightAccessor, RandomState randomState) {
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        DETerrainAnalyzer.randomState = randomState;
        return DETerrainAnalyzer.getSurfaceLevelAt(chunkPos, Heightmap.Types.WORLD_SURFACE_WG) < height;
    }

    public static boolean areNearbyBiomesValid(BiomeSource biomeSource, ChunkPos chunkPos, ChunkGenerator generator, int radius, Predicate<Holder<Biome>> validBiome, RandomState randomState) {
        chunkGenerator = generator;
        for (Holder biome : biomeSource.m_183399_(chunkPos.m_151390_(), generator.m_6337_(), chunkPos.m_151393_(), radius, randomState.m_224579_())) {
            if (validBiome.test((Holder<Biome>)biome)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isColumBlocked(BlockPos pos, Settings settings) {
        if (!DETerrainAnalyzer.isDownwardsFree(pos, settings.stepSize(), settings.steps())) {
            return DETerrainAnalyzer.isUpwardsBlocked(pos, settings.stepSize(), settings.steps());
        }
        return true;
    }

    protected static boolean isUpwardsBlocked(BlockPos pos, int stepSize, int steps) {
        for (int i = 1; i <= steps; ++i) {
            if (DETerrainAnalyzer.getBlockAt(pos.m_6630_(i * stepSize)).m_60795_()) continue;
            return true;
        }
        return false;
    }

    protected static boolean isDownwardsFree(BlockPos pos, int stepSize, int steps) {
        for (int i = 1; i <= steps; ++i) {
            if (!DETerrainAnalyzer.getBlockAt(pos.m_6625_(i * stepSize)).m_60795_()) continue;
            return true;
        }
        return false;
    }

    protected static BlockState getBlockAt(int x, int y, int z) {
        return chunkGenerator.m_214184_(x, z, heightAccessor, randomState).m_183556_(y);
    }

    protected static BlockState getBlockAt(BlockPos pos) {
        return chunkGenerator.m_214184_(pos.m_123341_(), pos.m_123343_(), heightAccessor, randomState).m_183556_(pos.m_123342_());
    }

    protected static BlockPos ChunkPosToBlockPos(ChunkPos chunkPos, Heightmap.Types heightmapType) {
        return DEUtil.ChunkPosToBlockPosFromHeightMap(chunkPos, chunkGenerator, heightmapType, heightAccessor, randomState);
    }

    protected static int getSurfaceLevelAt(ChunkPos pos, Heightmap.Types heightmapType) {
        return DETerrainAnalyzer.ChunkPosToBlockPos(pos, heightmapType).m_123342_();
    }

    protected static int getSurfaceLevelAt(BlockPos pos, Heightmap.Types heightmapType) {
        return chunkGenerator.m_214096_(pos.m_123341_(), pos.m_123343_(), heightmapType, heightAccessor, randomState);
    }

    public record Settings(int steps, int stepSize, int columSpreading) {
    }
}

