/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.utils.EMFUtils;

public class EMFConfig {
    private static EMFConfig EMFConfigData;
    public boolean printModelCreationInfoToLog = false;
    public boolean printAllMaths = false;
    public boolean renderCustomModelsGreen = false;
    public VanillaModelRenderMode vanillaModelRenderMode = VanillaModelRenderMode.Off;
    public final MathFunctionChoice mathFunctionChoice = MathFunctionChoice.JavaMath;
    public boolean tryForceEmfModels = true;
    public UnknownModelPrintMode printUnknownModelsMode = UnknownModelPrintMode.NONE;
    public boolean attemptPhysicsModPatch_1 = false;
    public boolean attemptToCopyVanillaModelIntoMissingModelPart = false;
    public TextureOverrideMode textureOverrideMode = TextureOverrideMode.USE_IRIS_QUIRK_AND_DEFER_TO_EMF_CODE_OTHERWISE;

    public static EMFConfig getConfig() {
        if (EMFConfigData == null) {
            EMFConfig.loadConfig();
        }
        return EMFConfigData;
    }

    public static void setConfig(EMFConfig newConfig) {
        if (newConfig != null) {
            EMFConfigData = newConfig;
        }
    }

    public static void EMF_saveConfig() {
        File config = new File(EMFVersionDifferenceManager.getConfigDirectory().toFile(), "entity_model_features.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.getParentFile().exists()) {
            config.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(config);
            fileWriter.write(gson.toJson((Object)EMFConfigData));
            fileWriter.close();
        }
        catch (IOException e) {
            EMFUtils.EMFModMessage("Config could not be saved", false);
        }
    }

    public static void loadConfig() {
        try {
            File config = new File(EMFVersionDifferenceManager.getConfigDirectory().toFile(), "entity_model_features.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (config.exists()) {
                try {
                    FileReader fileReader = new FileReader(config);
                    EMFConfigData = (EMFConfig)gson.fromJson((Reader)fileReader, EMFConfig.class);
                    fileReader.close();
                    EMFConfig.EMF_saveConfig();
                }
                catch (IOException e) {
                    EMFUtils.EMFModMessage("Config could not be loaded, using defaults", false);
                }
            } else {
                EMFConfigData = new EMFConfig();
                EMFConfig.EMF_saveConfig();
            }
            if (EMFConfigData == null) {
                EMFConfigData = new EMFConfig();
                EMFConfig.EMF_saveConfig();
            }
        }
        catch (Exception e) {
            EMFConfigData = new EMFConfig();
        }
    }

    public static EMFConfig copyFrom(EMFConfig source) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return (EMFConfig)gson.fromJson(gson.toJson((Object)source), EMFConfig.class);
    }

    public static enum VanillaModelRenderMode {
        Off(CommonComponents.f_130654_),
        Position_normal((Component)Component.m_237115_((String)"entity_model_features.config.vanilla_render.normal")),
        Positon_offset((Component)Component.m_237115_((String)"entity_model_features.config.vanilla_render.offset"));

        private final Component text;

        private VanillaModelRenderMode(Component text) {
            this.text = text;
        }

        public Component asText() {
            return this.text;
        }

        public VanillaModelRenderMode next() {
            return switch (this) {
                case Off -> Position_normal;
                case Position_normal -> Positon_offset;
                default -> Off;
            };
        }
    }

    public static enum MathFunctionChoice {
        JavaMath,
        MinecraftMath;

    }

    public static enum UnknownModelPrintMode {
        NONE(CommonComponents.f_130654_),
        LOG_ONLY((Component)Component.m_237115_((String)"entity_model_features.config.unknown_model_print_mode.log")),
        LOG_AND_JEM((Component)Component.m_237115_((String)"entity_model_features.config.unknown_model_print_mode.log_jem"));

        private final Component text;

        private UnknownModelPrintMode(Component text) {
            this.text = text;
        }

        public Component asText() {
            return this.text;
        }

        public UnknownModelPrintMode next() {
            return switch (this) {
                case NONE -> LOG_ONLY;
                case LOG_ONLY -> LOG_AND_JEM;
                default -> NONE;
            };
        }
    }

    public static enum TextureOverrideMode {
        OFF((Component)Component.m_237115_((String)"entity_model_features.config.texture_override_mode.dont")),
        EMF_CODE((Component)Component.m_237115_((String)"entity_model_features.config.texture_override_mode.emf")),
        USE_IRIS_QUIRK_AND_DEFER_TO_EMF_CODE_OTHERWISE((Component)Component.m_237115_((String)"entity_model_features.config.texture_override_mode.iris"));

        private final Component text;

        private TextureOverrideMode(Component text) {
            this.text = text;
        }

        public Component asText() {
            return this.text;
        }

        public TextureOverrideMode next() {
            return switch (this) {
                case OFF -> EMF_CODE;
                case EMF_CODE -> USE_IRIS_QUIRK_AND_DEFER_TO_EMF_CODE_OTHERWISE;
                default -> OFF;
            };
        }
    }
}

