/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;

public class EMFAnimationVariableSuppliers {
    public Entity entity = null;
    public float limbAngle = Float.MIN_VALUE;
    public float limbDistance = Float.MIN_VALUE;
    public float animationProgress = Float.MIN_VALUE;
    public float headYaw = Float.MIN_VALUE;
    public float headPitch = Float.MIN_VALUE;
    public float tickDelta = Float.MIN_VALUE;
    private final Object2IntOpenHashMap<UUID> knownHighestAngerTimeByUUID = new Object2IntOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(0);
        }
    };

    public float getRuleIndex() {
        return 0.0f;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public float getDimension() {
        if (this.entity == null || this.entity.m_9236_() == null) {
            return 0.0f;
        }
        ResourceLocation id = this.entity.m_9236_().m_220362_().m_135782_();
        if (id.equals((Object)BuiltinDimensionTypes.f_223543_)) {
            return -1.0f;
        }
        if (id.equals((Object)BuiltinDimensionTypes.f_223544_)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float getPlayerX() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Mth.m_14139_((double)this.tickDelta, (double)Minecraft.m_91087_().f_91074_.f_19854_, (double)Minecraft.m_91087_().f_91074_.m_20185_());
    }

    public float getPlayerY() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Mth.m_14139_((double)this.tickDelta, (double)Minecraft.m_91087_().f_91074_.f_19855_, (double)Minecraft.m_91087_().f_91074_.m_20186_());
    }

    public float getPlayerZ() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Mth.m_14139_((double)this.tickDelta, (double)Minecraft.m_91087_().f_91074_.f_19856_, (double)Minecraft.m_91087_().f_91074_.m_20189_());
    }

    public float getPlayerRX() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Math.toRadians(Mth.m_14189_((float)this.tickDelta, (float)Minecraft.m_91087_().f_91074_.f_19860_, (float)Minecraft.m_91087_().f_91074_.m_146909_()));
    }

    public float getPlayerRY() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Math.toRadians(Mth.m_14189_((float)this.tickDelta, (float)Minecraft.m_91087_().f_91074_.f_19859_, (float)Minecraft.m_91087_().f_91074_.m_146908_()));
    }

    public float getEntityX() {
        return this.getEntity() == null ? 0.0f : (float)Mth.m_14139_((double)this.getTickDelta(), (double)this.getEntity().f_19854_, (double)this.getEntity().m_20185_());
    }

    public float getEntityY() {
        return this.getEntity() == null ? 0.0f : (float)Mth.m_14139_((double)this.getTickDelta(), (double)this.getEntity().f_19855_, (double)this.getEntity().m_20186_());
    }

    public float getEntityZ() {
        return this.getEntity() == null ? 0.0f : (float)Mth.m_14139_((double)this.getTickDelta(), (double)this.getEntity().f_19856_, (double)this.getEntity().m_20189_());
    }

    public float getEntityRX() {
        return this.getEntity() == null ? 0.0f : (float)Math.toRadians(Mth.m_14189_((float)this.tickDelta, (float)this.getEntity().f_19860_, (float)this.getEntity().m_146909_()));
    }

    public float getEntityRY() {
        float f;
        Entity entity = this.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)entity;
            f = (float)Math.toRadians(Mth.m_14189_((float)this.tickDelta, (float)alive.f_20884_, (float)alive.m_213816_()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getTime() {
        if (this.entity == null || this.entity.m_9236_() == null) {
            return 0.0f + this.tickDelta;
        }
        long upTimeInTicks = this.entity.m_9236_().m_46467_();
        return this.constrainedFloat(upTimeInTicks, 720720) + this.tickDelta;
    }

    public float getDayTime() {
        if (this.entity == null || this.entity.m_9236_() == null) {
            return 0.0f + this.tickDelta;
        }
        return this.constrainedFloat(this.entity.m_9236_().m_46468_(), 24000) + this.tickDelta;
    }

    public float getDayCount() {
        if (this.entity == null || this.entity.m_9236_() == null) {
            return 0.0f + this.tickDelta;
        }
        return (float)(this.entity.m_9236_().m_46468_() / 24000L) + this.tickDelta;
    }

    public float getHealth() {
        float f;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)entity;
            f = alive.m_21223_();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public float getDeathTime() {
        float f;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)entity;
            f = alive.f_20919_;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getAngerTime() {
        if (!(this.entity instanceof NeutralMob)) {
            return 0.0f;
        }
        float currentKnownHighest = this.knownHighestAngerTimeByUUID.getInt((Object)this.entity.m_20148_());
        int angerTime = ((NeutralMob)this.entity).m_6784_();
        if (angerTime <= 0) {
            this.knownHighestAngerTimeByUUID.put((Object)this.entity.m_20148_(), 0);
            return 0.0f;
        }
        if ((float)angerTime > currentKnownHighest) {
            this.knownHighestAngerTimeByUUID.put((Object)this.entity.m_20148_(), angerTime);
        }
        return (float)angerTime - this.tickDelta;
    }

    public float getAngerTimeStart() {
        return !(this.entity instanceof NeutralMob) ? 0.0f : (float)this.knownHighestAngerTimeByUUID.getInt((Object)this.entity.m_20148_());
    }

    public float getMaxHealth() {
        float f;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)entity;
            f = alive.m_21233_();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public float getId() {
        return this.entity == null ? 0.0f : (float)this.entity.m_20148_().hashCode();
    }

    public float getHurtTime() {
        float f;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)entity;
            f = alive.f_20916_ > 0 ? (float)alive.f_20916_ - this.tickDelta : 0.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public boolean isInWater() {
        return this.entity != null && this.entity.m_20069_();
    }

    public boolean isBurning() {
        return this.entity != null && this.entity.m_6060_();
    }

    public boolean isRiding() {
        return this.entity != null && this.entity.m_20159_();
    }

    public boolean isChild() {
        LivingEntity alive;
        Entity entity = this.entity;
        return entity instanceof LivingEntity && (alive = (LivingEntity)entity).m_6162_();
    }

    public boolean isOnGround() {
        return this.entity != null && this.entity.m_20096_();
    }

    public boolean isClimbing() {
        LivingEntity alive;
        Entity entity = this.entity;
        return entity instanceof LivingEntity && (alive = (LivingEntity)entity).m_6147_();
    }

    public boolean isAlive() {
        return this.entity != null && this.entity.m_6084_();
    }

    public boolean isAggressive() {
        return this.entity instanceof Mob && ((Mob)this.entity).m_5912_();
    }

    public boolean isGlowing() {
        return this.entity != null && this.entity.m_142038_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHurt() {
        Entity entity = this.entity;
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity alive = (LivingEntity)entity;
        if (alive.f_20916_ <= 0) return false;
        return true;
    }

    public boolean isInHand() {
        return false;
    }

    public boolean isInItemFrame() {
        return false;
    }

    public boolean isInGround() {
        Arrow arrow;
        Entity entity = this.entity;
        return entity instanceof Arrow && (arrow = (Arrow)entity).m_20096_();
    }

    public boolean isInGui() {
        return false;
    }

    public boolean isInLava() {
        return this.entity != null && this.entity.m_20077_();
    }

    public boolean isInvisible() {
        return this.entity != null && this.entity.m_20145_();
    }

    public boolean isOnHead() {
        return false;
    }

    public boolean isOnShoulder() {
        return false;
    }

    public boolean isRidden() {
        return this.entity != null && this.entity.m_20160_();
    }

    public boolean isSitting() {
        Wolf wolf;
        Cat cat;
        Parrot parrot;
        Fox fox;
        TamableAnimal tame;
        Entity entity;
        return this.entity != null && ((entity = this.entity) instanceof TamableAnimal && (tame = (TamableAnimal)entity).m_21825_() || (entity = this.entity) instanceof Fox && (fox = (Fox)entity).m_28555_() || (entity = this.entity) instanceof Parrot && (parrot = (Parrot)entity).m_21825_() || (entity = this.entity) instanceof Cat && (cat = (Cat)entity).m_21825_() || (entity = this.entity) instanceof Wolf && (wolf = (Wolf)entity).m_21825_());
    }

    public boolean isSneaking() {
        return this.entity != null && this.entity.m_6144_();
    }

    public boolean isSprinting() {
        return this.entity != null && this.entity.m_20142_();
    }

    public boolean isTamed() {
        TamableAnimal tame;
        Entity entity = this.entity;
        return entity instanceof TamableAnimal && (tame = (TamableAnimal)entity).m_21824_();
    }

    public boolean isWet() {
        return this.entity != null && this.entity.m_20071_();
    }

    public float getSwingProgress() {
        float f;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)entity;
            f = alive.m_21324_(this.tickDelta);
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getAge() {
        if (this.entity == null) {
            return 0.0f + this.tickDelta;
        }
        return this.constrainedFloat(this.entity.f_19797_, 24000) + this.tickDelta;
    }

    private float constrainedFloat(float value, int constraint) {
        return value >= (float)constraint ? value % (float)constraint : value;
    }

    private float constrainedFloat(float value) {
        return this.constrainedFloat(value, 24000);
    }

    private float constrainedFloat(long value, int constraint) {
        return value >= (long)constraint ? value % (long)constraint : value;
    }

    private float constrainedFloat(long value) {
        return this.constrainedFloat(value, 24000);
    }

    private float constrainedFloat(int value, int constraint) {
        return value >= constraint ? value % constraint : value;
    }

    private float constrainedFloat(int value) {
        return this.constrainedFloat(value, 24000);
    }

    public float getFrameTime() {
        return Minecraft.m_91087_().m_91297_() / 20.0f;
    }

    public float getLimbAngle() {
        return this.limbAngle;
    }

    public float getLimbDistance() {
        return this.limbDistance == Float.MIN_VALUE ? 0.0f : this.limbDistance;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public float getHeadPitch() {
        return this.headPitch;
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    public float getMoveForward() {
        if (this.entity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - this.entity.m_146908_());
        Vec3 velocity = this.entity.m_20184_();
        double x = velocity.f_82479_;
        double y = velocity.f_82481_;
        double newX = x * Math.cos(lookDir) - y * Math.sin(lookDir);
        return this.processMove(newX, x, y);
    }

    public float getMoveStrafe() {
        if (this.entity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - this.entity.m_146908_());
        Vec3 velocity = this.entity.m_20184_();
        double x = velocity.f_82479_;
        double y = velocity.f_82481_;
        double newY = x * Math.sin(lookDir) + y * Math.cos(lookDir);
        return this.processMove(newY, x, y);
    }

    private float processMove(double value, double x, double y) {
        double totalMovementVector = Math.sqrt(x * x + y * y);
        if (totalMovementVector == 0.0) {
            return 0.0f;
        }
        return (float)(-(value / totalMovementVector));
    }
}

