/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.models.EMFModelPartMutable;

public enum EMFDefaultModelVariable {
    tx,
    ty,
    tz,
    rx,
    ry,
    rz,
    sx,
    sy,
    sz,
    visible,
    visible_boxes,
    CUSTOM;


    @Nullable
    public static EMFDefaultModelVariable get(String id) {
        if (id == null) {
            return null;
        }
        return switch (id) {
            case "tx" -> tx;
            case "ty" -> ty;
            case "tz" -> tz;
            case "rx" -> rx;
            case "ry" -> ry;
            case "rz" -> rz;
            case "sx" -> sx;
            case "sy" -> sy;
            case "sz" -> sz;
            case "visible" -> visible;
            case "visible_boxes" -> visible_boxes;
            default -> null;
        };
    }

    public float getDefaultFromModel(ModelPart modelPart) {
        if (modelPart == null) {
            System.out.println("model part was null cannot get its default value");
            return 0.0f;
        }
        PartPose transform = modelPart.m_233566_();
        switch (this) {
            case tx: {
                return transform.f_171405_;
            }
            case ty: {
                return transform.f_171406_;
            }
            case tz: {
                return transform.f_171407_;
            }
            case rx: {
                return transform.f_171408_;
            }
            case ry: {
                return transform.f_171409_;
            }
            case rz: {
                return transform.f_171410_;
            }
            case sx: {
                return modelPart.f_233553_;
            }
            case sy: {
                return modelPart.f_233554_;
            }
            case sz: {
                return modelPart.f_233555_;
            }
            case visible: {
                return modelPart.f_104207_ ? 1.0f : 0.0f;
            }
            case visible_boxes: {
                return modelPart.f_233556_ ? 0.0f : 1.0f;
            }
        }
        System.out.println("model variable was defaulted cannot get its default value");
        return 0.0f;
    }

    public float getFromMutableModel(EMFModelPartMutable modelPart) {
        if (modelPart == null) {
            System.out.println("model part was null cannot get its value");
            return 0.0f;
        }
        float[] parentModify = modelPart.selfModelData != null ? modelPart.selfModelData.parentModified : new float[]{0.0f, 0.0f, 0.0f};
        switch (this) {
            case tx: {
                return modelPart.f_104200_ - parentModify[0];
            }
            case ty: {
                return modelPart.f_104201_ - parentModify[1];
            }
            case tz: {
                return modelPart.f_104202_ - parentModify[2];
            }
            case rx: {
                return modelPart.f_104203_;
            }
            case ry: {
                return modelPart.f_104204_;
            }
            case rz: {
                return modelPart.f_104205_;
            }
            case sx: {
                return modelPart.f_233553_;
            }
            case sy: {
                return modelPart.f_233554_;
            }
            case sz: {
                return modelPart.f_233555_;
            }
            case visible: {
                return modelPart.f_104207_ ? 1.0f : 0.0f;
            }
            case visible_boxes: {
                return modelPart.f_233556_ ? 0.0f : 1.0f;
            }
        }
        System.out.println("model variable was defaulted cannot get its value");
        return 0.0f;
    }

    public void setValueInMutableModel(EMFModelPartMutable modelPart, float value) {
        if (modelPart == null) {
            System.out.println("model part was null cannot set its value");
            return;
        }
        float[] parentModify = modelPart.selfModelData != null ? modelPart.selfModelData.parentModified : new float[]{0.0f, 0.0f, 0.0f};
        switch (this) {
            case tx: {
                modelPart.f_104200_ = value + parentModify[0];
                break;
            }
            case ty: {
                modelPart.f_104201_ = value + parentModify[1];
                break;
            }
            case tz: {
                modelPart.f_104202_ = value + parentModify[2];
                break;
            }
            case rx: {
                modelPart.f_104203_ = value;
                break;
            }
            case ry: {
                modelPart.f_104204_ = value;
                break;
            }
            case rz: {
                modelPart.f_104205_ = value;
                break;
            }
            case sx: {
                modelPart.f_233553_ = value;
                break;
            }
            case sy: {
                modelPart.f_233554_ = value;
                break;
            }
            case sz: {
                modelPart.f_233555_ = value;
                break;
            }
            case visible: {
                modelPart.f_104207_ = value == 1.0f;
                break;
            }
            case visible_boxes: {
                modelPart.f_233556_ = value != 1.0f;
                break;
            }
            default: {
                System.out.println("model variable was defaulted cannot set its value");
            }
        }
    }
}

