/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.jem_objects;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;

public class EMFJemData {
    public final LinkedHashMap<String, String> finalAnimationsForModel = new LinkedHashMap();
    private static final String REGEX_PREFIX = "(?<=([^a-zA-Z0-9_]|^))";
    private static final String REGEX_SUFFIX = "(?=([^a-zA-Z0-9_]|$))";
    public String texture = "";
    public int[] textureSize = null;
    public double shadow_size = 1.0;
    public LinkedList<EMFPartData> models = new LinkedList();
    public LinkedList<EMFPartData> originalModelsForReadingOnly;
    public String fileName = "none";
    public String mobName = "none";
    public ResourceLocation customTexture = null;

    public void sendFileName(String fileName) {
        this.fileName = fileName;
        this.mobName = fileName.replace("optifine/cem/", "").replace(".jem", "");
    }

    public void prepare() {
        this.originalModelsForReadingOnly = new LinkedList<EMFPartData>(this.models);
        if (!this.texture.equals("")) {
            if (!this.texture.contains(".png")) {
                this.texture = this.texture + ".png";
            }
            if (!this.texture.contains("/")) {
                this.texture = "optifine/cem/" + this.texture;
            }
            ResourceLocation possibleTexture = new ResourceLocation(this.texture);
            if (Minecraft.m_91087_().m_91098_().m_213713_(possibleTexture).isPresent()) {
                this.customTexture = possibleTexture;
            }
        }
        String mobNameMinusVariant = this.mobName.replaceAll("(?<=\\w)[0-9]", "");
        Map<String, EMFOptiFinePartNameMappings.PartAndChildName> map = EMFOptiFinePartNameMappings.getMapOf(mobNameMinusVariant);
        for (EMFPartData eMFPartData : this.models) {
            if (eMFPartData.part == null || !map.containsKey(eMFPartData.part)) continue;
            String newPartName = map.get(eMFPartData.part).partName();
            if (eMFPartData.id.equals(eMFPartData.part)) {
                eMFPartData.id = newPartName;
            }
            eMFPartData.part = newPartName;
        }
        LinkedList<EMFPartData> missingModels = new LinkedList<EMFPartData>();
        for (EMFOptiFinePartNameMappings.PartAndChildName data : map.values()) {
            String name = data.partName();
            boolean bl = false;
            for (EMFPartData eMFPartData : this.models) {
                if (!name.equals(eMFPartData.part) || eMFPartData.attach && !eMFPartData.id.equals(eMFPartData.part)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            missingModels.add(EMFPartData.getBlankPartWithIDOf(name, this.textureSize));
        }
        if (missingModels.size() > 0) {
            EMFUtils.EMFModError("These parts were missing from [" + this.fileName + "]: " + missingModels);
            this.models.addAll(missingModels);
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator modelsIterator = this.models.iterator();
        while (modelsIterator.hasNext()) {
            EMFPartData model = (EMFPartData)modelsIterator.next();
            if (!model.attach || model.id.equals(model.part)) continue;
            linkedList.add(model);
            modelsIterator.remove();
        }
        for (EMFPartData eMFPartData : linkedList) {
            if (eMFPartData.part == null) continue;
            for (EMFPartData eMFPartData2 : this.models) {
                if (!eMFPartData2.id.equals(eMFPartData.part)) continue;
                eMFPartData2.submodels.add(eMFPartData);
                eMFPartData.part = null;
            }
        }
        HashSet<String> foundChildren = new HashSet<String>();
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : map.entrySet()) {
            EMFPartData eMFPartData;
            if (((EMFOptiFinePartNameMappings.PartAndChildName)entry.getValue()).childNamesToExpect().size() <= 0 || (eMFPartData = this.getFirstPartInModelsIgnoreAttach(((EMFOptiFinePartNameMappings.PartAndChildName)entry.getValue()).partName())) == null) continue;
            for (String string : ((EMFOptiFinePartNameMappings.PartAndChildName)entry.getValue()).childNamesToExpect()) {
                if (string.startsWith("!")) {
                    eMFPartData.submodels.add(EMFPartData.getBlankPartWithIDOf(string.replaceFirst("!", ""), this.textureSize));
                    continue;
                }
                EMFPartData child = this.getFirstPartInModelsIgnoreAttach(string);
                if (child != null) {
                    eMFPartData.submodels.add(child);
                } else {
                    eMFPartData.submodels.add(EMFPartData.getBlankPartWithIDOf(string, this.textureSize));
                }
                foundChildren.add(string);
            }
        }
        this.models.removeIf(topLevelPart -> foundChildren.contains(topLevelPart.part));
        for (EMFPartData eMFPartData : this.models) {
            eMFPartData.prepare(0, this.textureSize, new float[]{0.0f, 0.0f, 0.0f});
        }
        TreeMap alphabeticalOrderedParts = new TreeMap(Comparator.naturalOrder());
        if (EMFConfig.getConfig().printModelCreationInfoToLog) {
            EMFUtils.EMFModMessage("originalModelsForReadingOnly #= " + this.originalModelsForReadingOnly.size());
        }
        for (EMFPartData eMFPartData : this.originalModelsForReadingOnly) {
            alphabeticalOrderedParts.put(eMFPartData.id, eMFPartData);
        }
        LinkedList<LinkedHashMap<String, String>> linkedList2 = new LinkedList<LinkedHashMap<String, String>>();
        if (EMFConfig.getConfig().printModelCreationInfoToLog) {
            EMFUtils.EMFModMessage("alphabeticalOrderedParts = " + alphabeticalOrderedParts);
        }
        for (EMFPartData part : alphabeticalOrderedParts.values()) {
            if (part.animations == null || part.animations.length == 0) continue;
            linkedList2.addAll(Arrays.asList(part.animations));
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (EMFConfig.getConfig().printModelCreationInfoToLog) {
            EMFUtils.EMFModMessage("allTopLevelPropertiesOrdered = " + linkedList2);
        }
        for (LinkedHashMap linkedHashMap2 : linkedList2) {
            if (linkedHashMap2.isEmpty()) continue;
            linkedHashMap.putAll(linkedHashMap2);
        }
        if (EMFConfig.getConfig().printModelCreationInfoToLog) {
            EMFUtils.EMFModMessage("combinedPropertiesOrdered = " + linkedHashMap);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (entry.getKey() != null && !((String)entry.getKey()).isEmpty()) {
                String animationKey = ((String)entry.getKey()).replaceAll("\\s", "");
                String animationExpression = ((String)entry.getValue()).replaceAll("\\s", "");
                if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                    EMFUtils.EMFModMessage("map = " + map);
                }
                for (Map.Entry<String, EMFOptiFinePartNameMappings.PartAndChildName> optifineMapEntry : map.entrySet()) {
                    String vanillaPartName;
                    String optifinePartName = optifineMapEntry.getKey();
                    if (optifinePartName.equals(vanillaPartName = optifineMapEntry.getValue().partName())) continue;
                    if (animationKey.contains(optifinePartName)) {
                        animationKey = animationKey.replaceAll(REGEX_PREFIX + optifinePartName + REGEX_SUFFIX, vanillaPartName);
                    }
                    if (!animationExpression.contains(optifinePartName)) continue;
                    animationExpression = animationExpression.replaceAll(REGEX_PREFIX + optifinePartName + REGEX_SUFFIX, vanillaPartName);
                }
                this.finalAnimationsForModel.put(animationKey, animationExpression);
            } else {
                System.out.println("null key 1346341");
            }
            if (!EMFConfig.getConfig().printModelCreationInfoToLog) continue;
            EMFUtils.EMFModMessage("finalAnimationsForModel =" + this.finalAnimationsForModel);
        }
    }

    private EMFPartData getFirstPartInModelsIgnoreAttach(String partName) {
        EMFPartData first = null;
        for (EMFPartData emfPartData : this.models) {
            if (!emfPartData.part.equals(partName)) continue;
            if (!emfPartData.attach) {
                return emfPartData;
            }
            if (first != null) continue;
            first = emfPartData;
        }
        return first;
    }

    public String toString() {
        return "EMF_JemData{texture='" + this.texture + "', textureSize=" + Arrays.toString(this.textureSize) + ", shadow_size=" + this.shadow_size + ", models=" + this.models.toString() + "}";
    }

    public static class EMFJemPrinter {
        public String texture = "";
        public int[] textureSize = new int[]{16, 16};
        public double shadow_size = 1.0;
        public LinkedList<EMFPartData.EMFPartPrinter> models = new LinkedList();
    }
}

