/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.jem_objects;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import traben.entity_model_features.models.jem_objects.EMFBoxData;
import traben.entity_model_features.models.jem_objects.EMFSpriteData;
import traben.entity_model_features.utils.EMFUtils;

public class EMFPartData {
    public static final EMFPartData BLANK_PART_DATA = new EMFPartData(){
        {
            this.id = "EMF_BLANK_MODEL_PART";
            this.texture = "EMF_BLANK_MODEL_PART";
            this.invertAxis = "EMF_BLANK_MODEL_PART";
            this.textureSize = new int[]{1, 1};
            this.scale = 0.0f;
            this.thisNeedsToMergeWithVanilla = true;
        }
    };
    public String texture = "";
    public int[] textureSize = null;
    public String invertAxis = "";
    public float[] translate = new float[]{0.0f, 0.0f, 0.0f};
    public float[] rotate = new float[]{0.0f, 0.0f, 0.0f};
    public String mirrorTexture = "";
    public EMFBoxData[] boxes = new EMFBoxData[0];
    public EMFSpriteData[] sprites = new EMFSpriteData[0];
    public EMFPartData submodel = null;
    public LinkedList<EMFPartData> submodels = new LinkedList();
    public String baseId = "";
    public String model = "";
    public String id = "";
    public String part = null;
    public boolean attach = false;
    public float scale = 1.0f;
    public boolean thisNeedsToMergeWithVanilla = false;
    public LinkedHashMap<String, String>[] animations = null;
    public float[] parentModified = new float[]{0.0f, 0.0f, 0.0f};
    public boolean topLevelModel = false;
    public boolean underATopLevelModel = false;
    public ResourceLocation customTexture = null;

    public static EMFPartData getBlankPartWithIDOf(final String id2, final @Nullable int[] textureSizeIn) {
        if ("root".equals(id2)) {
            return new EMFPartData(){
                {
                    this.id = id2;
                    this.part = id2;
                    this.textureSize = textureSizeIn;
                }
            };
        }
        return new EMFPartData(){
            {
                this.id = id2;
                this.part = id2;
                this.textureSize = textureSizeIn;
                this.thisNeedsToMergeWithVanilla = true;
            }
        };
    }

    public static EMFPartData getBlankPartWithIDOfAndChildren(final String id2, final List<String> children) {
        return new EMFPartData(){
            {
                this.id = id2;
                this.part = id2;
                this.textureSize = new int[]{1, 1};
                this.scale = 0.0f;
                this.submodels = new LinkedList();
                children.forEach(name -> this.submodels.add(4.getBlankPartWithIDOf(name, new int[]{1, 1})));
                this.thisNeedsToMergeWithVanilla = true;
            }
        };
    }

    private void copyFrom(EMFPartData jpmModel) {
        this.submodels = jpmModel.submodels;
        this.submodel = jpmModel.submodel;
        this.textureSize = jpmModel.textureSize;
        this.texture = jpmModel.texture;
        this.invertAxis = jpmModel.invertAxis;
        this.translate = jpmModel.translate;
        this.rotate = jpmModel.rotate;
        this.mirrorTexture = jpmModel.mirrorTexture;
        this.boxes = jpmModel.boxes;
        this.sprites = jpmModel.sprites;
        this.scale = jpmModel.scale;
        this.animations = jpmModel.animations;
        this.baseId = jpmModel.baseId;
    }

    public void prepare(int parentCount, int[] textureSize, float[] modifyyTranslates) {
        EMFPartData jpmModel;
        if (!this.model.isEmpty() && (jpmModel = EMFUtils.EMFReadModelPart(this.model)) != null) {
            this.copyFrom(jpmModel);
        }
        if (this.textureSize == null) {
            this.textureSize = textureSize;
        }
        if (!this.texture.equals("")) {
            if (!this.texture.contains(".png")) {
                this.texture = this.texture + ".png";
            }
            if (!this.texture.contains("/")) {
                this.texture = "optifine/cem/" + this.texture;
            }
            ResourceLocation possibleTexture = new ResourceLocation(this.texture);
            if (Minecraft.m_91087_().m_91098_().m_213713_(possibleTexture).isPresent()) {
                this.customTexture = possibleTexture;
            }
        }
        boolean invX = this.invertAxis.contains("x");
        boolean invY = this.invertAxis.contains("y");
        boolean invZ = this.invertAxis.contains("z");
        float translateX = this.translate[0];
        float translateY = this.translate[1];
        float translateZ = this.translate[2];
        float rotateX = (float)Math.toRadians(this.rotate[0]);
        float rotateY = (float)Math.toRadians(this.rotate[1]);
        float rotateZ = (float)Math.toRadians(this.rotate[2]);
        if (invX) {
            rotateX = -rotateX;
            translateX = -translateX;
        }
        if (invY) {
            rotateY = -rotateY;
            translateY = -translateY;
        }
        if (invZ) {
            rotateZ = -rotateZ;
            translateZ = -translateZ;
        }
        float[] nextModify = new float[]{0.0f, 0.0f, 0.0f};
        if (this.part != null) {
            nextModify = new float[]{this.translate[0], this.translate[1], this.translate[2]};
            if (parentCount == 0) {
                this.topLevelModel = true;
                this.translate[0] = -translateX;
                this.translate[1] = 24.0f - translateY;
                this.translate[2] = -translateZ;
            } else {
                this.topLevelModel = false;
                this.underATopLevelModel = parentCount == 1;
                this.translate[0] = -translateX + (invX ? -modifyyTranslates[0] : modifyyTranslates[0]);
                this.translate[1] = -translateY + (invY ? -modifyyTranslates[1] : modifyyTranslates[1]);
                this.translate[2] = -translateZ + (invZ ? -modifyyTranslates[2] : modifyyTranslates[2]);
            }
        } else if (this.attach) {
            this.translate[0] = 0.0f;
            this.translate[1] = 0.0f;
            this.translate[2] = 0.0f;
            this.underATopLevelModel = parentCount == 1;
        } else {
            this.translate[0] = translateX + (invX ? -modifyyTranslates[0] : modifyyTranslates[0]);
            this.translate[1] = translateY + (invY ? -modifyyTranslates[1] : modifyyTranslates[1]);
            this.translate[2] = translateZ + (invZ ? -modifyyTranslates[2] : modifyyTranslates[2]);
            this.underATopLevelModel = parentCount == 1;
            this.parentModified = new float[]{invX ? -modifyyTranslates[0] : modifyyTranslates[0], invY ? -modifyyTranslates[1] : modifyyTranslates[1], invZ ? -modifyyTranslates[2] : modifyyTranslates[2]};
        }
        this.rotate[0] = rotateX;
        this.rotate[1] = rotateY;
        this.rotate[2] = rotateZ;
        for (EMFBoxData box : this.boxes) {
            box.prepare(invX, invY, invZ, nextModify[0], nextModify[1], nextModify[2]);
        }
        for (EMFSpriteData sprite : this.sprites) {
            sprite.prepare();
        }
        if (this.submodel != null) {
            this.submodel.prepare(parentCount + 1, this.textureSize, nextModify);
        }
        for (EMFPartData model : this.submodels) {
            model.prepare(parentCount + 1, this.textureSize, nextModify);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean printFullChild) {
        return "EMF_ModelData{baseId='" + this.baseId + "', model='" + this.model + "', id='" + this.id + "', part='" + this.part + "', attach=" + this.attach + ", scale=" + this.scale + ", animations=" + Arrays.toString(this.animations) + ", texture='" + this.texture + "', textureSize=" + Arrays.toString(this.textureSize) + ", invertAxis='" + this.invertAxis + "', translate=" + Arrays.toString(this.translate) + ", rotate=" + Arrays.toString(this.rotate) + ", mirrorTexture='" + this.mirrorTexture + "', boxes=" + Arrays.toString(this.boxes) + ", sprites=" + Arrays.toString(this.sprites) + ", submodel=" + this.submodel + ", submodels=" + (printFullChild ? this.submodels.toString() : this.printChildNamesOnly()) + "}";
    }

    private String printChildNamesOnly() {
        StringBuilder str = new StringBuilder();
        for (EMFPartData model : this.submodels) {
            str.append(model.id).append(", ");
        }
        return str.toString().trim();
    }

    public static class EMFPartPrinter {
        public String texture = "";
        public int[] textureSize = null;
        public String invertAxis = "";
        public float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        public float[] rotate = new float[]{0.0f, 0.0f, 0.0f};
        public String mirrorTexture = "";
        public EMFBoxData.EMFBoxPrinter[] boxes = new EMFBoxData.EMFBoxPrinter[0];
        public EMFSpriteData[] sprites = new EMFSpriteData[0];
        public EMFPartPrinter submodel = null;
        public LinkedList<EMFPartPrinter> submodels = new LinkedList();
        public String baseId = "";
        public String model = "";
        public String id = "";
        public String part = null;
        public boolean attach = false;
        public float scale = 1.0f;
        public LinkedHashMap<String, String>[] animations = new LinkedHashMap[0];
    }
}

