/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.jem_objects.EMFBoxData;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFUtils;

public class EMFOptiFinePartNameMappings {
    private static final Map<String, PartAndChildName> genericNonPlayerBiped = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
    private static final Map<String, PartAndChildName> genericIllager = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("hat", "nose")), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"), EMFOptiFinePartNameMappings.getOptifineMapEntry("arms"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
    private static final Map<String, PartAndChildName> genericHorse = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", List.of("tail", "saddle")), EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("left_ear", "right_ear")), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("saddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mane"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mouth", "upper_mouth"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("neck", "head_parts", List.of("head", "left_saddle_mouth", "right_saddle_mouth", "left_saddle_line", "right_saddle_line", "head_saddle", "mouth_saddle_wrap", "mane", "upper_mouth")), EMFOptiFinePartNameMappings.getOptifineMapEntry("noseband", "mouth_saddle_wrap"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headpiece", "head_saddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_rein", "right_saddle_line"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_rein", "left_saddle_line"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_bit", "right_saddle_mouth"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_bit", "left_saddle_mouth"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("child_back_left_leg", "left_hind_baby_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("child_back_right_leg", "right_hind_baby_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("child_front_left_leg", "left_front_baby_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("child_front_right_leg", "right_front_baby_leg"));
    private static final Map<String, PartAndChildName> genericPlayerBiped = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_sleeve"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_sleeve"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_pants"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_pants"), EMFOptiFinePartNameMappings.getOptifineMapEntry("jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("cloak"));
    private static final Map<String, PartAndChildName> genericPiglinBiped = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("right_ear", "left_ear")), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_sleeve"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_sleeve"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_pants"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_pants"), EMFOptiFinePartNameMappings.getOptifineMapEntry("jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("cloak"));
    private static final Map<String, PartAndChildName> genericQuadraped = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"));
    private static final Map<String, PartAndChildName> genericLlama = new HashMap<String, PartAndChildName>(genericQuadraped){
        {
            this.putAll(Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_left", "left_chest"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_right", "right_chest")));
        }
    };
    public static final Map<String, Map<String, PartAndChildName>> UNKNOWN_MODEL_MAP_CACHE = new HashMap<String, Map<String, PartAndChildName>>();

    public static Map.Entry<String, PartAndChildName> getOptifineMapEntry(String optifineName) {
        return new MutablePair((Object)optifineName, (Object)EMFOptiFinePartNameMappings._getPartAndChild(optifineName));
    }

    public static Map.Entry<String, PartAndChildName> getOptifineMapEntry(String optifineName, String vanillaName) {
        return new MutablePair((Object)optifineName, (Object)EMFOptiFinePartNameMappings._getPartAndChild(vanillaName));
    }

    public static Map.Entry<String, PartAndChildName> getOptifineMapEntry(String optifineName, String vanillaName, String childName) {
        return new MutablePair((Object)optifineName, (Object)EMFOptiFinePartNameMappings._getPartAndChild(vanillaName, childName));
    }

    public static Map.Entry<String, PartAndChildName> getOptifineMapEntry(String optifineName, String vanillaName, List<String> childNames) {
        return new MutablePair((Object)optifineName, (Object)EMFOptiFinePartNameMappings._getPartAndChild(vanillaName, childNames));
    }

    public static PartAndChildName _getPartAndChild(String partName, String childName) {
        return new PartAndChildName(partName, Collections.singletonList(childName));
    }

    public static PartAndChildName _getPartAndChild(String partName) {
        return new PartAndChildName(partName, new ArrayList<String>());
    }

    public static PartAndChildName _getPartAndChild(String partName, List<String> childNamesToExpect) {
        return new PartAndChildName(partName, childNamesToExpect);
    }

    public static Map<String, PartAndChildName> getMapOf(String mobName) {
        if (mobName.contains("_inner_armor")) {
            mobName = mobName.replace("_inner_armor", "");
        }
        if (mobName.contains("_outer_armor")) {
            mobName = mobName.replace("_outer_armor", "");
        }
        return switch (mobName) {
            case "villager", "wandering_trader" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("hat", "nose")), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat", "hat_rim"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear2", "hat_rim"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bodywear", "jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", "jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("arms"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"));
            case "iron_golem" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
            case "spider", "cave_spider" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("neck", "body0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_middle_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_middle_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg5", "right_middle_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg6", "left_middle_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg7", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg8", "left_front_leg"));
            case "sheep", "cow", "creeper", "creeper_charge", "mooshroom", "panda", "pig", "pig_saddle", "polar_bear", "sheep_wool" -> genericQuadraped;
            case "zombie", "husk", "drowned", "drowned_outer", "enderman", "giant", "skeleton", "stray", "stray_outer", "wither_skeleton", "zombie_pigman" -> genericNonPlayerBiped;
            case "piglin", "piglin_brute", "zombified_piglin" -> genericPiglinBiped;
            case "allay" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", List.of("left_arm", "right_arm", "left_wing", "right_wing")), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"));
            case "vex" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"));
            case "squid", "glow_squid" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle1", "tentacle0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle2", "tentacle1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle3", "tentacle2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle4", "tentacle3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle5", "tentacle4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle6", "tentacle5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle7", "tentacle6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle8", "tentacle7"));
            case "ghast" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle1", "tentacle0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle2", "tentacle1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle3", "tentacle2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle4", "tentacle3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle5", "tentacle4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle6", "tentacle5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle7", "tentacle6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle8", "tentacle7"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle9", "tentacle8"));
            case "wolf", "wolf_collar" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", "real_head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "tail", "real_tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mane", "upper_body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"));
            case "shulker_bullet" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("bullet", "main"));
            case "llama_spit" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "main"));
            case "wither_skull", "head_zombie", "head_wither_skeleton", "head_skeleton", "head_player", "head_creeper" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", "hat"));
            case "head_piglin" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("hat", "left_ear", "right_ear")));
            case "head_dragon" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("jaw", "upper_lip")), EMFOptiFinePartNameMappings.getOptifineMapEntry("jaw"));
            case "chest" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base", "bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("knob", "lock"));
            case "chest_large" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("lid_left", "lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base_left", "bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("knob_left", "lock"), EMFOptiFinePartNameMappings.getOptifineMapEntry("lid_right", "lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base_right", "bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("knob_right", "lock"));
            case "horse", "horse_armor", "skeleton_horse", "zombie_horse" -> genericHorse;
            case "donkey", "mule" -> new HashMap<String, PartAndChildName>(genericHorse){
                {
                    this.putAll(Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("right_chest"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_chest"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", List.of("tail", "saddle", "left_chest", "right_chest"))));
                }
            };
            case "zombie_villager" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat", "hat_rim"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hat_rim"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
            case "evoker", "illusioner", "pillager", "vindicator" -> genericIllager;
            case "llama", "llama_decor", "trader_llama", "trader_llama_decor" -> genericLlama;
            case "armor_stand" -> new HashMap<String, PartAndChildName>(genericNonPlayerBiped){
                {
                    this.putAll(Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("right", "right_body_stick"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left", "left_body_stick"), EMFOptiFinePartNameMappings.getOptifineMapEntry("waist", "shoulder_stick"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base", "base_plate")));
                }
            };
            case "axolotl" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", List.of("head", "tail", "right_hind_leg", "left_hind_leg", "right_front_leg", "left_front_leg")), EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("top_gills", "left_gills", "right_gills")), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_gills"), EMFOptiFinePartNameMappings.getOptifineMapEntry("top_gills"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_gills"));
            case "bat" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", List.of("right_wing", "left_wing")), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing", "right_wing", "right_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing", "left_wing", "left_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("outer_right_wing", "right_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("outer_left_wing", "left_wing_tip"));
            case "bee" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "bone", List.of("body", "right_wing", "left_wing", "front_legs", "middle_legs", "back_legs")), EMFOptiFinePartNameMappings.getOptifineMapEntry("torso", "body", List.of("stinger", "left_antenna", "right_antenna")), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_legs"), EMFOptiFinePartNameMappings.getOptifineMapEntry("middle_legs"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_legs"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stinger"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_antenna"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_antenna"));
            case "blaze" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick1", "part0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick2", "part1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick3", "part2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick4", "part3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick5", "part4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick6", "part5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick7", "part6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick8", "part7"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick9", "part8"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick10", "part9"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick11", "part10"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick12", "part11"));
            case "cat", "cat_collar", "ocelot" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "tail1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg"));
            case "chicken" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bill", "beak"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chin", "red_thing"));
            case "cod" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "tail_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_back", "top_fin"));
            case "dolphin" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", List.of("head", "tail", "right_fin", "left_fin", "back_fin")), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "tail", "tail_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", "nose"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_fin"));
            case "elder_guardian", "guardian" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("tail1", "tail0", "tail1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail2", "tail1", "tail2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail3", "tail2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("eye", "spike0", "spike1", "spike2", "spike3", "spike4", "spike5", "spike6", "spike7", "spike8", "spike9", "spike10", "spike11", "tail0")), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_fin", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_fin", "left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_fin", "back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine1", "spike0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine2", "spike1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine3", "spike2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine4", "spike3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine5", "spike4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine6", "spike5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine7", "spike6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine8", "spike7"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine9", "spike8"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine10", "spike9"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine11", "spike10"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine12", "spike11"));
            case "endermite" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body1", "segment0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body2", "segment1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body3", "segment2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body4", "segment3"));
            case "evoker_fangs" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("base"), EMFOptiFinePartNameMappings.getOptifineMapEntry("upper_jaw"), EMFOptiFinePartNameMappings.getOptifineMapEntry("lower_jaw"));
            case "fox" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", "tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"));
            case "frog" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("eyes")), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", List.of("head", "tongue", "left_arm", "right_arm", "croaking_body")), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("croaking_body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tongue"), EMFOptiFinePartNameMappings.getOptifineMapEntry("eyes"));
            case "goat" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("left_horn", "right_horn", "nose")), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_horn"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_horn"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"));
            case "hoglin", "zoglin" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("left_ear", "right_ear")), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", "mane"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mane"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"));
            case "magma_cube" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("core", "inside_cube"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment1", "cube0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment2", "cube1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment3", "cube2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment4", "cube3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment5", "cube4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment6", "cube5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment7", "cube6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment8", "cube7"));
            case "phantom" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", List.of("tail_base", "left_wing_base", "right_wing_base")), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "tail_base", "tail_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail2", "tail_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing", "left_wing_base", "left_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing", "right_wing_base", "right_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing_tip"));
            case "parrot", "parrot_b", "parrot_c" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", "feather"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
            case "puffer_fish_big" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_blue_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_blue_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_top", "top_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_middle_top", "top_middle_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_top", "top_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_right", "right_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_left", "left_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_bottom", "bottom_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_middle_bottom", "bottom_middle_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_bottom", "bottom_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_right", "right_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_left", "left_back_fin"));
            case "puffer_fish_medium" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_blue_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_blue_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_top", "top_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_top", "top_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_right", "right_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_left", "left_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_bottom", "bottom_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_bottom", "bottom_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_right", "right_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_left", "left_back_fin"));
            case "puffer_fish_small" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("eye_right", "right_eye"), EMFOptiFinePartNameMappings.getOptifineMapEntry("eye_left", "left_eye"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "back_fin"));
            case "rabbit" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_foot", "left_hind_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_foot", "right_hind_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_thigh", "left_haunch"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_thigh", "right_haunch"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"));
            case "ravager" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", "mouth"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("jaw"), EMFOptiFinePartNameMappings.getOptifineMapEntry("neck", "neck", "head"));
            case "salmon" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body_front", "body_front", "top_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body_back", "body_back", List.of("back_fin", "top_back_fin")), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_back_1", "top_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_back_2", "top_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"));
            case "shulker" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"));
            case "silverfish" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body1", "segment0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body2", "segment1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body3", "segment2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body4", "segment3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body5", "segment4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body6", "segment5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body7", "segment6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("wing1", "layer0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("wing2", "layer1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("wing3", "layer2"));
            case "slime" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "cube"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_eye"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_eye"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mouth"));
            case "slime_outer" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "cube"));
            case "snow_golem" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "upper_body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body_bottom", "lower_body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_hand", "left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_hand", "right_arm"));
            case "strider", "strider_saddle" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", List.of("right_top_bristle", "right_middle_bristle", "right_bottom_bristle", "left_top_bristle", "left_middle_bristle", "left_bottom_bristle")), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_right_top", "right_top_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_right_middle", "right_middle_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_right_bottom", "right_bottom_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_left_top", "left_top_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_left_middle", "left_middle_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_left_bottom", "left_bottom_bristle"));
            case "tadpole" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "root", "tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"));
            case "tropical_fish_a", "tropical_fish_pattern_a" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_top", "top_fin"));
            case "tropical_fish_b", "tropical_fish_pattern_b" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_top", "top_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_bottom", "bottom_fin"));
            case "turtle" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body2", "egg_belly"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"));
            case "warden" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "bone", List.of("body", "right_leg", "left_leg")), EMFOptiFinePartNameMappings.getOptifineMapEntry("torso", "body", List.of("head", "right_arm", "left_arm", "right_ribcage", "left_ribcage")), EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("right_tendril", "left_tendril")), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_tendril"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_tendril"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ribcage"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ribcage"));
            case "witch" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", List.of("hat", "nose")), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat", "hat_rim"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear2", "hat_rim"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bodywear", "jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body", "jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("arms"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose", "nose", "mole"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mole"));
            case "wither", "wither_armor" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body1", "shoulders"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body2", "ribcage"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body3", "tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head1", "center_head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head2", "right_head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head3", "left_head"));
            case "dragon" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head", "jaw"), EMFOptiFinePartNameMappings.getOptifineMapEntry("jaw", "jaw"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine", "neck"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing", "left_wing", "left_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing_tip", "left_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing", "right_wing", "right_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing_tip", "right_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg", "left_front_leg_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_shin", "left_front_leg_tip", "left_front_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_foot", "left_front_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg", "left_hind_leg_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_shin", "left_hind_leg_tip", "left_hind_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_foot", "left_hind_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg", "right_front_leg_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_shin", "right_front_leg_tip", "right_front_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_foot", "right_front_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg", "right_hind_leg_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_shin", "right_hind_leg_tip", "right_hind_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_foot", "right_hind_foot"));
            case "player", "player_slim" -> genericPlayerBiped;
            default -> {
                if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                    EMFUtils.EMFModError("no model part mapping found for: " + mobName);
                }
                yield UNKNOWN_MODEL_MAP_CACHE.containsKey(mobName) ? UNKNOWN_MODEL_MAP_CACHE.get(mobName) : Map.of();
            }
        };
    }

    public static Map<String, PartAndChildName> createMapForModdedOrUnknownEntityModel(ModelPart originalModel, String mobName) {
        HashMap<String, PartAndChildName> newMap = new HashMap<String, PartAndChildName>();
        HashMap<String, String> detailsMap = new HashMap<String, String>();
        EMFOptiFinePartNameMappings.mapThisAndChildren("root", originalModel, newMap, detailsMap);
        UNKNOWN_MODEL_MAP_CACHE.put(mobName, newMap);
        if (EMFConfig.getConfig().printUnknownModelsMode != EMFConfig.UnknownModelPrintMode.NONE) {
            StringBuilder mapString = new StringBuilder();
            mapString.append(" |-[optifine/cem/" + mobName + ".jem]\n");
            newMap.forEach((key, entry) -> {
                mapString.append(" | |-[" + ("root".equals(key) ? "(optional) " : "") + "part=" + key + (String)(entry.childNamesToExpect.isEmpty() ? "" : ", child_parts = " + entry.childNamesToExpect) + "]\n");
                mapString.append((String)detailsMap.get(key));
            });
            mapString.append("  \\-\\{{end of unknown model}}");
            EMFUtils.EMFModMessage("Unknown possibly modded model detected, Mapping now...\n" + mapString);
            if (EMFConfig.getConfig().printUnknownModelsMode == EMFConfig.UnknownModelPrintMode.LOG_AND_JEM) {
                EMFUtils.EMFModMessage("creating example .jem file for " + mobName);
                EMFJemData.EMFJemPrinter jemPrinter = new EMFJemData.EMFJemPrinter();
                for (Map.Entry entry2 : newMap.entrySet()) {
                    if ("root".equals(entry2.getKey())) continue;
                    EMFPartData.EMFPartPrinter partPrinter = new EMFPartData.EMFPartPrinter();
                    partPrinter.part = (String)entry2.getKey();
                    partPrinter.id = (String)entry2.getKey();
                    ModelPart vanillaModelPart = EMFOptiFinePartNameMappings.getChildByName((String)entry2.getKey(), originalModel);
                    if (vanillaModelPart != null) {
                        partPrinter.translate = new float[]{vanillaModelPart.f_104200_, vanillaModelPart.f_104201_, vanillaModelPart.f_104202_};
                        partPrinter.rotate = new float[]{(float)Math.toDegrees(vanillaModelPart.f_104203_), (float)Math.toDegrees(vanillaModelPart.f_104204_), (float)Math.toDegrees(vanillaModelPart.f_104205_)};
                        partPrinter.scale = vanillaModelPart.f_233553_;
                        List<ModelPart.Cube> cuboids = ((ModelPartAccessor)vanillaModelPart).getCuboids();
                        for (ModelPart.Cube cube : cuboids) {
                            EMFBoxData.EMFBoxPrinter boxPrinter = new EMFBoxData.EMFBoxPrinter();
                            boxPrinter.coordinates = new float[]{cube.f_104335_ - vanillaModelPart.m_233566_().f_171405_, cube.f_104336_ - vanillaModelPart.m_233566_().f_171406_, cube.f_104337_ - vanillaModelPart.m_233566_().f_171407_, cube.f_104338_ - cube.f_104335_, cube.f_104339_ - cube.f_104336_, cube.f_104340_ - cube.f_104337_};
                            partPrinter.boxes = Arrays.copyOf(partPrinter.boxes, partPrinter.boxes.length + 1);
                            partPrinter.boxes[partPrinter.boxes.length - 1] = boxPrinter;
                        }
                    }
                    jemPrinter.models.add(partPrinter);
                }
                String path = EMFVersionDifferenceManager.getConfigDirectory().toFile().getParent() + "/emf/unknown_cem/" + mobName + ".jem";
                File outFile = new File(path);
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                try {
                    FileWriter fileWriter = new FileWriter(outFile);
                    fileWriter.write(gson.toJson((Object)jemPrinter));
                    fileWriter.close();
                    EMFUtils.EMFModMessage(".jem file creation succeeded for [" + path + "]");
                }
                catch (IOException e) {
                    EMFUtils.EMFModMessage(".jem file creation failed for [" + path + "]");
                }
            }
        }
        return newMap;
    }

    private static ModelPart getChildByName(String name, ModelPart part) {
        if (part.m_233562_(name)) {
            return part.m_171324_(name);
        }
        for (ModelPart childPart : ((ModelPartAccessor)part).getChildren().values()) {
            ModelPart possibleReturn = EMFOptiFinePartNameMappings.getChildByName(name, childPart);
            if (possibleReturn == null) continue;
            return possibleReturn;
        }
        return null;
    }

    private static void mapThisAndChildren(String partName, ModelPart originalModel, Map<String, PartAndChildName> newMap, Map<String, String> detailsMap) {
        ArrayList<String> childrenList = new ArrayList<String>();
        for (Map.Entry<String, ModelPart> entry : ((ModelPartAccessor)originalModel).getChildren().entrySet()) {
            childrenList.add(entry.getKey());
            EMFOptiFinePartNameMappings.mapThisAndChildren(entry.getKey(), entry.getValue(), newMap, detailsMap);
        }
        newMap.put(partName, new PartAndChildName(partName, childrenList));
        if (EMFConfig.getConfig().printUnknownModelsMode != EMFConfig.UnknownModelPrintMode.NONE) {
            detailsMap.put(partName, " | | |-pivots=" + originalModel.f_104200_ + ", " + originalModel.f_104201_ + ", " + originalModel.f_104202_ + "\n | | |-rotations=" + Math.toDegrees(originalModel.f_104203_) + ", " + Math.toDegrees(originalModel.f_104204_) + ", " + Math.toDegrees(originalModel.f_104205_) + "\n | | |-scales=" + originalModel.f_233553_ + ", " + originalModel.f_233554_ + ", " + originalModel.f_233555_ + "\n | |  \\visibles=" + originalModel.f_104207_ + ", " + originalModel.f_233556_ + "\n");
        }
    }

    public record PartAndChildName(@NotNull String partName, @NotNull List<String> childNamesToExpect) {
    }
}

