/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.mixin.rendering;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WolfCollarLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Wolf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_model_features.EMF;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.IEMFModel;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFWolfCollarHolder;

@Mixin(value={WolfCollarLayer.class})
public abstract class MixinWolfCollarFeatureRenderer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    @Unique
    private static final ModelLayerLocation emf$collar_layer = new ModelLayerLocation(new ResourceLocation("minecraft", "wolf"), "collar");

    public MixinWolfCollarFeatureRenderer(RenderLayerParent<Wolf, WolfModel<Wolf>> context) {
        super(context);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void setEmf$Model(RenderLayerParent<?, ?> featureRendererContext, CallbackInfo ci) {
        if (EMF.testForForgeLoadingError()) {
            return;
        }
        ModelPart collarModel = EMFManager.getInstance().injectIntoModelRootGetter(emf$collar_layer, WolfModel.m_171088_().m_171564_());
        if (collarModel instanceof EMFModelPartRoot || ((IEMFModel)featureRendererContext.m_7200_()).emf$isEMFModel()) {
            try {
                EntityModel entityModel = featureRendererContext.m_7200_();
                if (entityModel instanceof EMFWolfCollarHolder) {
                    EMFWolfCollarHolder holder = (EMFWolfCollarHolder)entityModel;
                    holder.emf$setCollarModel(new WolfModel(collarModel));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/passive/WolfEntity;FFFFFF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/feature/WolfCollarFeatureRenderer;renderModel(Lnet/minecraft/client/render/entity/model/EntityModel;Lnet/minecraft/util/Identifier;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFF)V"), index=0)
    private EntityModel<?> emf$injectModel(EntityModel<?> par1) {
        EMFWolfCollarHolder holder;
        EntityModel entityModel = this.m_117386_();
        if (entityModel instanceof EMFWolfCollarHolder && (holder = (EMFWolfCollarHolder)entityModel).emf$hasCollarModel()) {
            holder.emf$getCollarModel().f_102608_ = par1.f_102608_;
            holder.emf$getCollarModel().f_102609_ = par1.f_102609_;
            holder.emf$getCollarModel().f_102610_ = par1.f_102610_;
            return holder.emf$getCollarModel();
        }
        return par1;
    }
}

