/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.utils.EMFUtils;

public class MathConstant
extends MathValue
implements MathComponent {
    public static final MathConstant ZERO_CONST = new MathConstant(0.0f);
    private final float hardCodedValue;

    public MathConstant(float number, boolean isNegative) {
        this.hardCodedValue = isNegative ? -number : number;
    }

    public MathConstant(float number) {
        this.hardCodedValue = number;
    }

    @Override
    public MathValue.ResultSupplier getResultSupplier() {
        EMFUtils.logError("EMF math constant called supplier: this shouldn't happen!");
        return () -> this.hardCodedValue;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public MathValue getNegative() {
        return new MathConstant(-this.hardCodedValue);
    }

    public String toString() {
        return String.valueOf(this.getResult());
    }

    @Override
    public float getResult() {
        return this.hardCodedValue;
    }
}

