/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.mixin.accessor.PlayerSkinProviderAccessor;
import traben.entity_texture_features.mixin.accessor.PlayerSkinTextureAccessor;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolOutcome
extends ETFConfigScreen {
    private final boolean didSucceed;
    private final NativeImage skin;

    protected ETFConfigScreenSkinToolOutcome(Screen parent, boolean success, NativeImage skin) {
        super(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result"), parent);
        this.didSucceed = success;
        this.skin = skin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean uploadSkin(boolean skinType) {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            if ("127.0.0.1".equals(InetAddress.getLocalHost().getHostAddress())) {
                boolean bl2 = false;
                return bl2;
            }
            String auth = Minecraft.m_91087_().m_91094_().m_92547_();
            HttpPost http = new HttpPost("https://api.minecraftservices.com/minecraft/profile/skins");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("variant", skinType ? "classic" : "slim", ContentType.TEXT_PLAIN);
            assert (ETFClientCommon.CONFIG_DIR != null);
            builder.addBinaryBody("file", (InputStream)new FileInputStream(Path.of(ETFClientCommon.CONFIG_DIR.getParent(), "\\ETF_player_skin_printout.png").toFile()), ContentType.IMAGE_PNG, "skin.png");
            http.setEntity(builder.build());
            http.addHeader("Authorization", "Bearer " + auth);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)http);
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.55), (int)((double)this.f_96544_ * 0.9), (int)((double)this.f_96543_ * 0.2), 20, CommonComponents.f_130655_, button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parent)));
        if (this.didSucceed) {
            this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.15), (int)((double)this.f_96544_ * 0.6), (int)((double)this.f_96543_ * 0.7), 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.open"), button -> {
                try {
                    assert (ETFClientCommon.CONFIG_DIR != null);
                    Path outputDirectory = Path.of(ETFClientCommon.CONFIG_DIR.getParent(), new String[0]);
                    Util.m_137581_().m_137644_(outputDirectory.toFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.15), (int)((double)this.f_96544_ * 0.4), (int)((double)this.f_96543_ * 0.7), 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin"), button -> {
                boolean changeSuccess;
                String skinTypeData;
                PlayerInfo playerListEntry;
                boolean skinType = true;
                if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().m_91403_() != null && (playerListEntry = Minecraft.m_91087_().m_91403_().m_104949_(Minecraft.m_91087_().f_91074_.m_20148_())) != null && (skinTypeData = ((MinecraftProfileTexture)Minecraft.m_91087_().m_91109_().m_118815_(playerListEntry.m_105312_()).get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model")) != null) {
                    skinType = !"slim".equals(skinTypeData);
                }
                button.m_93666_(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin_v2." + ((changeSuccess = ETFConfigScreenSkinToolOutcome.uploadSkin(skinType)) ? "success" : "fail")));
                if (changeSuccess) {
                    HttpTexture skinfile = (HttpTexture)((PlayerSkinProviderAccessor)Minecraft.m_91087_().m_91109_()).getTextureManager().m_174786_(Minecraft.m_91087_().f_91074_.m_108560_(), null);
                    try {
                        this.skin.m_85056_(((PlayerSkinTextureAccessor)skinfile).getCacheFile());
                    }
                    catch (IOException e) {
                        ETFUtils2.logError(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin.success_local_fail").getString(), true);
                    }
                    if (Minecraft.m_91087_().f_91074_ != null) {
                        ETFManager.getInstance().PLAYER_TEXTURE_MAP.removeEntryOnly(Minecraft.m_91087_().f_91074_.m_20148_());
                    }
                }
                button.f_93623_ = false;
            }));
        }
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        String[] strings = ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result." + (this.didSucceed ? "success" : "fail")).getString().split("\n");
        ArrayList<Component> lines = new ArrayList<Component>();
        for (String str : strings) {
            lines.add(Component.m_130674_((String)str.strip()));
        }
        int i = 0;
        for (Component txt : lines) {
            ETFConfigScreenSkinToolOutcome.m_168749_((PoseStack)matrices, (Font)this.f_96547_, (FormattedCharSequence)txt.m_7532_(), (int)((int)((double)this.f_96543_ * 0.5)), (int)((int)((double)this.f_96544_ * 0.3) + i), (int)0xFFFFFF);
            i += txt.getString().isBlank() ? 5 : 10;
        }
    }
}

