/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.etf_properties;

import java.util.Properties;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vindicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.BooleanProperty;
import traben.entity_texture_features.utils.ETFEntity;

public class AngryProperty
extends BooleanProperty {
    protected AngryProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        super(AngryProperty.getGenericBooleanThatCanNull(properties, propertyNum, "angry", "isAngry", "is_angry", "aggressive", "is_aggressive"));
    }

    public static AngryProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new AngryProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    @Nullable
    protected Boolean getValueFromEntity(ETFEntity etfEntity) {
        if (etfEntity != null) {
            if (etfEntity instanceof EnderMan) {
                EnderMan enderman = (EnderMan)etfEntity;
                return enderman.m_32531_();
            }
            if (etfEntity instanceof Blaze) {
                Blaze blaze = (Blaze)etfEntity;
                return blaze.m_6060_();
            }
            if (etfEntity instanceof Guardian) {
                Guardian guardian = (Guardian)etfEntity;
                return guardian.m_32856_() != null;
            }
            if (etfEntity instanceof Vindicator) {
                Vindicator vindicator = (Vindicator)etfEntity;
                return vindicator.m_5912_();
            }
            if (etfEntity instanceof SpellcasterIllager) {
                SpellcasterIllager caster = (SpellcasterIllager)etfEntity;
                return caster.m_33736_();
            }
            if (etfEntity instanceof NeutralMob) {
                NeutralMob angry = (NeutralMob)etfEntity;
                return angry.m_21660_();
            }
        }
        return null;
    }

    @Override
    public boolean isPropertyUpdatable() {
        return true;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"angry", "isAngry", "is_angry", "aggressive", "is_aggressive"};
    }
}

