/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.renderer;

import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.features.ETFManager;

@Mixin(value={EntityRenderer.class})
public abstract class MixinEntityRenderer<T extends Entity> {
    @Inject(method={"getLight"}, at={@At(value="RETURN")}, cancellable=true)
    private void etf$vanillaLightOverrideCancel(T entity, float tickDelta, CallbackInfoReturnable<Integer> cir) {
        if (ETFConfig.getInstance().enableCustomTextures && ETFManager.getInstance().ENTITY_TYPE_VANILLA_BRIGHTNESS_OVERRIDE_VALUE.containsKey((Object)entity.m_6095_())) {
            int overrideLightValue = ETFManager.getInstance().ENTITY_TYPE_VANILLA_BRIGHTNESS_OVERRIDE_VALUE.getInt((Object)entity.m_6095_());
            cir.setReturnValue((Object)this.etf$getLight(entity, tickDelta, overrideLightValue));
        }
    }

    @Unique
    public final int etf$getLight(T entity, float tickDelta, int overrideLight) {
        BlockPos blockPos = new BlockPos(entity.m_7371_(tickDelta));
        return LightTexture.m_109885_((int)Math.max(this.etf$getBlockLight(entity, blockPos), overrideLight), (int)this.etf$getSkyLight(entity, blockPos));
    }

    @Unique
    protected int etf$getSkyLight(T entity, BlockPos pos) {
        return ((Entity)entity).f_19853_.m_45517_(LightLayer.SKY, pos);
    }

    @Unique
    protected int etf$getBlockLight(T entity, BlockPos pos) {
        return entity.m_6060_() ? 15 : ((Entity)entity).f_19853_.m_45517_(LightLayer.BLOCK, pos);
    }
}

