/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties;

import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.EntityBooleanLRU;

public abstract class RandomProperty {
    protected final EntityBooleanLRU entityCachedInitialResult = new EntityBooleanLRU();
    private boolean canUpdate = true;

    @NotNull
    public static String readPropertiesOrThrow(Properties properties, int propertyNum, String ... propertyId) throws RandomPropertyException {
        if (propertyId.length == 0) {
            throw new IllegalArgumentException("[ETF] readPropertiesOrThrow() was given empty property id's");
        }
        for (String id : propertyId) {
            String dataFromProps;
            if (!properties.containsKey(id + "." + propertyNum) || (dataFromProps = properties.getProperty(id + "." + propertyNum).strip()).isBlank()) continue;
            return dataFromProps;
        }
        throw new RandomPropertyException("failed to read property [" + propertyId[0] + "]");
    }

    public boolean testEntity(ETFEntity entity, boolean isUpdate) {
        if (isUpdate && !this.canPropertyUpdate()) {
            return this.entityCachedInitialResult.getBoolean(entity.etf$getUuid());
        }
        try {
            return this.testEntityInternal(entity);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    protected abstract boolean testEntityInternal(ETFEntity var1);

    public final boolean canPropertyUpdate() {
        return this.canUpdate;
    }

    public void setCanUpdate(boolean canUpdate) {
        this.canUpdate = canUpdate;
    }

    @NotNull
    public abstract String[] getPropertyIds();

    @NotNull
    public String getPropertyId() {
        return this.getPropertyIds()[0];
    }

    protected abstract String getPrintableRuleInfo();

    public String toString() {
        return this.getClass().getSimpleName() + "[Property: " + this.getPropertyId() + ", Rule: " + this.getPrintableRuleInfo() + "]";
    }

    public void cacheEntityInitialResult(ETFEntity entity) {
        this.entityCachedInitialResult.put(entity.etf$getUuid(), this.testEntityInternal(entity));
    }

    public static class RandomPropertyException
    extends Exception {
        public RandomPropertyException(String reason) {
            super("[ETF] " + reason);
        }
    }
}

