/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;

public class BlocksProperty
extends StringArrayOrRegexProperty {
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_MAP_PRINTER = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            Property<?> property = entry.getKey();
            String var10000 = property.m_61708_();
            return var10000 + "=" + this.nameValue(property, entry.getValue());
        }

        private <T extends Comparable<T>> String nameValue(Property<T> property, Comparable<?> value) {
            return property.m_6940_(value);
        }
    };
    protected final Function<BlockState, Boolean> blockStateMatcher;
    protected final boolean botherWithDeepStateCheck;

    protected BlocksProperty(Properties properties, int propertyNum, String[] ids) throws RandomProperty.RandomPropertyException {
        super(BlocksProperty.readPropertiesOrThrow(properties, propertyNum, ids).replaceAll("(?<=(^| ))minecraft:", ""));
        if (this.usesRegex) {
            this.blockStateMatcher = blockState -> {
                if (this.MATCHER.testString(BlocksProperty.getFromStateBlockNameOnly(blockState))) {
                    return true;
                }
                return this.MATCHER.testString(BlocksProperty.getFromStateBlockNameWithStateData(blockState));
            };
            this.botherWithDeepStateCheck = false;
        } else {
            this.blockStateMatcher = this::testBlocks;
            boolean hasStateNeeds = false;
            for (String s : this.ARRAY) {
                if (!s.contains(":")) continue;
                hasStateNeeds = true;
                break;
            }
            this.botherWithDeepStateCheck = hasStateNeeds;
        }
    }

    public static BlocksProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new BlocksProperty(properties, propertyNum, new String[]{"blocks", "block"});
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    protected static String getFromStateBlockNameOnly(BlockState state) {
        return Registry.f_122824_.m_7981_((Object)state.m_60734_()).toString().replaceFirst("minecraft:", "");
    }

    private static String getFromStateBlockNameWithStateData(BlockState state) {
        Object block = BlocksProperty.getFromStateBlockNameOnly(state);
        if (!state.m_61148_().isEmpty()) {
            block = (String)block + ":" + state.m_61148_().entrySet().stream().map(PROPERTY_MAP_PRINTER).collect(Collectors.joining(":"));
        }
        if (((String)block).startsWith("minecraft:")) {
            return ((String)block).replaceFirst("minecraft:", "");
        }
        return block;
    }

    protected boolean testBlocks(BlockState blockState) {
        if (this.MATCHER.testString(BlocksProperty.getFromStateBlockNameOnly(blockState))) {
            return true;
        }
        if (this.botherWithDeepStateCheck) {
            String fullBlockState = BlocksProperty.getFromStateBlockNameWithStateData(blockState);
            for (String string : this.ARRAY) {
                if (!string.contains(":")) continue;
                boolean matchesAllStateDataNeeded = true;
                for (String split : string.split(":")) {
                    if (fullBlockState.contains(split)) continue;
                    matchesAllStateDataNeeded = false;
                    break;
                }
                if (!matchesAllStateDataNeeded) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return true;
    }

    @Override
    public boolean testEntityInternal(ETFEntity entity) {
        BlockState[] entityBlocks;
        if (entity.etf$getUuid().getLeastSignificantBits() == 0x303900003039L) {
            entityBlocks = new BlockState[]{Blocks.f_50085_.m_49966_()};
        } else if (entity instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)entity;
            entityBlocks = blockEntity.m_58904_() == null ? new BlockState[]{blockEntity.m_58900_()} : new BlockState[]{blockEntity.m_58900_(), blockEntity.m_58904_().m_8055_(blockEntity.m_58899_().m_7495_())};
        } else {
            if (entity.etf$getWorld() == null || entity.etf$getBlockPos() == null) {
                return false;
            }
            Level world = entity.etf$getWorld();
            BlockPos pos = entity.etf$getBlockPos();
            entityBlocks = new BlockState[]{world.m_8055_(pos), world.m_8055_(pos.m_7495_())};
        }
        for (BlockState entityBlock : entityBlocks) {
            if (!this.blockStateMatcher.apply(entityBlock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getValueFromEntity(ETFEntity etfEntity) {
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"blocks", "block"};
    }
}

