/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;

public class NameProperty
extends StringArrayOrRegexProperty {
    protected NameProperty(String data) throws RandomProperty.RandomPropertyException {
        super(data);
    }

    public static NameProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            String dataFromProperty = NameProperty.readPropertiesOrThrow(properties, propertyNum, "name", "names");
            ArrayList<String> names = new ArrayList<String>();
            if (dataFromProperty.isBlank()) {
                throw new RandomProperty.RandomPropertyException("Name failed");
            }
            if (dataFromProperty.startsWith("regex:") || dataFromProperty.startsWith("pattern:")) {
                names.add(dataFromProperty);
            } else {
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(dataFromProperty);
                while (m.find()) {
                    names.add(m.group(1).replace("\"", "").trim());
                }
            }
            StringBuilder builder = new StringBuilder();
            for (String str : names) {
                builder.append(str).append(" ");
            }
            return new NameProperty(builder.toString().trim());
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return false;
    }

    @Override
    @Nullable
    public String getValueFromEntity(ETFEntity etfEntity) {
        Component entityNameText;
        Player player;
        if (etfEntity instanceof Player && (player = (Player)etfEntity).m_7755_() != null) {
            return player.m_7755_().getString();
        }
        if (etfEntity.etf$hasCustomName() && (entityNameText = etfEntity.etf$getCustomName()) != null) {
            ComponentContents content = entityNameText.m_214077_();
            if (content instanceof LiteralContents) {
                LiteralContents literal = (LiteralContents)content;
                return literal.f_237368_();
            }
            return entityNameText.getString();
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"name", "names"};
    }
}

